/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.admin.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationError;
import nl.tailormap.viewer.admin.stripes.ApplicationActionBean;
import nl.tailormap.viewer.config.ClobElement;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.app.ConfiguredAttribute;
import nl.tailormap.viewer.config.services.AttributeDescriptor;
import nl.tailormap.viewer.config.services.FeatureSource;
import nl.tailormap.viewer.config.services.FeatureTypeRelation;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.config.services.SimpleFeatureType;
import nl.tailormap.viewer.config.services.StyleLibrary;
import nl.tailormap.viewer.config.services.WMSService;
import nl.tailormap.viewer.helpers.featuresources.FeatureSourceFactoryHelper;
import nl.tailormap.viewer.helpers.featuresources.SimpleFeatureTypeHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/applicationtreelayer")
@StrictBinding
@RolesAllowed(value={"Admin", "ApplicationAdmin"})
public class ApplicationTreeLayerActionBean
extends ApplicationActionBean {
    private static final String JSP = "/WEB-INF/jsp/application/applicationTreeLayer.jsp";
    private static final String ATTRIBUTES_CONFIG_KEY = "attributeConfig";
    private static final String ATTRIBUTES_ORDER_KEY = "attributeOrder";
    @Validate
    private ApplicationLayer applicationLayer;
    @Validate
    private List<String> groupsRead = new ArrayList();
    @Validate
    private List<String> groupsWrite = new ArrayList();
    @Validate
    private Map<String, String> details = new HashMap();
    @Validate
    private List<String> selectedAttributes = new ArrayList();
    private Map<String, String> attributeAliases = new HashMap();
    private List<Map<String, String>> styles = new ArrayList();
    private JSONObject stylesTitleJson = new JSONObject();
    private boolean editable;
    private Long appLayerFeatureType;
    @Validate
    private JSONObject attributesJSON = new JSONObject();
    private JSONArray attributesConfig = new JSONArray();
    @Validate(on={"getUniqueValues"})
    private String attribute;
    private String displayName;

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution(JSP);
    }

    @Before
    public void loadInfo() throws JSONException {
        Layer layer = this.applicationLayer.getService().getSingleLayer(this.applicationLayer.getLayerName(), Stripersist.getEntityManager());
        if (layer == null) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.applicationtreelayeractionbean.notfound"), new Object[0]));
            return;
        }
        for (StyleLibrary sld : layer.getService().getStyleLibraries()) {
            JSONObject sldNamedLayerJson;
            HashMap<String, CallSite> style = new HashMap<String, CallSite>();
            JSONObject styleTitleJson = new JSONObject();
            style.put("id", (CallSite)((Object)("sld:" + sld.getId())));
            style.put("title", (CallSite)((Object)("SLD style: " + sld.getTitle() + (sld.isDefaultStyle() ? " (default)" : ""))));
            if (sld.getNamedLayerUserStylesJson() != null && (sldNamedLayerJson = new JSONObject(sld.getNamedLayerUserStylesJson())).has(layer.getName())) {
                JSONObject userStyle;
                JSONArray userStyles;
                JSONObject namedLayer = sldNamedLayerJson.getJSONObject(layer.getName());
                if (namedLayer.has("title")) {
                    styleTitleJson.put("namedLayerTitle", namedLayer.get("title"));
                }
                if ((userStyles = namedLayer.getJSONArray("styles")).length() > 0 && (userStyle = userStyles.getJSONObject(0)).has("title")) {
                    styleTitleJson.put("styleTitle", userStyle.get("title"));
                }
            }
            this.styles.add(style);
            this.stylesTitleJson.put((String)style.get("id"), (Object)styleTitleJson);
        }
        if (this.applicationLayer.getService() instanceof WMSService && layer.getDetails().containsKey("wms.styles")) {
            JSONArray wmsStyles = new JSONArray(((ClobElement)layer.getDetails().get("wms.styles")).getValue());
            for (int i = 0; i < wmsStyles.length(); ++i) {
                JSONObject wmsStyle = wmsStyles.getJSONObject(i);
                HashMap<String, CallSite> style = new HashMap<String, CallSite>();
                style.put("id", (CallSite)((Object)("wms:" + wmsStyle.getString("name"))));
                style.put("title", (CallSite)((Object)("WMS server style: " + wmsStyle.getString("name") + (String)(wmsStyle.has("title") ? " (" + wmsStyle.getString("title") + ")" : ""))));
                JSONObject styleTitleJson = new JSONObject();
                styleTitleJson.put("styleTitle", (Object)(wmsStyle.has("title") ? wmsStyle.getString("title") : wmsStyle.getString("name")));
                styleTitleJson.put("name", (Object)wmsStyle.getString("name"));
                this.styles.add(style);
                this.stylesTitleJson.put((String)style.get("id"), (Object)styleTitleJson);
            }
        }
        if (!this.styles.isEmpty()) {
            ArrayList temp = new ArrayList();
            HashMap<String, String> s = new HashMap<String, String>();
            s.put("id", "registry_default");
            s.put("title", this.getBundle().getString("viewer_admin.applicationtreelayeractionbean.defstyle"));
            temp.add(s);
            s = new HashMap();
            s.put("id", "none");
            s.put("title", this.getBundle().getString("viewer_admin.applicationtreelayeractionbean.nodefstyle"));
            temp.add(s);
            temp.addAll(this.styles);
            this.styles = temp;
        }
        if (layer.getFeatureType() != null && !layer.getFeatureType().getAttributes().isEmpty()) {
            SimpleFeatureType sft = layer.getFeatureType();
            this.editable = sft.isWriteable();
            this.appLayerFeatureType = sft.getId();
        }
    }

    @Before
    public void synchronizeFeatureType() throws JSONException {
        SimpleFeatureTypeHelper.synchronizeFeaturetype((ApplicationLayer)this.applicationLayer, (EntityManager)Stripersist.getEntityManager(), (ActionBeanContext)this.context, (ResourceBundle)this.getBundle(), (Map)this.attributeAliases, (boolean)false);
        Layer layer = this.applicationLayer.getService().getSingleLayer(this.applicationLayer.getLayerName(), Stripersist.getEntityManager());
        if (layer != null && layer.getFeatureType() != null && !layer.getFeatureType().getAttributes().isEmpty()) {
            if (this.attributesJSON.has(ATTRIBUTES_CONFIG_KEY)) {
                this.attributesConfig = this.attributesJSON.getJSONArray(ATTRIBUTES_CONFIG_KEY);
            } else {
                this.attributesConfig = new JSONArray();
                this.makeAttributeJSONArray(layer.getFeatureType());
            }
        }
    }

    @DontValidate
    public Resolution edit() throws JSONException {
        if (this.applicationLayer != null) {
            this.details = new HashMap();
            for (Map.Entry e : this.applicationLayer.getDetails().entrySet()) {
                this.details.put((String)e.getKey(), ((ClobElement)e.getValue()).getValue());
            }
            this.groupsRead.addAll(this.applicationLayer.getReaders());
            this.groupsWrite.addAll(this.applicationLayer.getWriters());
            for (ConfiguredAttribute ca : this.applicationLayer.getAttributes()) {
                if (!ca.isVisible()) continue;
                this.selectedAttributes.add(ca.getFullName());
            }
        }
        return new ForwardResolution(JSP);
    }

    private void sortPerFeatureType(SimpleFeatureType layerSft, List<ConfiguredAttribute> cas) {
        List relations = layerSft.getRelations();
        for (FeatureTypeRelation relation : relations) {
            SimpleFeatureType foreign = relation.getForeignFeatureType();
            this.sortPerFeatureType(foreign, cas);
        }
    }

    public Resolution attributes() throws JSONException {
        this.attributesConfig = new JSONArray();
        Layer layer = this.applicationLayer.getService().getSingleLayer(this.applicationLayer.getLayerName(), Stripersist.getEntityManager());
        this.makeAttributeJSONArray(layer.getFeatureType());
        return new StreamingResolution("application/json", (Reader)new StringReader(this.attributesConfig.toString()));
    }

    private void makeAttributeJSONArray(SimpleFeatureType layerSft) throws JSONException {
        List cas = this.applicationLayer.getAttributes();
        if (layerSft != null) {
            this.sortPerFeatureType(layerSft, cas);
        }
        for (ConfiguredAttribute ca : cas) {
            JSONObject j = ca.toJSONObject();
            SimpleFeatureType sft = ca.getFeatureType();
            if (sft == null) {
                sft = layerSft;
            }
            AttributeDescriptor ad = sft.getAttribute(ca.getAttributeName());
            j.put("alias", (Object)ad.getAlias());
            j.put("featureTypeAttribute", (Object)ad.toJSONObject());
            this.attributesConfig.put((Object)j);
        }
    }

    public Resolution getUniqueValues() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        try {
            Layer layer = this.applicationLayer.getService().getSingleLayer(this.applicationLayer.getLayerName(), Stripersist.getEntityManager());
            if (layer != null && layer.getFeatureType() != null) {
                SimpleFeatureType sft = layer.getFeatureType();
                List beh = FeatureSourceFactoryHelper.calculateUniqueValues((SimpleFeatureType)sft, (String)this.attribute, null);
                json.put("uniqueValues", (Object)new JSONArray((Collection)beh));
                json.put("success", (Object)Boolean.TRUE);
            }
        }
        catch (Exception e) {
            json.put("msg", (Object)e.toString());
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    public Resolution save() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        Arrays.asList("titleAlias", "legendImageUrl", "transparency", "influenceradius", "summary.title", "summary.image", "summary.texteditor", "summary.description", "summary.link", "editfunction.title", "style", "metadataurl", "summary.noHtmlEncode", "summary.nl2br", "summary.retrieveUploads", "editfeature.usernameAttribute", "editfeature.uploadDocument", "editfeature.uploadDocument.types", "stylesOrder").forEach(this.applicationLayer.getDetails().keySet()::remove);
        for (Map.Entry e : this.details.entrySet()) {
            if (e.getValue() == null) continue;
            this.applicationLayer.getDetails().put((String)e.getKey(), new ClobElement((String)e.getValue()));
        }
        this.applicationLayer.getReaders().clear();
        for (String groupName : this.groupsRead) {
            this.applicationLayer.getReaders().add(groupName);
        }
        this.applicationLayer.getWriters().clear();
        for (String groupName : this.groupsWrite) {
            this.applicationLayer.getWriters().add(groupName);
        }
        if (this.applicationLayer.getAttributes() != null && this.applicationLayer.getAttributes().size() > 0) {
            JSONArray attributeOrder = this.attributesJSON.getJSONArray(ATTRIBUTES_ORDER_KEY);
            List appAttributes = this.applicationLayer.getAttributes();
            this.applicationLayer.setAttributes(this.processAttributes(em, attributeOrder, this.attributesConfig, appAttributes));
        }
        em.persist((Object)this.applicationLayer);
        this.application.authorizationsModified();
        this.displayName = this.applicationLayer.getDisplayName(em);
        em.getTransaction().commit();
        this.attributesConfig = new JSONArray();
        Layer layer = this.applicationLayer.getService().getSingleLayer(this.applicationLayer.getLayerName(), em);
        this.makeAttributeJSONArray(layer.getFeatureType());
        this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.applicationtreelayeractionbean.layersaved"), new Object[0]));
        return this.edit();
    }

    protected List<ConfiguredAttribute> processAttributes(EntityManager em, JSONArray attributeOrder, JSONArray attributesConfig, List<ConfiguredAttribute> appAttributes) {
        HashMap<String, JSONObject> attributeOrderMap = new HashMap<String, JSONObject>();
        HashMap<String, JSONObject> attributeConfigMap = new HashMap<String, JSONObject>();
        for (Object o : attributeOrder) {
            JSONObject order = (JSONObject)o;
            attributeOrderMap.put(order.getString("longname"), order);
        }
        for (Object o : attributesConfig) {
            JSONObject config = (JSONObject)o;
            attributeConfigMap.put(config.getString("longname"), config);
        }
        for (ConfiguredAttribute appAttribute : appAttributes) {
            Long id;
            JSONObject configObject;
            JSONObject orderConfigObject = (JSONObject)attributeOrderMap.get(appAttribute.getLongName());
            if (orderConfigObject != null && orderConfigObject.has("checked")) {
                appAttribute.setVisible(orderConfigObject.getBoolean("checked"));
            } else {
                appAttribute.setVisible(false);
            }
            if (orderConfigObject != null && orderConfigObject.has("folder_label")) {
                appAttribute.setLabel(orderConfigObject.getString("folder_label"));
            }
            if ((configObject = (JSONObject)attributeConfigMap.get(appAttribute.getLongName())) == null) continue;
            if (configObject.has("editable")) {
                appAttribute.setEditable(configObject.getBoolean("editable"));
            }
            if (configObject.has("editAlias")) {
                appAttribute.setEditAlias(configObject.getString("editAlias"));
            }
            if (configObject.has("editvalues")) {
                appAttribute.setEditValues(configObject.get("editvalues").toString());
            }
            if (configObject.has("editHeight")) {
                appAttribute.setEditHeight(configObject.getString("editHeight"));
            }
            if (configObject.has("selectable")) {
                appAttribute.setSelectable(configObject.getBoolean("selectable"));
            }
            if (configObject.has("filterable")) {
                appAttribute.setFilterable(configObject.getBoolean("filterable"));
            }
            if (configObject.has("defaultValue")) {
                appAttribute.setDefaultValue(configObject.getString("defaultValue"));
            }
            if (configObject.has("valueListFeatureSource") && !configObject.isNull("valueListFeatureSource")) {
                id = configObject.getLong("valueListFeatureSource");
                FeatureSource fs = (FeatureSource)em.find(FeatureSource.class, (Object)id);
                appAttribute.setValueListFeatureSource(fs);
            }
            if (configObject.has("valueListFeatureType") && !configObject.isNull("valueListFeatureType")) {
                id = configObject.getLong("valueListFeatureType");
                SimpleFeatureType ft = (SimpleFeatureType)em.find(SimpleFeatureType.class, (Object)id);
                appAttribute.setValueListFeatureType(ft);
            }
            if (configObject.has("valueListValueAttribute") && !configObject.isNull("valueListValueAttribute")) {
                appAttribute.setValueListValueName(configObject.getString("valueListValueAttribute"));
            }
            if (configObject.has("valueListLabelAttribute") && !configObject.isNull("valueListLabelAttribute")) {
                appAttribute.setValueListLabelName(configObject.getString("valueListLabelAttribute"));
            }
            if (configObject.has("valueList") && !configObject.isNull("valueList")) {
                appAttribute.setValueList(configObject.getString("valueList"));
            }
            if (configObject.has("allowValueListOnly")) {
                appAttribute.setAllowValueListOnly(configObject.getBoolean("allowValueListOnly"));
            }
            if (configObject.has("disallowNullValue")) {
                appAttribute.setDisallowNullValue(configObject.getBoolean("disallowNullValue"));
            }
            boolean automaticValue = configObject.getBoolean("automaticValue");
            if (configObject.has("automaticValue")) {
                appAttribute.setAutomaticValue(automaticValue);
            }
            if (configObject.has("automaticValueType") && automaticValue) {
                appAttribute.setAutomaticValueType(configObject.optString("automaticValueType"));
            } else {
                appAttribute.setAutomaticValueType(null);
            }
            if (!configObject.has("disableUserEdit")) continue;
            appAttribute.setDisableUserEdit(configObject.getBoolean("disableUserEdit"));
        }
        ArrayList<ConfiguredAttribute> newOrder = new ArrayList<ConfiguredAttribute>();
        block3: for (Object o : attributeOrder) {
            JSONObject orderObject = (JSONObject)o;
            String longname = orderObject.getString("longname");
            for (ConfiguredAttribute appAttribute : appAttributes) {
                if (!appAttribute.getLongName().equals(longname)) continue;
                newOrder.add(appAttribute);
                continue block3;
            }
        }
        return newOrder;
    }

    public ApplicationLayer getApplicationLayer() {
        return this.applicationLayer;
    }

    public void setApplicationLayer(ApplicationLayer applicationLayer) {
        this.applicationLayer = applicationLayer;
    }

    public Map<String, String> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, String> details) {
        this.details = details;
    }

    public List<String> getSelectedAttributes() {
        return this.selectedAttributes;
    }

    public void setSelectedAttributes(List<String> selectedAttributes) {
        this.selectedAttributes = selectedAttributes;
    }

    public JSONObject getAttributesJSON() {
        return this.attributesJSON;
    }

    public void setAttributesJSON(JSONObject attributesJSON) {
        this.attributesJSON = attributesJSON;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public List<String> getGroupsWrite() {
        return this.groupsWrite;
    }

    public void setGroupsWrite(List<String> groupsWrite) {
        this.groupsWrite = groupsWrite;
    }

    public List<String> getGroupsRead() {
        return this.groupsRead;
    }

    public void setGroupsRead(List<String> groupsRead) {
        this.groupsRead = groupsRead;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public Map<String, String> getAttributeAliases() {
        return this.attributeAliases;
    }

    public void setAttributeAliases(Map<String, String> attributeAliases) {
        this.attributeAliases = attributeAliases;
    }

    public List<Map<String, String>> getStyles() {
        return this.styles;
    }

    public void setStyles(List<Map<String, String>> styles) {
        this.styles = styles;
    }

    public JSONObject getStylesTitleJson() {
        return this.stylesTitleJson;
    }

    public void setStylesTitleJson(JSONObject stylesTitleJson) {
        this.stylesTitleJson = stylesTitleJson;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Long getAppLayerFeatureType() {
        return this.appLayerFeatureType;
    }

    public void setAppLayerFeatureType(Long appLayerFeatureType) {
        this.appLayerFeatureType = appLayerFeatureType;
    }

    public JSONArray getAttributesConfig() {
        return this.attributesConfig;
    }

    public void setAttributesConfig(JSONArray attributesConfig) {
        this.attributesConfig = attributesConfig;
    }
}

