/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.admin.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationError;
import nl.tailormap.viewer.admin.stripes.ApplicationActionBean;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.app.ConfiguredAttribute;
import nl.tailormap.viewer.config.app.Level;
import nl.tailormap.viewer.config.app.StartLayer;
import nl.tailormap.viewer.config.app.StartLevel;
import nl.tailormap.viewer.config.services.AttributeDescriptor;
import nl.tailormap.viewer.config.services.Document;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.config.services.SimpleFeatureType;
import nl.tailormap.viewer.helpers.app.ApplicationHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/applicationtreelevel")
@StrictBinding
@RolesAllowed(value={"Admin", "ApplicationAdmin"})
public class ApplicationTreeLevelActionBean
extends ApplicationActionBean {
    private static final Log log = LogFactory.getLog(ApplicationTreeLevelActionBean.class);
    private static final String JSP = "/WEB-INF/jsp/application/applicationTreeLevel.jsp";
    @Validate
    @ValidateNestedProperties(value={@Validate(field="info", label="Info"), @Validate(field="name", label="Naam"), @Validate(field="url", label="url")})
    private Level level;
    private boolean layersAllowed;
    @Validate
    private List<String> groupsRead = new ArrayList();
    @Validate
    private String selectedlayers;
    @Validate
    private String selecteddocs;

    @DefaultHandler
    @DontValidate
    public Resolution view() {
        return new ForwardResolution(JSP);
    }

    public Resolution delete() {
        EntityManager em = Stripersist.getEntityManager();
        String error = this.deleteLevel(em, this.level);
        if (error != null) {
            this.getContext().getValidationErrors().add("niveau", (ValidationError)new SimpleError(error, new Object[0]));
        } else {
            Level parent = this.level.getParent();
            parent.getChildren().remove(this.level);
            em.persist((Object)parent);
            em.remove((Object)this.level);
            this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.applicationtreelevelactionbean.dellevel"), new Object[0]));
        }
        this.application.authorizationsModified();
        em.getTransaction().commit();
        return new ForwardResolution(JSP);
    }

    @DontValidate
    public Resolution edit() {
        Level rootLevel = this.application.getRoot();
        if (this.level != null) {
            this.groupsRead.addAll(this.level.getReaders());
            this.layersAllowed = this.level.isBackground() ? false : this.level.getParent() != null && !this.level.getParent().getId().equals(rootLevel.getId());
        }
        return new ForwardResolution(JSP);
    }

    @DontValidate
    public Resolution saveName() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        StringBuilder error = null;
        if (this.level == null) {
            error = new StringBuilder(this.getBundle().getString("viewer_admin.applicationtreelevelactionbean.nolevel"));
        } else if (this.level.getName() == null) {
            error = new StringBuilder(this.getBundle().getString("viewer_admin.applicationtreelevelactionbean.noname"));
        } else {
            try {
                EntityManager em = Stripersist.getEntityManager();
                em.persist((Object)this.level);
                em.getTransaction().commit();
                json.put("name", (Object)this.level.getName());
                json.put("success", (Object)Boolean.TRUE);
            }
            catch (Exception e) {
                log.error((Object)"Fout bij opslaan niveau", (Throwable)e);
                error = new StringBuilder(MessageFormat.format(this.getBundle().getString("viewer.applicationtreelevelactionbean.levelnosave"), e));
                Throwable t = e;
                while (t.getCause() != null) {
                    t = t.getCause();
                    error.append("; ").append(t);
                }
            }
        }
        if (error != null) {
            json.put("error", (Object)error.toString());
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    @DontValidate
    public Resolution deleteAjax() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        String error = this.deleteLevel(Stripersist.getEntityManager(), this.level);
        if (error != null) {
            json.put("error", (Object)error);
        } else {
            json.put("success", (Object)Boolean.TRUE);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    protected String deleteLevel(EntityManager em, Level level) {
        StringBuilder error = null;
        StartLevel sl = (StartLevel)level.getStartLevels().get(this.application);
        if (level == null) {
            error = new StringBuilder(this.getBundle().getString("viewer_admin.applicationtreelevelactionbean.nolevel"));
        } else if (level.getParent() == null) {
            error = new StringBuilder(this.getBundle().getString("viewer_admin.applicationtreelevelactionbean.upperlevel"));
        } else if (level.getChildren().size() > 0) {
            error = new StringBuilder(this.getBundle().getString("viewer_admin.applicationtreelevelactionbean.levelsub"));
        } else if (sl != null && sl.getSelectedIndex() != null && !sl.isRemoved()) {
            error = new StringBuilder(this.getBundle().getString("viewer_admin.applicationtreelevelactionbean.leveltoc"));
        } else if (level.getLayers().size() > 0) {
            error = new StringBuilder(this.getBundle().getString("viewer_admin.applicationtreelevelactionbean.levelfilled"));
        } else {
            try {
                Level parent = level.getParent();
                parent.getChildren().remove(level);
                List mashups = ApplicationHelper.getMashups((Application)this.application, (EntityManager)em);
                mashups.add(this.application);
                for (Application mashup : mashups) {
                    List startlevels = mashup.getStartLevels();
                    startlevels.removeIf(next -> sl != null && next.getLevel().getId().equals(sl.getLevel().getId()));
                }
                em.remove((Object)level);
                this.application.authorizationsModified();
                em.getTransaction().commit();
            }
            catch (Exception e) {
                log.error((Object)"Can not remove level", (Throwable)e);
                error = new StringBuilder(MessageFormat.format(this.getBundle().getString("viewer.applicationtreelevelactionbean.levelnorem"), e));
                Throwable t = e;
                while (t.getCause() != null) {
                    t = t.getCause();
                    error.append("; ").append(t);
                }
            }
        }
        return null != error && error.length() > 0 ? error.toString() : null;
    }

    public Resolution save() {
        EntityManager em = Stripersist.getEntityManager();
        this.saveLevel(em);
        this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.applicationtreelevelactionbean.levelsaved"), new Object[0]));
        return this.edit();
    }

    protected void saveLevel(EntityManager em) {
        this.level.getReaders().clear();
        for (String groupName : this.groupsRead) {
            this.level.getReaders().add(groupName);
        }
        this.updateApplayersInLevel(this.selectedlayers, this.level, em);
        this.level.getDocuments().clear();
        if (this.selecteddocs != null && this.selecteddocs.length() > 0) {
            String[] docIds = this.selecteddocs.split(",");
            for (String docId : docIds) {
                Long id = Long.valueOf(docId.substring(1));
                Document doc = (Document)em.find(Document.class, (Object)id);
                this.level.getDocuments().add(doc);
            }
        }
        if (this.level.getStartLevels().isEmpty()) {
            StartLevel sl = new StartLevel();
            sl.setApplication(this.application);
            sl.setLevel(this.level);
            sl.setSelectedIndex(null);
            this.application.getStartLevels().add(sl);
            this.level.getStartLevels().put(this.application, sl);
        }
        em.persist((Object)this.level);
        List mashups = ApplicationHelper.getMashups((Application)this.application, (EntityManager)em);
        mashups.add(this.application);
        for (Application app : mashups) {
            app.authorizationsModified();
        }
        em.getTransaction().commit();
    }

    protected void updateApplayersInLevel(String selectedLayers, Level level, EntityManager em) {
        ArrayList layersToBeRemoved = new ArrayList(level.getLayers());
        List apps = ApplicationHelper.getMashups((Application)this.application, (EntityManager)em);
        apps.add(this.application);
        level.getLayers().clear();
        if (selectedLayers != null && selectedLayers.length() > 0) {
            String[] layerIds;
            for (String layerId : layerIds = selectedLayers.split(",")) {
                Layer layer;
                Long id;
                ApplicationLayer appLayer = null;
                if (layerId.startsWith("al")) {
                    id = Long.valueOf(layerId.substring(2));
                    appLayer = (ApplicationLayer)em.find(ApplicationLayer.class, (Object)id);
                    layersToBeRemoved.remove(appLayer);
                } else if (layerId.startsWith("l") && (layer = (Layer)em.find(Layer.class, (Object)(id = Long.valueOf(layerId.substring(1))))) != null && !layer.isVirtual()) {
                    appLayer = new ApplicationLayer();
                    appLayer.setService(layer.getService());
                    appLayer.setLayerName(layer.getName());
                    StartLayer sl = new StartLayer();
                    sl.setApplication(this.application);
                    sl.setApplicationLayer(appLayer);
                    appLayer.getStartLayers().put(this.application, sl);
                    this.application.getStartLayers().add(sl);
                    if (layer.getFeatureType() != null) {
                        SimpleFeatureType sft = layer.getFeatureType();
                        for (AttributeDescriptor ad : sft.getAttributes()) {
                            ConfiguredAttribute confAttribute = new ConfiguredAttribute();
                            confAttribute.setAttributeName(ad.getName());
                            confAttribute.setVisible(!AttributeDescriptor.GEOMETRY_TYPES.contains(ad.getType()));
                            appLayer.getAttributes().add(confAttribute);
                        }
                    }
                }
                level.getLayers().add(appLayer);
            }
        }
        for (Application app : apps) {
            List startlayers = app.getStartLayers();
            Iterator iterator = startlayers.iterator();
            while (iterator.hasNext()) {
                StartLayer next = (StartLayer)iterator.next();
                for (ApplicationLayer applicationLayer : layersToBeRemoved) {
                    if (!Objects.equals(next.getApplicationLayer().getId(), applicationLayer.getId())) continue;
                    iterator.remove();
                }
            }
        }
    }

    public List<String> getGroupsRead() {
        return this.groupsRead;
    }

    public void setGroupsRead(List<String> groupsRead) {
        this.groupsRead = groupsRead;
    }

    public boolean isLayersAllowed() {
        return this.layersAllowed;
    }

    public void setLayersAllowed(boolean layersAllowed) {
        this.layersAllowed = layersAllowed;
    }

    public String getSelectedlayers() {
        return this.selectedlayers;
    }

    public void setSelectedlayers(String selectedlayers) {
        this.selectedlayers = selectedlayers;
    }

    public String getSelecteddocs() {
        return this.selecteddocs;
    }

    public void setSelecteddocs(String selecteddocs) {
        this.selecteddocs = selecteddocs;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }
}

