/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.admin.stripes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.LocalizableError;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import nl.tailormap.i18n.LocalizableActionBean;
import nl.tailormap.viewer.config.ClobElement;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.app.Level;
import nl.tailormap.viewer.config.security.Group;
import nl.tailormap.viewer.config.services.AttributeDescriptor;
import nl.tailormap.viewer.config.services.BoundingBox;
import nl.tailormap.viewer.config.services.Category;
import nl.tailormap.viewer.config.services.CoordinateReferenceSystem;
import nl.tailormap.viewer.config.services.FeatureSource;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.config.services.StyleLibrary;
import nl.tailormap.viewer.config.services.TileService;
import nl.tailormap.viewer.config.services.TileSet;
import nl.tailormap.viewer.config.services.UpdateResult;
import nl.tailormap.viewer.config.services.WMSExceptionType;
import nl.tailormap.viewer.config.services.WMSService;
import nl.tailormap.viewer.helpers.services.GeoserviceFactoryHelper;
import nl.tailormap.viewer.helpers.services.TilingServiceHelper;
import nl.tailormap.viewer.helpers.services.WMSServiceHelper;
import nl.tailormap.web.WaitPageStatus;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.xml.filter.FilterTransformer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.filter.Filter;
import org.stripesstuff.plugin.waitpage.WaitPage;
import org.stripesstuff.stripersist.Stripersist;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

@StrictBinding
@UrlBinding(value="/action/geoservice/{service}")
@RolesAllowed(value={"Admin", "RegistryAdmin"})
public class GeoServiceActionBean
extends LocalizableActionBean {
    private static final Log log = LogFactory.getLog(GeoServiceActionBean.class);
    private static final String JSP = "/WEB-INF/jsp/services/geoservice.jsp";
    private static final String JSP_EDIT_SLD = "/WEB-INF/jsp/services/editsld.jsp";
    private ActionBeanContext context;
    @Validate(on={"add"}, required=true)
    private Category category;
    @Validate(on={"edit"}, required=true)
    private GeoService service;
    @Validate(on={"add"}, required=true)
    private String url;
    @Validate(on={"add"}, required=true)
    private String protocol;
    private boolean serviceDeleted;
    @Validate
    private String name;
    @Validate
    private String username;
    @Validate
    private String password;
    @Validate
    private boolean overrideUrl;
    @Validate
    private String serviceName;
    @Validate
    private String agsVersion;
    @Validate
    private Integer tileSize;
    @Validate
    private String tilingProtocol;
    @Validate
    private String resolutions;
    @Validate
    private String serviceBbox;
    @Validate
    private String imageExtension;
    @Validate
    private String crs;
    @Validate
    private boolean useIntersect;
    @Validate
    private boolean useProxy;
    @Validate
    private WMSExceptionType exception_type;
    @Validate
    private boolean skipDiscoverWFS = true;
    @Validate
    private String geofenceHeader;
    @Validate
    private String serverType;
    @Validate
    private boolean disableTiling = false;
    @Validate
    private Integer tilingGutter;
    private WaitPageStatus status;
    private JSONObject newService;
    private JSONObject updatedService;
    private List<Group> allGroups;
    @Validate
    private List<String> groupsRead = new ArrayList();
    @Validate
    @ValidateNestedProperties(value={@Validate(on={"saveSld"}, field="title", required=true), @Validate(on={"saveSld"}, field="defaultStyle"), @Validate(on={"saveSld"}, field="externalUrl"), @Validate(on={"saveSld"}, field="sldBody"), @Validate(on={"saveSld"}, field="extraLegendParameters")})
    private StyleLibrary sld;
    @Validate
    private String sldType = "external";
    @Validate(on={"cqlToFilter"})
    private String cql;
    private String generatedSld;
    private boolean updatable;
    private JSONArray layersInApplications = new JSONArray();
    private static final String NS_SLD = "http://www.opengis.net/sld";
    private static final String NS_OGC = "http://www.opengis.net/ogc";
    private static final String NS_GML = "http://www.opengis.net/gml";

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public GeoService getService() {
        return this.service;
    }

    public void setService(GeoService service) {
        this.service = service;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public WaitPageStatus getStatus() {
        return this.status;
    }

    public void setStatus(WaitPageStatus status) {
        this.status = status;
    }

    public boolean isOverrideUrl() {
        return this.overrideUrl;
    }

    public void setOverrideUrl(boolean overrideUrl) {
        this.overrideUrl = overrideUrl;
    }

    public String getAgsVersion() {
        return this.agsVersion;
    }

    public void setAgsVersion(String agsVersion) {
        this.agsVersion = agsVersion;
    }

    public JSONObject getNewService() {
        return this.newService;
    }

    public void setNewService(JSONObject newService) {
        this.newService = newService;
    }

    public JSONObject getUpdatedService() {
        return this.updatedService;
    }

    public void setUpdatedService(JSONObject updatedService) {
        this.updatedService = updatedService;
    }

    public boolean isServiceDeleted() {
        return this.serviceDeleted;
    }

    public void setServiceDeleted(boolean serviceDeleted) {
        this.serviceDeleted = serviceDeleted;
    }

    public Integer getTileSize() {
        return this.tileSize;
    }

    public void setTileSize(Integer tileSize) {
        this.tileSize = tileSize;
    }

    public String getTilingProtocol() {
        return this.tilingProtocol;
    }

    public void setTilingProtocol(String tilingProtocol) {
        this.tilingProtocol = tilingProtocol;
    }

    public String getResolutions() {
        return this.resolutions;
    }

    public void setResolutions(String resolutions) {
        this.resolutions = resolutions;
    }

    public String getServiceBbox() {
        return this.serviceBbox;
    }

    public void setServiceBbox(String serviceBbox) {
        this.serviceBbox = serviceBbox;
    }

    public String getImageExtension() {
        return this.imageExtension;
    }

    public void setImageExtension(String imageExtension) {
        this.imageExtension = imageExtension;
    }

    public String getCrs() {
        return this.crs;
    }

    public void setCrs(String crs) {
        this.crs = crs;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public StyleLibrary getSld() {
        return this.sld;
    }

    public void setSld(StyleLibrary sld) {
        this.sld = sld;
    }

    public String getSldType() {
        return this.sldType;
    }

    public void setSldType(String sldType) {
        this.sldType = sldType;
    }

    public String getGeneratedSld() {
        return this.generatedSld;
    }

    public void setGeneratedSld(String generatedSld) {
        this.generatedSld = generatedSld;
    }

    public String getCql() {
        return this.cql;
    }

    public void setCql(String cql) {
        this.cql = cql;
    }

    public boolean isUseIntersect() {
        return this.useIntersect;
    }

    public void setUseIntersect(boolean useIntersect) {
        this.useIntersect = useIntersect;
    }

    public WMSExceptionType getException_type() {
        return this.exception_type;
    }

    public void setException_type(WMSExceptionType exception_type) {
        this.exception_type = exception_type;
    }

    public boolean isUseProxy() {
        return this.useProxy;
    }

    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    public JSONArray getLayersInApplications() {
        return this.layersInApplications;
    }

    public void setLayersInApplications(JSONArray layersInApplications) {
        this.layersInApplications = layersInApplications;
    }

    public List<Group> getAllGroups() {
        return this.allGroups;
    }

    public void setAllGroups(List<Group> allGroups) {
        this.allGroups = allGroups;
    }

    public List<String> getGroupsRead() {
        return this.groupsRead;
    }

    public void setGroupsRead(List<String> groupsRead) {
        this.groupsRead = groupsRead;
    }

    public boolean isSkipDiscoverWFS() {
        return this.skipDiscoverWFS;
    }

    public void setSkipDiscoverWFS(boolean skipDiscoverWFS) {
        this.skipDiscoverWFS = skipDiscoverWFS;
    }

    public String getGeofenceHeader() {
        return this.geofenceHeader;
    }

    public void setGeofenceHeader(String geofenceHeader) {
        this.geofenceHeader = geofenceHeader;
    }

    public String getServerType() {
        return this.serverType;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public boolean isDisableTiling() {
        return this.disableTiling;
    }

    public void setDisableTiling(boolean disableTiling) {
        this.disableTiling = disableTiling;
    }

    public Integer getTilingGutter() {
        return this.tilingGutter;
    }

    public void setTilingGutter(Integer tilingGutter) {
        this.tilingGutter = tilingGutter;
    }

    @DefaultHandler
    public Resolution edit() {
        if (this.service != null) {
            ClobElement ce;
            this.protocol = this.service.getProtocol();
            this.url = this.service.getUrl();
            switch (this.protocol) {
                case "tiled": {
                    TileService ser = (TileService)this.service;
                    this.tilingProtocol = ser.getTilingProtocol();
                    Layer layer = ser.getTilingLayer();
                    if (layer == null) break;
                    TileSet tileSet = layer.getTileset();
                    if (tileSet != null) {
                        StringBuilder res = new StringBuilder();
                        for (Object resolution : tileSet.getResolutions()) {
                            if (res.length() > 0) {
                                res.append(",");
                            }
                            res.append(((Double)resolution).toString());
                        }
                        this.resolutions = res.toString();
                        this.tileSize = tileSet.getHeight();
                    }
                    if (layer.getBoundingBoxes().size() == 1) {
                        BoundingBox bb = (BoundingBox)layer.getBoundingBoxes().values().iterator().next();
                        this.serviceBbox = bb.getMinx() + "," + bb.getMiny() + "," + bb.getMaxx() + "," + bb.getMaxy();
                        this.crs = bb.getCrs().getName();
                    }
                    this.serviceName = layer.getName();
                    if (!layer.getDetails().containsKey("image_extension")) break;
                    ClobElement ce2 = (ClobElement)layer.getDetails().get("image_extension");
                    this.imageExtension = ce2 != null ? ce2.getValue() : null;
                    break;
                }
                case "wms": {
                    this.overrideUrl = ((WMSService)this.service).getOverrideUrl();
                    this.exception_type = ((WMSService)this.service).getException_type();
                    this.skipDiscoverWFS = ((WMSService)this.service).getSkipDiscoverWFS() != null && ((WMSService)this.service).getSkipDiscoverWFS() != false;
                    this.serverType = this.service.getDetails().getOrDefault("serverType", new ClobElement("auto")).getValue();
                    this.disableTiling = "true".equals(this.service.getDetails().getOrDefault("tiling.disable", new ClobElement("false")).getValue());
                    this.tilingGutter = Integer.parseInt(this.service.getDetails().getOrDefault("tiling.gutter", new ClobElement("0")).getValue());
                }
            }
            if (this.service.getDetails().containsKey("useIntersect")) {
                ce = (ClobElement)this.service.getDetails().get("useIntersect");
                this.useIntersect = Boolean.parseBoolean(ce.getValue());
            }
            if (this.service.getDetails().containsKey("useProxy")) {
                ce = (ClobElement)this.service.getDetails().get("useProxy");
                this.useProxy = Boolean.parseBoolean(ce.getValue());
            }
            this.geofenceHeader = this.service.getGeofenceHeader();
            this.name = this.service.getName();
            this.username = this.service.getUsername();
            this.password = this.service.getPassword();
            EntityManager em = Stripersist.getEntityManager();
            List layers = this.service.loadLayerTree(em);
            List applications = em.createQuery("from Application", Application.class).getResultList();
            for (Layer layer : layers) {
                JSONArray applicationsArray = new JSONArray();
                List appLayers = layer.getApplicationLayers(em);
                for (ApplicationLayer appLayer : appLayers) {
                    for (Application application : applications) {
                        JSONArray levelsInApplication = new JSONArray();
                        JSONObject applicationObject = new JSONObject();
                        applicationObject.put("text", (Object)application.getNameWithVersion());
                        applicationObject.put("itemid", (Object)("a" + application.getId()));
                        applicationObject.put("type", (Object)"application");
                        applicationObject.put("children", (Object)levelsInApplication);
                        applicationsArray.put((Object)applicationObject);
                        Level l = application.getRoot().getParentInSubtree(appLayer);
                        if (l == null) continue;
                        Level cur = l;
                        JSONObject prev = null;
                        while (cur.getParent() != null) {
                            JSONObject level = new JSONObject();
                            level.put("text", (Object)cur.getName());
                            level.put("type", (Object)"level");
                            level.put("itemid", (Object)("v" + cur.getId()));
                            level.put("leaf", prev == null);
                            if (prev != null) {
                                level.put("children", prev);
                            }
                            cur = cur.getParent();
                            prev = level;
                        }
                        levelsInApplication.put(prev);
                    }
                }
                if (applicationsArray.length() <= 0) continue;
                JSONObject layerObject = new JSONObject();
                layerObject.put("text", (Object)layer.getDisplayName());
                layerObject.put("layername", (Object)layer.getName());
                layerObject.put("itemid", (Object)("l" + layer.getId()));
                layerObject.put("type", (Object)"layer");
                layerObject.put("children", (Object)applicationsArray);
                this.layersInApplications.put((Object)layerObject);
            }
        }
        if (this.status != null) {
            this.status.setFinished(true);
            this.status.setProgress(100);
            List logs = this.status.dequeueLog();
            for (String log : logs) {
                this.context.getValidationErrors().add("Errors", (ValidationError)new SimpleError(this.getBundle().getString(log), new Object[0]));
            }
        }
        return new ForwardResolution(JSP);
    }

    public Resolution save() {
        if (this.name != null) {
            this.service.setName(this.name);
        }
        if (this.url != null) {
            this.service.setUrl(this.url);
        }
        if (this.service instanceof TileService) {
            TileService ser = (TileService)this.service;
            if (this.tilingProtocol != null) {
                ((TileService)this.service).setTilingProtocol(this.tilingProtocol);
            }
            Layer l = ser.getTilingLayer();
            if (this.tileSize != null) {
                l.getTileset().setWidth(this.tileSize.intValue());
                l.getTileset().setHeight(this.tileSize.intValue());
            }
            if (this.resolutions != null) {
                l.getTileset().setResolutions(this.resolutions);
            }
            if (this.crs != null && this.serviceBbox != null) {
                BoundingBox bb = new BoundingBox();
                bb.setBounds(this.serviceBbox);
                bb.setCrs(new CoordinateReferenceSystem(this.crs));
                l.getBoundingBoxes().clear();
                l.getBoundingBoxes().put(bb.getCrs(), bb);
            }
            if (StringUtils.isNotBlank((CharSequence)this.imageExtension)) {
                l.getDetails().put("image_extension", new ClobElement(this.imageExtension));
            } else {
                l.getDetails().remove("image_extension");
            }
        }
        if (this.service instanceof WMSService) {
            ((WMSService)this.service).setOverrideUrl(Boolean.valueOf(this.overrideUrl));
            ((WMSService)this.service).setException_type(this.exception_type);
            ((WMSService)this.service).setSkipDiscoverWFS(Boolean.valueOf(this.skipDiscoverWFS));
            this.service.getDetails().put("serverType", new ClobElement(this.serverType));
            this.service.getDetails().put("tiling.disable", new ClobElement("" + this.disableTiling));
            this.service.getDetails().put("tiling.gutter", new ClobElement((String)(this.tilingGutter == null ? "0" : "" + this.tilingGutter)));
        }
        EntityManager em = Stripersist.getEntityManager();
        List apps = this.findApplications();
        this.service.getDetails().put("useIntersect", new ClobElement("" + this.useIntersect));
        this.service.getDetails().put("useProxy", new ClobElement("" + this.useProxy));
        this.service.setGeofenceHeader(this.geofenceHeader);
        this.service.setUsername(this.username);
        if (this.password != null) {
            this.service.setPassword(this.password);
        }
        if (this.username == null && this.password == null) {
            this.service.setPassword(this.password);
        }
        this.service.getReaders().clear();
        this.service.getReaders().addAll(this.groupsRead);
        em.persist((Object)this.service);
        em.getTransaction().commit();
        this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.geoserviceactionbean.srvsaved"), new Object[0]));
        return this.edit();
    }

    private List<Application> findApplications() {
        ArrayList<Application> apps = new ArrayList<Application>();
        List applicationLayers = Stripersist.getEntityManager().createQuery("from ApplicationLayer where service = :service", ApplicationLayer.class).setParameter("service", (Object)this.service).getResultList();
        for (ApplicationLayer appLayer : applicationLayers) {
            List applications = Stripersist.getEntityManager().createQuery("from Application", Application.class).getResultList();
            for (Application app : applications) {
                if (!app.getRoot().containsLayerInSubtree(appLayer)) continue;
                apps.add(app);
            }
        }
        return apps;
    }

    public Resolution delete() {
        List applicationLayers = Stripersist.getEntityManager().createQuery("from ApplicationLayer where service = :service", ApplicationLayer.class).setParameter("service", (Object)this.service).getResultList();
        if (applicationLayers.size() > 0) {
            this.serviceDeleted = false;
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.geoserviceactionbean.srvinuse"), new Object[]{applicationLayers.size()}));
            return this.edit();
        }
        Category c = this.service.getCategory();
        c.getServices().remove(this.service);
        List linkedSources = Stripersist.getEntityManager().createQuery("from FeatureSource where linkedService = :service", FeatureSource.class).setParameter("service", (Object)this.service).getResultList();
        for (FeatureSource fs : linkedSources) {
            fs.setLinkedService(null);
            this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.geoserviceactionbean.sepdel"), new Object[]{fs.getName()}));
        }
        if ("tiled".equals(this.service.getProtocol()) && this.service.getTopLayer() != null && this.service.getTopLayer().getTileset() != null) {
            TileSet ts = this.service.getTopLayer().getTileset();
            Stripersist.getEntityManager().remove((Object)ts);
        }
        Stripersist.getEntityManager().remove((Object)this.service);
        Stripersist.getEntityManager().getTransaction().commit();
        this.serviceDeleted = true;
        this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.geoserviceactionbean.srvrem"), new Object[0]));
        return new ForwardResolution(JSP);
    }

    @Before
    public void setUpdatable() {
        EntityManager em = Stripersist.getEntityManager();
        this.updatable = GeoserviceFactoryHelper.isUpdatable((GeoService)this.service);
    }

    @After
    public void makeLists() {
        EntityManager em = Stripersist.getEntityManager();
        this.allGroups = em.createQuery("from Group", Group.class).getResultList();
        if (this.service != null && em.contains((Object)this.service)) {
            this.groupsRead = new ArrayList(this.service.getReaders());
        }
    }

    public Resolution update() throws Exception {
        if (!this.isUpdatable()) {
            this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.geoserviceactionbean.srvnotupd"), new Object[]{this.service.getProtocol()}));
            return new ForwardResolution(JSP);
        }
        EntityManager em = Stripersist.getEntityManager();
        UpdateResult result = GeoserviceFactoryHelper.update((EntityManager)em, (GeoService)this.service);
        if (result.getStatus() == UpdateResult.Status.FAILED) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError(result.getMessage(), new Object[0]));
            return new ForwardResolution(JSP);
        }
        Map byStatus = result.getLayerNamesByStatus();
        log.info((Object)String.format("Update layer stats: unmodified %d, updated %d, new %d, missing %d", ((List)byStatus.get(UpdateResult.Status.UNMODIFIED)).size(), ((List)byStatus.get(UpdateResult.Status.UPDATED)).size(), ((List)byStatus.get(UpdateResult.Status.NEW)).size(), ((List)byStatus.get(UpdateResult.Status.MISSING)).size()));
        log.info((Object)("Unmodified layers: " + byStatus.get(UpdateResult.Status.UNMODIFIED)));
        log.info((Object)("Updated layers: " + byStatus.get(UpdateResult.Status.UPDATED)));
        log.info((Object)("New layers: " + byStatus.get(UpdateResult.Status.NEW)));
        log.info((Object)("Missing layers: " + byStatus.get(UpdateResult.Status.MISSING)));
        List apps = this.findApplications();
        em.getTransaction().commit();
        this.updatedService = new JSONObject();
        this.updatedService.put("id", (Object)("s" + this.service.getId()));
        this.updatedService.put("name", (Object)this.service.getName());
        this.updatedService.put("type", (Object)"service");
        this.updatedService.put("isLeaf", this.service.getTopLayer() == null);
        this.updatedService.put("status", (Object)"ok");
        this.updatedService.put("parentid", (Object)("c" + this.category.getId()));
        this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.geoserviceactionbean.srvupd"), new Object[0]));
        return new ForwardResolution(JSP);
    }

    @ValidationMethod(on={"add"})
    public void validateParams(ValidationErrors errors) {
        if (this.protocol.equals("tiled")) {
            if (this.serviceName == null && this.protocol.equals("tiled") && !this.tilingProtocol.equalsIgnoreCase("WMTS")) {
                errors.add("serviceName", (ValidationError)new LocalizableError("validation.required.valueNotPresent", new Object[0]));
            }
            if (this.protocol.equals("tiled") && !this.tilingProtocol.equalsIgnoreCase("WMTS")) {
                if (this.resolutions == null) {
                    errors.add("resolutions", (ValidationError)new LocalizableError("validation.required.valueNotPresent", new Object[0]));
                }
                if (this.serviceBbox == null) {
                    errors.add("serviceBbox", (ValidationError)new LocalizableError("validation.required.valueNotPresent", new Object[0]));
                }
                if (this.crs == null) {
                    errors.add("crs", (ValidationError)new LocalizableError("validation.required.valueNotPresent", new Object[0]));
                }
                if (this.tileSize == null) {
                    errors.add("tileSize", (ValidationError)new LocalizableError("validation.required.valueNotPresent", new Object[0]));
                }
            }
        }
    }

    public Resolution addForm() {
        return new ForwardResolution(JSP);
    }

    @WaitPage(path="/WEB-INF/jsp/waitpage.jsp", delay=2000, refresh=1000, ajax="/WEB-INF/jsp/waitpageajax.jsp")
    public Resolution add() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        try {
            this.addService(em);
        }
        catch (Exception e) {
            log.error((Object)("Exception loading " + this.protocol + " service from url " + this.url), (Throwable)e);
            Object s = e.toString();
            if (e.getCause() != null) {
                s = (String)s + "; cause: " + e.getCause().toString();
            }
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.geoserviceactionbean.srvnotloaded"), new Object[]{s}));
            return new ForwardResolution(JSP);
        }
        this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.geoserviceactionbean.srvloaded"), new Object[0]));
        return this.edit();
    }

    protected void addService(EntityManager em) throws Exception {
        this.status = new WaitPageStatus();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("username", this.username);
        params.put("password", this.password);
        switch (this.protocol) {
            case "wms": {
                params.put("overrideUrl", this.overrideUrl);
                params.put("skipDiscoverWFS", this.skipDiscoverWFS);
                this.service = WMSServiceHelper.loadFromUrl((String)this.url, params, (WaitPageStatus)this.status, (EntityManager)em);
                ((WMSService)this.service).setException_type(this.exception_type);
                this.service.getDetails().put("useProxy", new ClobElement("" + this.useProxy));
                this.service.getDetails().put("hidpi.mode", new ClobElement(this.serverType));
                this.service.getDetails().put("tiling.disable", new ClobElement("" + this.disableTiling));
                this.service.getDetails().put("tiling.gutter", new ClobElement((String)(this.tilingGutter == null ? "0" : "" + this.tilingGutter)));
                break;
            }
            case "tiled": {
                params.put("ServiceName", this.serviceName);
                params.put("resolutions", this.resolutions);
                params.put("serviceBbox", this.serviceBbox);
                params.put("crs", this.crs);
                params.put("imageExtension", this.imageExtension);
                params.put("tileSize", this.tileSize);
                params.put("tilingProtocol", this.tilingProtocol);
                this.service = TilingServiceHelper.loadFromURL((String)this.url, params, (WaitPageStatus)this.status, (EntityManager)em);
                break;
            }
            default: {
                this.getContext().getValidationErrors().add("protocol", (ValidationError)new SimpleError("Ongeldig", new Object[0]));
            }
        }
        if (this.service == null) {
            throw new IllegalArgumentException("check URL");
        }
        if (this.name != null) {
            this.service.setName(this.name);
        }
        if (this.username != null) {
            this.service.setUsername(this.username);
        }
        if (this.password != null) {
            this.service.setPassword(this.password);
        }
        this.service.getDetails().put("useIntersect", new ClobElement("" + this.useIntersect));
        this.service.getReaders().addAll(this.groupsRead);
        this.category = (Category)em.find(Category.class, (Object)this.category.getId());
        this.service.setCategory(this.category);
        this.category.getServices().add(this.service);
        this.status.setCurrentAction("Service opslaan.");
        em.persist((Object)this.service);
        em.getTransaction().commit();
        this.newService = new JSONObject();
        this.newService.put("id", (Object)("s" + this.service.getId()));
        this.newService.put("name", (Object)this.service.getName());
        this.newService.put("type", (Object)"service");
        this.newService.put("isLeaf", this.service.getTopLayer() == null);
        this.newService.put("status", (Object)"ok");
        this.newService.put("parentid", (Object)("c" + this.category.getId()));
    }

    @DontValidate
    public Resolution addSld() {
        return new ForwardResolution(JSP_EDIT_SLD);
    }

    @Before(on={"editSld"})
    public void setSldType() {
        if (this.sld != null) {
            this.sldType = this.sld.getExternalUrl() != null ? "external" : "body";
        }
    }

    public Resolution editSld() {
        if (this.sld != null) {
            return new ForwardResolution(JSP_EDIT_SLD);
        }
        return this.edit();
    }

    public Resolution deleteSld() {
        if (this.sld != null) {
            this.service.getStyleLibraries().remove(this.sld);
            Stripersist.getEntityManager().remove((Object)this.sld);
            Stripersist.getEntityManager().getTransaction().commit();
            this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.geoserviceactionbean.sldrem"), new Object[0]));
        }
        return this.edit();
    }

    @ValidationMethod(on={"saveSld"})
    public void validateSld() {
        if ("external".equals(this.sldType) && StringUtils.isBlank((CharSequence)this.sld.getExternalUrl())) {
            this.getContext().getValidationErrors().add("sld.externalUrl", (ValidationError)new LocalizableError("validation.required.valueNotPresent", new Object[0]));
            this.sld.setSldBody(null);
        }
        if ("body".equals(this.sldType) && StringUtils.isBlank((CharSequence)this.sld.getSldBody())) {
            this.getContext().getValidationErrors().add("sld.sldBody", (ValidationError)new LocalizableError("validation.required.valueNotPresent", new Object[0]));
            this.sld.setExternalUrl(null);
        }
    }

    public Resolution generateSld() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document sldDoc = db.newDocument();
        Element sldEl = sldDoc.createElementNS(NS_SLD, "StyledLayerDescriptor");
        sldDoc.appendChild(sldEl);
        sldEl.setAttributeNS(NS_SLD, "version", "1.0.0");
        sldEl.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.opengis.net/sld http://schemas.opengis.net/sld/1.0.0/StyledLayerDescriptor.xsd");
        sldEl.setAttribute("xmlns:ogc", NS_OGC);
        sldEl.setAttribute("xmlns:gml", NS_GML);
        EntityManager em = Stripersist.getEntityManager();
        this.service.loadLayerTree(em);
        LinkedList layerStack = new LinkedList();
        Layer l = this.service.getTopLayer();
        while (l != null) {
            layerStack.addAll(this.service.getLayerChildrenCache(l, em));
            if (l.getName() != null) {
                String title;
                Element nlEl = sldDoc.createElementNS(NS_SLD, "NamedLayer");
                sldEl.appendChild(nlEl);
                String string = title = l.getTitleAlias() != null ? l.getTitleAlias() : l.getTitle();
                if (title != null) {
                    nlEl.appendChild(sldDoc.createComment(" Layer '" + title + "' "));
                }
                Element nEl = sldDoc.createElementNS(NS_SLD, "Name");
                nEl.setTextContent(l.getName());
                nlEl.appendChild(nEl);
                if (l.getFeatureType() != null) {
                    Object protocol = "";
                    if (l.getFeatureType().getFeatureSource() != null) {
                        protocol = " (protocol " + l.getFeatureType().getFeatureSource().getProtocol() + ")";
                    }
                    StringBuilder ftComment = new StringBuilder(" This layer has a feature type" + (String)protocol + " you can use in a FeatureTypeConstraint element as follows:\n");
                    ftComment.append("            <LayerFeatureConstraints>\n");
                    ftComment.append("                <FeatureTypeConstraint>\n");
                    ftComment.append("                    <FeatureTypeName>").append(l.getFeatureType().getTypeName()).append("</FeatureTypeName>\n");
                    ftComment.append("                    Add ogc:Filter or Extent element here. ");
                    if (l.getFeatureType().getAttributes().isEmpty()) {
                        ftComment.append(" No feature type attributes are known.\n");
                    } else {
                        ftComment.append(" You can use the following feature type attributes in ogc:PropertyName elements:\n");
                        for (AttributeDescriptor ad : l.getFeatureType().getAttributes()) {
                            ftComment.append("                    <ogc:PropertyName>").append(ad.getName()).append("</ogc:PropertyName>");
                            if (ad.getAlias() != null) {
                                ftComment.append(" (").append(ad.getAlias()).append(")");
                            }
                            if (ad.getType() != null) {
                                ftComment.append(" (type: ").append(ad.getType()).append(")");
                            }
                            ftComment.append("\n");
                        }
                    }
                    ftComment.append("                </FeatureTypeConstraint>\n");
                    ftComment.append("            </LayerFeatureConstraints>\n");
                    ftComment.append("        ");
                    nlEl.appendChild(sldDoc.createComment(ftComment.toString()));
                }
                nlEl.appendChild(sldDoc.createComment(" Add a UserStyle or NamedStyle element here "));
                StringBuilder styleComment = new StringBuilder(" (no server-side named styles are known other than 'default') ");
                ClobElement styleDetail = (ClobElement)l.getDetails().get("wms.styles");
                if (styleDetail != null) {
                    try {
                        JSONArray styles = new JSONArray(styleDetail.getValue());
                        if (styles.length() > 0) {
                            styleComment = new StringBuilder(" The following NamedStyles are available according to the capabilities: \n");
                            for (int i = 0; i < styles.length(); ++i) {
                                JSONObject jStyle = styles.getJSONObject(i);
                                styleComment.append("            <NamedStyle><Name>").append(jStyle.getString("name")).append("</Name></NamedStyle>");
                                if (jStyle.has("title")) {
                                    styleComment.append(" (").append(jStyle.getString("title")).append(")");
                                }
                                styleComment.append("\n");
                            }
                        }
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    styleComment.append("        ");
                }
                nlEl.appendChild(sldDoc.createComment(styleComment.toString()));
            }
            l = (Layer)layerStack.poll();
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = tf.newTransformer();
        t.setOutputProperty("indent", "yes");
        t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        t.setOutputProperty("encoding", "UTF-8");
        DOMSource source = new DOMSource(sldDoc);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(bos);
        t.transform(source, result);
        this.generatedSld = bos.toString(StandardCharsets.UTF_8);
        this.generatedSld = this.generatedSld.replaceFirst("\"\\?><StyledLayerDescriptor", "\"?>\n<StyledLayerDescriptor");
        return new ForwardResolution(JSP_EDIT_SLD);
    }

    @DontValidate
    public Resolution cqlToFilter() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        try {
            List filters = CQL.toFilterList((String)this.cql);
            FilterTransformer filterTransformer = new FilterTransformer();
            filterTransformer.setIndentation(4);
            filterTransformer.setOmitXMLDeclaration(true);
            filterTransformer.setNamespaceDeclarationEnabled(false);
            StringWriter sw = new StringWriter();
            for (Filter filter : filters) {
                sw.append('\n');
                filterTransformer.transform((Object)filter, (Writer)sw);
            }
            json.put("filter", (Object)sw.toString());
            json.put("success", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            Object error = ExceptionUtils.getMessage((Throwable)e);
            if (e.getCause() != null) {
                error = (String)error + "; cause: " + ExceptionUtils.getMessage((Throwable)e.getCause());
            }
            json.put("error", error);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    public Resolution validateSldXml() {
        ForwardResolution jsp = new ForwardResolution(JSP_EDIT_SLD);
        Document sldXmlDoc = null;
        String stage = this.getBundle().getString("viewer_admin.geoserviceactionbean.noparsexml");
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            sldXmlDoc = db.parse(new ByteArrayInputStream(this.sld.getSldBody().getBytes(StandardCharsets.UTF_8)));
            stage = this.getBundle().getString("viewer_admin.geoserviceactionbean.slderror");
            Element root = sldXmlDoc.getDocumentElement();
            if (!"StyledLayerDescriptor".equals(root.getLocalName())) {
                throw new Exception(this.getBundle().getString("viewer_admin.geoserviceactionbean.wrongroot"));
            }
            String version = root.getAttribute("version");
            if (version == null || !"1.0.0".equals(version) && !"1.1.0".equals(version)) {
                throw new Exception(this.getBundle().getString("viewer_admin.geoserviceactionbean.invalidsld"));
            }
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema s = sf.newSchema(new URL("http://schemas.opengis.net/sld/" + version + "/StyledLayerDescriptor.xsd"));
            s.newValidator().validate(new DOMSource(sldXmlDoc));
        }
        catch (Exception e) {
            SAXParseException spe;
            Object extra = "";
            if (e instanceof SAXParseException && (spe = (SAXParseException)e).getLineNumber() != -1) {
                extra = " (line " + spe.getLineNumber();
                if (spe.getColumnNumber() != -1) {
                    extra = (String)extra + ", column " + spe.getColumnNumber();
                }
                extra = (String)extra + ")";
            }
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("{2}: {3}{4}", new Object[]{stage, ExceptionUtils.getMessage((Throwable)e), extra}));
            return jsp;
        }
        this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.geoserviceactionbean.validsld"), new Object[0]));
        return jsp;
    }

    public Resolution saveSld() {
        if (this.sld.getId() == null) {
            this.service.getStyleLibraries().add(this.sld);
        }
        if (this.sld.isDefaultStyle()) {
            for (StyleLibrary otherSld : this.service.getStyleLibraries()) {
                if (otherSld.getId() == null || otherSld.getId().equals(this.sld.getId())) continue;
                otherSld.setDefaultStyle(false);
            }
        }
        try {
            this.sld.setNamedLayerUserStylesJson(null);
            InputSource sldBody = null;
            sldBody = this.sld.getExternalUrl() == null ? new InputSource(new StringReader(this.sld.getSldBody())) : new InputSource(new URL(this.sld.getExternalUrl()).openStream());
            this.sld.setNamedLayerUserStylesJson(StyleLibrary.parseSLDNamedLayerUserStyles((InputSource)sldBody).toString(4));
        }
        catch (Exception e) {
            log.error((Object)"Fout bij bepalen UserStyle namen van NamedLayers", (Throwable)e);
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError(this.getBundle().getString("viewer_admin.geoserviceactionbean.nostyles"), new Object[]{e.getClass().getName(), e.getLocalizedMessage()}));
        }
        Stripersist.getEntityManager().getTransaction().commit();
        this.getContext().getMessages().add(new SimpleMessage(this.getBundle().getString("viewer_admin.geoserviceactionbean.sldsaved"), new Object[0]));
        return this.edit();
    }
}

