/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.controller;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityNotFoundException;
import nl.b3p.tailormap.api.annotation.AppRestController;
import nl.b3p.tailormap.api.model.AppResponse;
import nl.b3p.tailormap.api.model.AppStyling;
import nl.b3p.tailormap.api.model.Component;
import nl.b3p.tailormap.api.repository.ApplicationRepository;
import nl.b3p.tailormap.api.repository.MetadataRepository;
import nl.b3p.tailormap.api.security.AuthorizationService;
import nl.tailormap.viewer.config.ClobElement;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.metadata.Metadata;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ResponseStatusException;

@AppRestController
@CrossOrigin
@RequestMapping(path={"/app"})
public class AppController {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String COMPONENTS_CONFIG_KEY = "components";
    private final String STYLING_CONFIG_KEY = "application_style";
    private final ApplicationRepository applicationRepository;
    private final MetadataRepository metadataRepository;
    private final AuthorizationService authorizationService;
    @Value(value="${tailormap-api.apiVersion}")
    private String apiVersion;

    public AppController(ApplicationRepository applicationRepository, MetadataRepository metadataRepository, AuthorizationService authorizationService) {
        this.applicationRepository = applicationRepository;
        this.metadataRepository = metadataRepository;
        this.authorizationService = authorizationService;
    }

    @GetMapping(produces={"application/json"})
    @Timed(value="get_app", description="time spent to find an app")
    public ResponseEntity<Serializable> get(@RequestParam(required=false) Long appId, @RequestParam(required=false) String name, @RequestParam(required=false) String version) {
        AppStyling style;
        Component[] components;
        this.logger.trace((Object)("requested application using: appId: " + appId + ", name: " + name + ", version: " + version));
        Application application = null != appId ? (Application)this.applicationRepository.findById((Object)appId).orElse(null) : this.findApplication(name, version);
        if (null == application) {
            application = this.getDefaultViewer();
        }
        if (null == application) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Requested application not found and no default application set");
        }
        if (!this.authorizationService.mayUserRead(application)) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        this.logger.trace((Object)("found application - id:" + application.getId() + ", name: " + application.getName() + ", version: " + application.getVersion() + ", lang: " + application.getLang() + ", title: " + application.getTitle()));
        try {
            String json = Optional.ofNullable((ClobElement)application.getDetails().get("components")).map(Object::toString).orElse("[]");
            components = (Component[])new ObjectMapper().readValue(json, Component[].class);
        }
        catch (JacksonException je) {
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, "Invalid components JSON", (Throwable)je);
        }
        try {
            String json = Optional.ofNullable((ClobElement)application.getDetails().get("application_style")).map(Object::toString).orElse("{}");
            style = (AppStyling)new ObjectMapper().readValue(json, AppStyling.class);
        }
        catch (JacksonException je) {
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, "Invalid app style JSON", (Throwable)je);
        }
        AppResponse appResponse = new AppResponse().apiVersion(this.apiVersion).id(application.getId()).name(application.getName()).version(application.getVersion()).title(application.getTitle()).styling(style).components(List.of(components));
        if (null != application.getLang()) {
            appResponse.lang(AppResponse.LangEnum.fromValue((String)application.getLang()));
        }
        return ResponseEntity.ok((Object)appResponse);
    }

    private Application findApplication(String name, String version) {
        Application application = null;
        if (name != null) {
            if (null != version) {
                if (version.startsWith("v")) {
                    version = version.substring(1);
                }
                application = this.applicationRepository.findByNameAndVersion(name, version);
            } else {
                application = this.applicationRepository.findByName(name).stream().sorted().findFirst().orElse(null);
            }
            if (null == application) {
                this.logger.warn((Object)("No application found with name " + name + " and version " + version));
                String decodedName = URLDecoder.decode(name, StandardCharsets.UTF_8);
                if (!decodedName.equals(name)) {
                    return this.findApplication(decodedName, version);
                }
            }
        }
        return application;
    }

    private Application getDefaultViewer() {
        try {
            Metadata md = this.metadataRepository.findByConfigKey("default_application");
            String appId = md.getConfigValue();
            Long id = Long.parseLong(appId);
            return (Application)this.applicationRepository.getReferenceById((Object)id);
        }
        catch (NullPointerException | EntityNotFoundException e) {
            this.logger.warn((Object)("No default application configured. " + e.getMessage()));
            return null;
        }
    }
}

