/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.controller;

import io.micrometer.core.annotation.Timed;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.validation.constraints.NotNull;
import nl.b3p.tailormap.api.annotation.AppRestController;
import nl.b3p.tailormap.api.geotools.featuresources.FeatureSourceFactoryHelper;
import nl.b3p.tailormap.api.geotools.processing.GeometryProcessor;
import nl.b3p.tailormap.api.model.ColumnMetadata;
import nl.b3p.tailormap.api.model.Feature;
import nl.b3p.tailormap.api.model.FeaturesResponse;
import nl.b3p.tailormap.api.util.Constants;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.app.ConfiguredAttribute;
import nl.tailormap.viewer.config.services.AttributeDescriptor;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.config.services.Layer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.GeometricShapeFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.filter.spatial.Intersects;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ResponseStatusException;

@AppRestController
@Validated
@RequestMapping(path={"/app/{appId}/layer/{appLayerId}/features"}, produces={"application/json"})
public class FeaturesController
implements Constants {
    @Value(value="${tailormap-api.pageSize:100}")
    private int pageSize;
    @Value(value="${tailormap-api.features.wfs_count_exact:false}")
    private boolean exactWfsCounts;
    @Value(value="${tailormap-api.features.skip_geometry_output:true}")
    private boolean skipGeometryOutput;
    private final FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
    private final Log logger = LogFactory.getLog(this.getClass());
    @PersistenceContext
    private EntityManager entityManager;

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    @Timed(value="get_features", description="time spent to process get features call")
    public ResponseEntity<Serializable> getFeatures(@ModelAttribute Application application, @ModelAttribute ApplicationLayer applicationLayer, @RequestParam(required=false) Double x, @RequestParam(required=false) Double y, @RequestParam(required=false) String crs, @RequestParam(defaultValue="4") Double distance, @RequestParam(required=false) String __fid, @RequestParam(defaultValue="false") Boolean simplify, @RequestParam(required=false) String filter, @RequestParam(required=false) Integer page, @RequestParam(required=false) String sortBy, @RequestParam(required=false, defaultValue="asc") String sortOrder, @RequestParam(defaultValue="false") boolean onlyGeometries) {
        FeaturesResponse featuresResponse;
        if (null != __fid) {
            featuresResponse = this.getFeatureByFID(applicationLayer, __fid, crs);
        } else if (null != x && null != y) {
            featuresResponse = this.getFeaturesByXY(applicationLayer, x, y, crs, distance, simplify);
        } else if (null != page && page > 0) {
            featuresResponse = this.getAllFeatures(applicationLayer, crs, page, filter, sortBy, sortOrder, onlyGeometries);
        } else {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Unsupported combination of request parameters, please check the documentation");
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)featuresResponse);
    }

    @NotNull
    private FeaturesResponse getAllFeatures(@NotNull ApplicationLayer appLayer, String crs, Integer page, String filterCQL, String sortBy, String sortOrder, boolean onlyGeometries) {
        FeaturesResponse featuresResponse = new FeaturesResponse().page(page).pageSize(Integer.valueOf(this.pageSize));
        Layer layer = appLayer.getService().getLayer(appLayer.getLayerName(), this.entityManager);
        nl.tailormap.viewer.config.services.SimpleFeatureType sft = layer.getFeatureType();
        if (null == sft) {
            return featuresResponse;
        }
        List configuredAttributes = this.getVisibleAttributes(appLayer, sft);
        try {
            int featureCount;
            String sortAttrName;
            SimpleFeatureSource fs = FeatureSourceFactoryHelper.openGeoToolsFeatureSource((nl.tailormap.viewer.config.services.SimpleFeatureType)sft);
            List<Object> propNames = configuredAttributes.stream().map(ConfiguredAttribute::getAttributeName).collect(Collectors.toList());
            propNames.remove(sft.getGeometryAttribute());
            if (onlyGeometries) {
                propNames = List.of(sft.getGeometryAttribute());
                sortAttrName = null;
            } else {
                sortAttrName = (String)propNames.get(0);
                if (sft.getPrimaryKeyAttribute() != null && propNames.contains(sft.getPrimaryKeyAttribute())) {
                    sortAttrName = sft.getPrimaryKeyAttribute();
                    this.logger.trace((Object)"Sorting by primary key");
                } else {
                    for (AttributeDescriptor attrDesc : sft.getAttributes()) {
                        if (!propNames.contains(attrDesc.getName())) continue;
                        sortAttrName = attrDesc.getName();
                        break;
                    }
                }
            }
            if (null != sortBy) {
                if (propNames.contains(sortBy) && !(sft.getAttribute(sortBy) instanceof GeometryDescriptor)) {
                    sortAttrName = sortBy;
                } else {
                    this.logger.warn((Object)("Requested sortBy attribute " + sortBy + " was not found in configured attributes or is a geometry attribute."));
                }
            }
            SortOrder _sortOrder = SortOrder.ASCENDING;
            if (null != sortOrder && (sortOrder.equalsIgnoreCase("desc") || sortOrder.equalsIgnoreCase("asc"))) {
                _sortOrder = SortOrder.valueOf((String)sortOrder.toUpperCase());
            }
            Query q = new Query(fs.getName().toString());
            q.setPropertyNames(propNames);
            if (null != filterCQL) {
                Filter filter = ECQL.toFilter((String)filterCQL);
                q.setFilter(filter);
                featureCount = fs.getCount(q);
                if (featureCount == -1 && this.exactWfsCounts) {
                    featureCount = fs.getFeatures(q).size();
                }
            } else {
                featureCount = fs.getCount(Query.ALL);
                if (featureCount == -1 && this.exactWfsCounts) {
                    featureCount = fs.getFeatures(Query.ALL).size();
                }
            }
            featuresResponse.setTotal(Integer.valueOf(featureCount));
            if (sortAttrName != null) {
                q.setSortBy(new SortBy[]{this.ff.sort(sortAttrName, _sortOrder)});
            }
            q.setMaxFeatures(this.pageSize);
            q.setStartIndex(Integer.valueOf((page - 1) * this.pageSize));
            this.logger.debug((Object)("Attribute query: " + q));
            this.executeQueryOnFeatureSourceAndClose(false, featuresResponse, sft, configuredAttributes, onlyGeometries, fs, q, this.determineProjectToCRS(crs, fs));
        }
        catch (IOException e) {
            this.logger.error((Object)"Could not retrieve attribute data.", (Throwable)e);
        }
        catch (CQLException e) {
            this.logger.error((Object)"Could not parse requested filter.", (Throwable)e);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Could not parse requested filter.");
        }
        return featuresResponse;
    }

    @NotNull
    private FeaturesResponse getFeatureByFID(@NotNull ApplicationLayer appLayer, @NotNull String fid, String crs) {
        FeaturesResponse featuresResponse = new FeaturesResponse();
        Layer layer = appLayer.getService().getLayer(appLayer.getLayerName(), this.entityManager);
        nl.tailormap.viewer.config.services.SimpleFeatureType sft = layer.getFeatureType();
        if (null == sft) {
            return featuresResponse;
        }
        List configuredAttributes = this.getVisibleAttributes(appLayer, sft);
        try {
            SimpleFeatureSource fs = FeatureSourceFactoryHelper.openGeoToolsFeatureSource((nl.tailormap.viewer.config.services.SimpleFeatureType)sft);
            List propNames = configuredAttributes.stream().map(ConfiguredAttribute::getAttributeName).collect(Collectors.toList());
            if (!propNames.contains(sft.getGeometryAttribute())) {
                propNames.add(sft.getGeometryAttribute());
            }
            Query q = new Query(fs.getName().toString());
            q.setFilter((Filter)this.ff.id(new FeatureId[]{this.ff.featureId(fid)}));
            q.setPropertyNames(propNames);
            q.setMaxFeatures(1);
            this.logger.debug((Object)("FID query: " + q));
            this.executeQueryOnFeatureSourceAndClose(false, featuresResponse, sft, configuredAttributes, false, fs, q, this.determineProjectToCRS(crs, fs));
        }
        catch (IOException e) {
            this.logger.error((Object)"Could not retrieve attribute data.", (Throwable)e);
        }
        return featuresResponse;
    }

    private CoordinateReferenceSystem determineProjectToCRS(String requestCrs, SimpleFeatureSource fs) {
        CoordinateReferenceSystem projectToCRS = null;
        if (null != requestCrs) {
            try {
                CoordinateReferenceSystem dataSourceCRS = ((SimpleFeatureType)fs.getSchema()).getCoordinateReferenceSystem();
                if (!((DefaultProjectedCRS)dataSourceCRS).getIdentifier(null).toString().equalsIgnoreCase(requestCrs)) {
                    projectToCRS = CRS.decode((String)requestCrs);
                }
            }
            catch (FactoryException e) {
                this.logger.warn((Object)"Unable to transform query geometry to desired CRS", (Throwable)e);
            }
        }
        return projectToCRS;
    }

    @NotNull
    private FeaturesResponse getFeaturesByXY(@NotNull ApplicationLayer appLayer, @NotNull Double x, @NotNull Double y, String crs, @NotNull Double distance, @NotNull Boolean simplifyGeometry) {
        if (null != distance && 0.0 > distance) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Buffer distance must be greater than 0");
        }
        FeaturesResponse featuresResponse = new FeaturesResponse();
        GeoService geoService = appLayer.getService();
        Layer layer = geoService.getLayer(appLayer.getLayerName(), this.entityManager);
        nl.tailormap.viewer.config.services.SimpleFeatureType sft = layer.getFeatureType();
        if (null == sft) {
            return featuresResponse;
        }
        List configuredAttributes = appLayer.getAttributes(sft);
        configuredAttributes = configuredAttributes.stream().filter(ConfiguredAttribute::isVisible).collect(Collectors.toList());
        try {
            SimpleFeatureSource fs = FeatureSourceFactoryHelper.openGeoToolsFeatureSource((nl.tailormap.viewer.config.services.SimpleFeatureType)sft);
            Query q = new Query(fs.getName().toString());
            GeometricShapeFactory shapeFact = new GeometricShapeFactory();
            shapeFact.setNumPoints(32);
            shapeFact.setCentre(new Coordinate(x.doubleValue(), y.doubleValue()));
            shapeFact.setSize(distance * 2.0);
            Polygon p = shapeFact.createCircle();
            this.logger.debug((Object)("created geometry: " + (Geometry)p));
            CoordinateReferenceSystem fromCRS = this.determineProjectToCRS(crs, fs);
            if (null != fromCRS) {
                try {
                    CoordinateReferenceSystem toCRS = ((SimpleFeatureType)fs.getSchema()).getCoordinateReferenceSystem();
                    MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)fromCRS, (CoordinateReferenceSystem)toCRS, (boolean)true);
                    p = JTS.transform((Geometry)p, (MathTransform)transform);
                    this.logger.debug((Object)("reprojected geometry to: " + (Geometry)p));
                }
                catch (FactoryException | TransformException e) {
                    this.logger.warn((Object)"Unable to transform query geometry to desired CRS, trying with original CRS");
                }
            }
            this.logger.debug((Object)("using geometry: " + (Geometry)p));
            Intersects spatialFilter = this.ff.intersects((Expression)this.ff.property(sft.getGeometryAttribute()), (Expression)this.ff.literal((Object)p));
            List propNames = configuredAttributes.stream().map(ConfiguredAttribute::getAttributeName).collect(Collectors.toList());
            if (!propNames.contains(sft.getGeometryAttribute())) {
                propNames.add(sft.getGeometryAttribute());
            }
            q.setPropertyNames(propNames);
            q.setFilter((Filter)spatialFilter);
            q.setMaxFeatures(10);
            this.executeQueryOnFeatureSourceAndClose(simplifyGeometry.booleanValue(), featuresResponse, sft, configuredAttributes, false, fs, q, fromCRS);
        }
        catch (IOException e) {
            this.logger.error((Object)"Could not retrieve attribute data.", (Throwable)e);
        }
        return featuresResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQueryOnFeatureSourceAndClose(boolean simplifyGeometry, @NotNull FeaturesResponse featuresResponse, @NotNull nl.tailormap.viewer.config.services.SimpleFeatureType sft, List<ConfiguredAttribute> configuredAttributes, boolean onlyGeometries, @NotNull SimpleFeatureSource fs, @NotNull Query q, CoordinateReferenceSystem projectToCRS) throws IOException {
        boolean addFields = false;
        MathTransform transform = null;
        if (null != projectToCRS) {
            try {
                transform = CRS.findMathTransform((CoordinateReferenceSystem)((SimpleFeatureType)fs.getSchema()).getCoordinateReferenceSystem(), (CoordinateReferenceSystem)projectToCRS, (boolean)true);
            }
            catch (FactoryException e) {
                this.logger.error((Object)"Can not transform geometry to desired CRS.", (Throwable)e);
            }
        }
        try (SimpleFeatureIterator feats = fs.getFeatures(q).features();){
            while (feats.hasNext()) {
                addFields = true;
                SimpleFeature feature = (SimpleFeature)feats.next();
                String processedGeometry = GeometryProcessor.processGeometry((Object)feature.getAttribute(sft.getGeometryAttribute()), (Boolean)simplifyGeometry, (MathTransform)transform);
                Feature newFeat = new Feature().fid(feature.getIdentifier().getID()).geometry(processedGeometry);
                if (!onlyGeometries) {
                    configuredAttributes.forEach(configuredAttribute -> {
                        if (configuredAttribute.getAttributeName().equals(sft.getGeometryAttribute())) {
                            newFeat.putAttributesItem(configuredAttribute.getAttributeName(), (Object)processedGeometry);
                        } else {
                            Object attrValue = feature.getAttribute(configuredAttribute.getAttributeName());
                            if (attrValue instanceof Geometry) {
                                attrValue = this.skipGeometryOutput ? null : GeometryProcessor.geometryToJson((Geometry)((Geometry)attrValue));
                            }
                            newFeat.putAttributesItem(configuredAttribute.getAttributeName(), attrValue);
                        }
                    });
                }
                featuresResponse.addFeaturesItem(newFeat);
            }
        }
        finally {
            fs.getDataStore().dispose();
        }
        if (addFields) {
            configuredAttributes.forEach(configuredAttribute -> {
                AttributeDescriptor attributeDescriptor = sft.getAttribute(configuredAttribute.getAttributeName());
                String type = attributeDescriptor.getType();
                if (AttributeDescriptor.GEOMETRY_TYPES.contains(type)) {
                    type = "geometry";
                }
                featuresResponse.addColumnMetadataItem(new ColumnMetadata().key(attributeDescriptor.getName()).type(ColumnMetadata.TypeEnum.fromValue((String)type)).alias(attributeDescriptor.getAlias()));
            });
        }
    }

    private List<ConfiguredAttribute> getVisibleAttributes(@NotNull ApplicationLayer appLayer, @NotNull nl.tailormap.viewer.config.services.SimpleFeatureType sft) {
        List configuredAttributes = appLayer.getAttributes(sft);
        return configuredAttributes.stream().filter(ConfiguredAttribute::isVisible).collect(Collectors.toList());
    }
}

