/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.controller;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.validation.constraints.NotNull;
import nl.b3p.tailormap.api.annotation.AppRestController;
import nl.b3p.tailormap.api.model.Attribute;
import nl.b3p.tailormap.api.model.LayerDetails;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.app.ConfiguredAttribute;
import nl.tailormap.viewer.config.services.AttributeDescriptor;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.config.services.SimpleFeatureType;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@AppRestController
@Validated
@RequestMapping(path={"/app/{appId}/layer/{appLayerId}/describe"}, produces={"application/json"})
public class LayerDescriptionController {
    @PersistenceContext
    private EntityManager entityManager;

    @GetMapping
    public ResponseEntity<Serializable> getAppLayerDescription(@ModelAttribute Application application, @ModelAttribute ApplicationLayer applicationLayer) {
        Layer layer = applicationLayer.getService().getLayer(applicationLayer.getLayerName(), this.entityManager);
        if (layer == null) {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)String.format("Can't find layer in service #%d with name \"%s\"", applicationLayer.getService().getId(), applicationLayer.getLayerName()));
        }
        SimpleFeatureType sft = layer.getFeatureType();
        if (sft == null) {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)"Layer does not have feature type");
        }
        LayerDetails r = new LayerDetails();
        r.setId(applicationLayer.getId());
        r.setServiceId(applicationLayer.getService().getId());
        r.setFeatureTypeName(sft.getTypeName());
        r.setGeometryAttribute(sft.getGeometryAttribute());
        r.attributes(this.getVisibleAttributes(applicationLayer, sft).stream().map(ca -> {
            AttributeDescriptor ad = sft.getAttribute(ca.getAttributeName());
            Attribute a = new Attribute();
            a.setId(ca.getId());
            a.setName(ad.getName());
            a.setAlias(ad.getAlias());
            a.setEditAlias(ca.getEditAlias());
            a.setType(Attribute.TypeEnum.fromValue((String)ad.getType()));
            return a;
        }).collect(Collectors.toList()));
        return ResponseEntity.ok((Object)r);
    }

    private List<ConfiguredAttribute> getVisibleAttributes(@NotNull ApplicationLayer appLayer, @NotNull SimpleFeatureType sft) {
        List configuredAttributes = appLayer.getAttributes(sft);
        return configuredAttributes.stream().filter(ConfiguredAttribute::isVisible).collect(Collectors.toList());
    }
}

