/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.controller;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.http.HttpResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import nl.b3p.tailormap.api.MicrometerHelper;
import nl.b3p.tailormap.api.annotation.AppRestController;
import nl.b3p.tailormap.api.controller.LayerExportController;
import nl.b3p.tailormap.api.geotools.wfs.SimpleWFSHelper;
import nl.b3p.tailormap.api.geotools.wfs.SimpleWFSLayerDescription;
import nl.b3p.tailormap.api.geotools.wfs.WFSProxy;
import nl.b3p.tailormap.api.model.LayerExportCapabilities;
import nl.b3p.tailormap.api.repository.LayerRepository;
import nl.b3p.tailormap.api.util.HttpProxyUtil;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.services.FeatureSource;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.config.services.SimpleFeatureType;
import nl.tailormap.viewer.config.services.WFSFeatureSource;
import nl.tailormap.viewer.config.services.WMSService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@AppRestController
@Validated
@RequestMapping(path={"/app/{appId}/layer/{appLayerId}/export/"})
public class LayerExportController {
    private static final Log LOG = LogFactory.getLog(LayerExportController.class);
    private final MeterRegistry meterRegistry;
    private final LayerRepository layerRepository;

    public LayerExportController(LayerRepository layerRepository, MeterRegistry meterRegistry) {
        this.layerRepository = layerRepository;
        this.meterRegistry = meterRegistry;
    }

    @GetMapping(path={"capabilities"})
    @Timed(value="export_get_capabilities")
    public ResponseEntity<Serializable> capabilities(@ModelAttribute Application application, @ModelAttribute ApplicationLayer applicationLayer) throws Exception {
        LayerExportCapabilities capabilities = new LayerExportCapabilities();
        this.findWFS(application, applicationLayer, params -> {
            if (params.noWFSFound()) {
                capabilities.setOutputFormats(null);
                return null;
            }
            try {
                List outputFormats = (List)this.meterRegistry.timer("export_get_capabilities_get_wfs_capabilities", (Iterable)params.getMicrometerTags()).recordCallable(() -> SimpleWFSHelper.getOutputFormats((String)params.getWfsUrl(), (String)params.getTypeName(), (String)params.getUsername(), (String)params.getPassword()));
                capabilities.setOutputFormats(outputFormats);
            }
            catch (Exception e) {
                String msg = String.format("Error getting capabilities for WFS \"%s\"", params.getWfsUrl());
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)msg, (Throwable)e);
                } else {
                    LOG.warn((Object)String.format("%s: %s: %s", msg, e.getClass(), e.getMessage()));
                }
                capabilities.setOutputFormats(null);
            }
            return null;
        });
        capabilities.setExportable(Boolean.valueOf(capabilities.getOutputFormats() != null && !capabilities.getOutputFormats().isEmpty()));
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)capabilities);
    }

    @RequestMapping(path={"download"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseEntity<?> download(@ModelAttribute Application application, @ModelAttribute ApplicationLayer applicationLayer, @RequestParam String outputFormat, @RequestParam(required=false) List<String> attributes, @RequestParam(required=false) String filter, @RequestParam(required=false) String sortBy, @RequestParam(required=false) String sortOrder, @RequestParam(required=false) String crs, HttpServletRequest request) throws Exception {
        return (ResponseEntity)this.findWFS(application, applicationLayer, params -> {
            if (params.noWFSFound()) {
                return ResponseEntity.status((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE).body((Object)"No suitable WFS available for layer export");
            }
            return this.downloadFromWFS(params, outputFormat, attributes, filter, sortBy, sortOrder, crs, request);
        });
    }

    private ResponseEntity<?> downloadFromWFS(WFSSearchResultParams params, String outputFormat, List<String> attributes, String filter, String sortBy, String sortOrder, String crs, HttpServletRequest request) {
        Tags tags = params.getMicrometerTags().and(new Tag[]{Tag.of((String)"format", (String)outputFormat)});
        LinkedMultiValueMap getFeatureParameters = new LinkedMultiValueMap();
        getFeatureParameters.add((Object)"typeNames", (Object)params.getTypeName());
        getFeatureParameters.add((Object)"outputFormat", (Object)outputFormat);
        if (filter != null) {
            getFeatureParameters.add((Object)"cql_filter", (Object)filter);
        }
        if (crs != null) {
            getFeatureParameters.add((Object)"srsName", (Object)crs);
        }
        if (attributes != null && !attributes.isEmpty() && params.getGeometryAttribute() != null) {
            attributes.add(params.getGeometryAttribute());
            getFeatureParameters.add((Object)"propertyName", (Object)String.join((CharSequence)",", attributes));
        }
        if (sortBy != null) {
            getFeatureParameters.add((Object)"sortBy", (Object)(sortBy + ("asc".equals(sortOrder) ? " A" : " D")));
        }
        URI wfsGetFeature = SimpleWFSHelper.getWFSRequestURL((String)params.getWfsUrl(), (String)"GetFeature", (MultiValueMap)getFeatureParameters);
        LOG.info((Object)String.format("Layer download %s, proxying WFS GetFeature request %s", MicrometerHelper.tagsToString((Tags)tags), wfsGetFeature));
        try {
            HttpResponse response = (HttpResponse)this.meterRegistry.timer("export_download_first_response", (Iterable)tags).recordCallable(() -> WFSProxy.proxyWfsRequest((URI)wfsGetFeature, (String)params.getUsername(), (String)params.getPassword(), (HttpServletRequest)request));
            this.meterRegistry.counter("export_download_response", (Iterable)tags.and("response_status", "" + response.statusCode())).increment();
            LOG.info((Object)String.format("Layer download response code: %s, content type: %s, disposition: %s", response.statusCode(), response.headers().firstValue("Content-Type").map(Object::toString).orElse("<none>"), response.headers().firstValue("Content-Disposition").map(Object::toString).orElse("<none>")));
            InputStreamResource body = new InputStreamResource((InputStream)response.body());
            HttpHeaders headers = HttpProxyUtil.passthroughResponseHeaders((java.net.http.HttpHeaders)response.headers(), Set.of("Content-Type", "Content-Disposition"));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)response.statusCode()).headers(headers)).body((Object)body);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_GATEWAY).body((Object)"Bad Gateway");
        }
    }

    private Object findWFS(Application application, ApplicationLayer applicationLayer, Function<WFSSearchResultParams, ?> function) throws Exception {
        FeatureSource featureSource;
        GeoService service = applicationLayer.getService();
        Layer serviceLayer = this.layerRepository.getByServiceAndName(service, applicationLayer.getLayerName());
        SimpleFeatureType featureType = serviceLayer.getFeatureType();
        Tags tags = MicrometerHelper.getTags((Object[])new Object[]{application, applicationLayer, service, serviceLayer, featureType});
        String wfsUrl = null;
        String typeName = null;
        String username = null;
        String password = null;
        String geometryAttribute = null;
        if (featureType != null && (featureSource = featureType.getFeatureSource()) instanceof WFSFeatureSource) {
            wfsUrl = featureSource.getUrl();
            typeName = featureType.getTypeName();
            username = featureSource.getUsername();
            password = featureSource.getPassword();
            geometryAttribute = featureType.getGeometryAttribute();
        }
        if ((wfsUrl == null || typeName == null) && service instanceof WMSService) {
            WMSService wmsService = (WMSService)service;
            username = wmsService.getUsername();
            password = wmsService.getPassword();
            SimpleWFSLayerDescription wfsLayerDescription = this.getWFSLayerDescriptionForWMS(wmsService, serviceLayer, tags);
            if (wfsLayerDescription != null) {
                tags = tags.and("featureSourceUrl", wfsLayerDescription.getWfsUrl()).and("featureTypeName", wfsLayerDescription.getFirstTypeName());
                wfsUrl = wfsLayerDescription.getWfsUrl();
                typeName = wfsLayerDescription.getFirstTypeName();
            }
        }
        if (wfsUrl != null && typeName != null) {
            tags = tags.and("featureSourceUrl", wfsUrl).and("featureTypeName", typeName);
        }
        return function.apply(new WFSSearchResultParams(wfsUrl, typeName, geometryAttribute, username, password, tags));
    }

    private SimpleWFSLayerDescription getWFSLayerDescriptionForWMS(WMSService wmsService, Layer serviceLayer, Tags tags) throws Exception {
        SimpleWFSLayerDescription wfsLayerDescription = (SimpleWFSLayerDescription)this.meterRegistry.timer("export_get_capabilities_wms_describelayer", (Iterable)tags).recordCallable(() -> SimpleWFSHelper.describeWMSLayer((String)wmsService.getUrl(), (String)wmsService.getUsername(), (String)wmsService.getPassword(), List.of(serviceLayer.getName())));
        if (wfsLayerDescription != null && wfsLayerDescription.getTypeNames().length > 0) {
            LOG.info((Object)String.format("WMS described layer \"%s\" with typeNames \"%s\" of WFS \"%s\" for WMS \"%s\"", serviceLayer.getName(), Arrays.toString(wfsLayerDescription.getTypeNames()), wfsLayerDescription.getWfsUrl(), wmsService.getUrl()));
            return wfsLayerDescription;
        }
        return null;
    }
}

