/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.controller;

import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotNull;
import nl.b3p.tailormap.api.annotation.AppRestController;
import nl.b3p.tailormap.api.controller.GeoServiceProxyController;
import nl.b3p.tailormap.api.geotools.referencing.ReferencingHelper;
import nl.b3p.tailormap.api.model.AppLayer;
import nl.b3p.tailormap.api.model.Bounds;
import nl.b3p.tailormap.api.model.CoordinateReferenceSystem;
import nl.b3p.tailormap.api.model.LayerTreeNode;
import nl.b3p.tailormap.api.model.MapResponse;
import nl.b3p.tailormap.api.model.Service;
import nl.b3p.tailormap.api.repository.ApplicationLayerRepository;
import nl.b3p.tailormap.api.repository.ApplicationRepository;
import nl.b3p.tailormap.api.repository.LayerRepository;
import nl.b3p.tailormap.api.repository.LevelRepository;
import nl.b3p.tailormap.api.security.AuthorizationService;
import nl.b3p.tailormap.api.util.ParseUtil;
import nl.tailormap.viewer.config.ClobElement;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.app.Level;
import nl.tailormap.viewer.config.app.StartLayer;
import nl.tailormap.viewer.config.app.StartLevel;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.config.services.TileService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@AppRestController
@Validated
@RequestMapping(path={"/app/{appId}/map"}, produces={"application/json"})
public class MapController {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ApplicationRepository applicationRepository;
    private final ApplicationLayerRepository applicationLayerRepository;
    private final LevelRepository levelRepository;
    private final LayerRepository layerRepository;
    private final AuthorizationService authorizationService;

    public MapController(ApplicationRepository applicationRepository, ApplicationLayerRepository applicationLayerRepository, LevelRepository levelRepository, LayerRepository layerRepository, AuthorizationService authorizationService) {
        this.applicationRepository = applicationRepository;
        this.applicationLayerRepository = applicationLayerRepository;
        this.levelRepository = levelRepository;
        this.layerRepository = layerRepository;
        this.authorizationService = authorizationService;
    }

    @GetMapping(produces={"application/json"})
    @ResponseBody
    @Timed(value="get_map", description="time spent to process get the map of an application")
    public ResponseEntity<Serializable> get(@ModelAttribute Application application) {
        this.logger.trace((Object)("Loading map related entities for application id: " + application.getId()));
        this.applicationRepository.findWithGeoservicesById(application.getId());
        MapResponse mapResponse = new MapResponse();
        this.getApplicationParams(application, mapResponse);
        this.getLayers(application, mapResponse);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)mapResponse);
    }

    private void getApplicationParams(@NotNull Application a, @NotNull MapResponse mapResponse) {
        String pCode = a.getProjectionCode();
        CoordinateReferenceSystem c = new CoordinateReferenceSystem();
        if (null != pCode) {
            c.code(ParseUtil.parseEpsgCode((String)pCode)).definition(ParseUtil.parseProjDefintion((String)pCode));
        }
        Bounds maxExtent = new Bounds();
        if (null != a.getMaxExtent()) {
            maxExtent.minx(a.getMaxExtent().getMinx()).miny(a.getMaxExtent().getMiny()).maxx(a.getMaxExtent().getMaxx()).maxy(a.getMaxExtent().getMaxy()).crs(a.getMaxExtent().getCrs().getName());
        } else {
            maxExtent = ReferencingHelper.crsBoundsExtractor((String)c.getCode());
        }
        Bounds initialExtent = new Bounds();
        if (null != a.getStartExtent()) {
            initialExtent.minx(a.getStartExtent().getMinx()).miny(a.getStartExtent().getMiny()).maxx(a.getStartExtent().getMaxx()).maxy(a.getStartExtent().getMaxy()).crs(a.getStartExtent().getCrs().getName());
        } else {
            initialExtent = maxExtent;
        }
        mapResponse.crs(c).maxExtent(maxExtent).initialExtent(initialExtent);
    }

    private String getNameForAppLayer(@NotNull ApplicationLayer layer, @NotNull List<Layer> layers) {
        if (StringUtils.isNotBlank((CharSequence)Optional.ofNullable((ClobElement)layer.getDetails().get("titleAlias")).map(Object::toString).orElse(""))) {
            return ((ClobElement)layer.getDetails().get("titleAlias")).getValue();
        }
        Layer serviceLayer = null;
        for (Layer possibleLayer : layers) {
            if (!possibleLayer.getService().equals(layer.getService()) || !Objects.equals(possibleLayer.getName(), layer.getLayerName())) continue;
            serviceLayer = possibleLayer;
            break;
        }
        if (serviceLayer != null) {
            return serviceLayer.getDisplayName();
        }
        return layer.getLayerName();
    }

    private static boolean isAuthorized(Set<String> readers, Authentication auth) {
        if (readers == null || readers.isEmpty()) {
            return true;
        }
        for (String reader : readers) {
            if (!auth.getAuthorities().stream().anyMatch(x -> x.getAuthority().equals(reader))) continue;
            return true;
        }
        return false;
    }

    private void getLayers(@NotNull Application a, @NotNull MapResponse mapResponse) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        LayerTreeNode rootNode = new LayerTreeNode().id("root").root(Boolean.valueOf(true)).name("Foreground");
        mapResponse.addLayerTreeNodesItem(rootNode);
        LayerTreeNode rootBackgroundNode = new LayerTreeNode().id("rootbg").root(Boolean.valueOf(true)).name("Background");
        mapResponse.addBaseLayerTreeNodesItem(rootBackgroundNode);
        ArrayList<Long> ids = new ArrayList<Long>();
        HashMap levelChildrenMap = new HashMap();
        for (Level level : this.levelRepository.findByLevelTree(a.getRoot().getId())) {
            if (level.getParent() != null) {
                levelChildrenMap.computeIfAbsent(level.getParent().getId(), t -> new ArrayList()).add(level);
            }
            ids.add(level.getId());
        }
        this.levelRepository.findWithAuthorizationDataByIdIn(ids);
        HashSet<Long> applicationLayerIds = new HashSet<Long>();
        List startLayers = a.getStartLayers();
        for (Object startLayer : startLayers) {
            if (startLayer.isRemoved()) continue;
            applicationLayerIds.add(startLayer.getApplicationLayer().getId());
        }
        this.applicationLayerRepository.findWithReadersAndDetailsByIdIn(applicationLayerIds);
        HashMap<Long, StartLayer> layerMap = new HashMap<Long, StartLayer>(startLayers.size());
        for (StartLayer startLayer : startLayers) {
            ApplicationLayer appLayer;
            if (startLayer.isRemoved() || !MapController.isAuthorized((Set)(appLayer = startLayer.getApplicationLayer()).getReaders(), (Authentication)authentication) || this.authorizationService.isProxiedSecuredServiceLayerInPublicApplication(a, appLayer)) continue;
            layerMap.put(appLayer.getId(), startLayer);
        }
        List startLevels = a.getStartLevels();
        startLevels.removeIf(t -> t.isRemoved() || t.getSelectedIndex() == null);
        startLevels.sort(Comparator.comparingLong(StartLevel::getSelectedIndex));
        HashSet<Long> visibleLevels = new HashSet<Long>();
        ArrayList<StartLayer> visibleStartLayers = new ArrayList<StartLayer>();
        ArrayDeque<Object> levelQueue = new ArrayDeque<Object>();
        for (Object l : startLevels) {
            levelQueue.add(l.getLevel());
            while (!levelQueue.isEmpty()) {
                Level level = (Level)levelQueue.pop();
                if (visibleLevels.contains(level.getId()) || !MapController.isAuthorized((Set)level.getReaders(), (Authentication)authentication)) continue;
                visibleLevels.add(level.getId());
                levelQueue.addAll(levelChildrenMap.getOrDefault(level.getId(), List.of()));
                for (ApplicationLayer applicationLayer : level.getLayers()) {
                    StartLayer startLayer = (StartLayer)layerMap.get(applicationLayer.getId());
                    if (startLayer == null) continue;
                    visibleStartLayers.add(startLayer);
                }
            }
        }
        HashSet<Long> neededServiceIds = new HashSet<Long>();
        for (StartLayer startLayer : visibleStartLayers) {
            neededServiceIds.add(startLayer.getApplicationLayer().getService().getId());
        }
        List layers = this.layerRepository.findByServiceIdIn(neededServiceIds);
        for (StartLayer startLayer : visibleStartLayers) {
            boolean isLayerVisible;
            ApplicationLayer applicationLayer = startLayer.getApplicationLayer();
            Layer serviceVisibilityLayer = null;
            for (Layer l : layers) {
                if (!l.getService().equals(applicationLayer.getService()) || !Objects.equals(l.getName(), applicationLayer.getLayerName())) continue;
                serviceVisibilityLayer = l;
                break;
            }
            boolean bl = isLayerVisible = serviceVisibilityLayer != null && MapController.isAuthorized((Set)serviceVisibilityLayer.getService().getReaders(), (Authentication)authentication);
            while (isLayerVisible && serviceVisibilityLayer != null) {
                if (!MapController.isAuthorized((Set)serviceVisibilityLayer.getReaders(), (Authentication)authentication)) {
                    isLayerVisible = false;
                    break;
                }
                serviceVisibilityLayer = serviceVisibilityLayer.getParent();
            }
            if (isLayerVisible) continue;
            layerMap.remove(applicationLayer.getId());
        }
        visibleStartLayers.clear();
        HashMap<Long, LayerTreeNode> hashMap = new HashMap<Long, LayerTreeNode>();
        for (StartLevel startLevel : startLevels) {
            LayerTreeNode chosenRoot;
            List treeNodeList;
            boolean isBackground = false;
            for (Level parentLevel = startLevel.getLevel(); parentLevel != null && !isBackground; parentLevel = parentLevel.getParent()) {
                isBackground = parentLevel.isBackground();
            }
            Level startLevel2 = startLevel.getLevel();
            if (isBackground) {
                treeNodeList = mapResponse.getBaseLayerTreeNodes();
                chosenRoot = rootBackgroundNode;
            } else {
                treeNodeList = mapResponse.getLayerTreeNodes();
                chosenRoot = rootNode;
            }
            levelQueue.add(startLevel2);
            while (!levelQueue.isEmpty()) {
                Level level = (Level)levelQueue.pop();
                if (hashMap.containsKey(level.getId()) || !visibleLevels.contains(level.getId())) continue;
                LayerTreeNode childNode = new LayerTreeNode().id(String.format("lvl_%d", level.getId())).name(level.getName()).description(level.getInfo()).root(Boolean.valueOf(false)).childrenIds(new ArrayList());
                treeNodeList.add(childNode);
                hashMap.put(level.getId(), childNode);
                LayerTreeNode parentNode = level == startLevel2 ? chosenRoot : (LayerTreeNode)hashMap.get(level.getParent().getId());
                parentNode.addChildrenIdsItem(childNode.getId());
                levelQueue.addAll(levelChildrenMap.getOrDefault(level.getId(), List.of()));
                for (ApplicationLayer layer : level.getLayers()) {
                    StartLayer startLayer = (StartLayer)layerMap.get(layer.getId());
                    if (startLayer == null) continue;
                    visibleStartLayers.add(startLayer);
                    LayerTreeNode layerNode = new LayerTreeNode().id(String.format("lyr_%d", layer.getId())).name(this.getNameForAppLayer(layer, layers)).description((String)Optional.ofNullable((ClobElement)layer.getDetails().get("context")).map(Object::toString).orElse(null)).appLayerId(Integer.valueOf((int)layer.getId().longValue())).root(Boolean.valueOf(false)).childrenIds(new ArrayList());
                    treeNodeList.add(layerNode);
                    childNode.addChildrenIdsItem(layerNode.getId());
                }
            }
        }
        for (StartLayer startLayer : visibleStartLayers) {
            ApplicationLayer applicationLayer = startLayer.getApplicationLayer();
            Layer serviceLayer = null;
            for (Layer layer : layers) {
                if (!layer.getService().equals(applicationLayer.getService()) || !Objects.equals(layer.getName(), applicationLayer.getLayerName())) continue;
                serviceLayer = layer;
                break;
            }
            AppLayer.HiDpiModeEnum hiDpiMode = null;
            String hiDpiSubstituteLayer = null;
            if (serviceLayer != null) {
                hiDpiMode = Optional.ofNullable((ClobElement)serviceLayer.getDetails().get("hidpi.mode")).map(Object::toString).map(AppLayer.HiDpiModeEnum::fromValue).orElse(null);
                hiDpiSubstituteLayer = Optional.ofNullable((ClobElement)serviceLayer.getDetails().get("hidpi.substitute_layer")).map(Object::toString).orElse(null);
            }
            assert (serviceLayer != null);
            GeoService geoService = applicationLayer.getService();
            boolean proxied = Boolean.parseBoolean(String.valueOf(geoService.getDetails().get("useProxy")));
            String legendImageUrl = serviceLayer.getLegendImageUrl();
            if (legendImageUrl != null && proxied) {
                UriComponents geoServiceUrl = UriComponentsBuilder.fromHttpUrl((String)geoService.getUrl()).build(true);
                UriComponents legendUrl = UriComponentsBuilder.fromHttpUrl((String)legendImageUrl).build(true);
                if (Objects.equals(geoServiceUrl.getHost(), legendUrl.getHost()) && Objects.equals(geoServiceUrl.getPath(), legendUrl.getPath())) {
                    UriComponentsBuilder legendUrlBuilder = UriComponentsBuilder.fromHttpUrl((String)MapController.getProxyUrl((GeoService)geoService, (Application)a, (ApplicationLayer)applicationLayer));
                    legendImageUrl = legendUrlBuilder.queryParams(legendUrl.getQueryParams()).build(true).toUriString();
                }
            }
            int opacity = Optional.ofNullable((ClobElement)applicationLayer.getDetails().get("transparency")).map(Object::toString).map(Integer::parseInt).map(transparency -> 100 - transparency).orElse(100);
            AppLayer appLayer = new AppLayer().id(applicationLayer.getId()).layerName(serviceLayer.getName()).title(this.getNameForAppLayer(applicationLayer, layers)).serviceId(applicationLayer.getService().getId()).url(proxied ? MapController.getProxyUrl((GeoService)geoService, (Application)a, (ApplicationLayer)applicationLayer) : null).visible(Boolean.valueOf(startLayer.isChecked())).opacity(Integer.valueOf(opacity)).maxScale(serviceLayer.getMaxScale()).minScale(serviceLayer.getMinScale()).legendImageUrl(legendImageUrl).hiDpiMode(hiDpiMode).hiDpiSubstituteLayer(hiDpiSubstituteLayer).hasAttributes(Boolean.valueOf(!startLayer.getApplicationLayer().getAttributes().isEmpty()));
            mapResponse.addAppLayersItem(appLayer);
            Service.ServerTypeEnum serviceServerType = Optional.ofNullable((ClobElement)geoService.getDetails().get("serverType")).map(Object::toString).map(Service.ServerTypeEnum::fromValue).orElse(Service.ServerTypeEnum.AUTO);
            Integer tilingGutter = Optional.ofNullable((ClobElement)geoService.getDetails().get("tiling.gutter")).map(Object::toString).map(Integer::parseInt).orElse(null);
            boolean tilingDisabled = Optional.ofNullable((ClobElement)geoService.getDetails().get("tiling.disable")).map(Object::toString).map(Boolean::parseBoolean).orElse(false);
            Service s = new Service().url(proxied ? null : geoService.getUrl()).id(geoService.getId()).name(geoService.getName()).protocol(Service.ProtocolEnum.fromValue((String)geoService.getProtocol())).serverType(serviceServerType).tilingDisabled(Boolean.valueOf(tilingDisabled)).tilingGutter(tilingGutter).capabilities(geoService.getCapabilitiesDoc());
            if (geoService.getProtocol().equalsIgnoreCase("tiled")) {
                s.tilingProtocol(Service.TilingProtocolEnum.fromValue((String)((TileService)geoService).getTilingProtocol()));
            }
            mapResponse.addServicesItem(s);
        }
    }

    private static String getProxyUrl(GeoService geoService, Application application, ApplicationLayer appLayer) {
        WebMvcLinkBuilder linkBuilder;
        if ("wms".equals(geoService.getProtocol())) {
            linkBuilder = WebMvcLinkBuilder.linkTo(GeoServiceProxyController.class, Map.of("appId", application.getId(), "appLayerId", appLayer.getId(), "protocol", "wms"));
        } else if ("tiled".equals(geoService.getProtocol()) && "WMTS".equals(((TileService)geoService).getTilingProtocol())) {
            linkBuilder = WebMvcLinkBuilder.linkTo(GeoServiceProxyController.class, Map.of("appId", application.getId(), "appLayerId", appLayer.getId(), "protocol", "wmts"));
        } else {
            throw new IllegalArgumentException("Can't generate proxy URL for service " + geoService.getId());
        }
        return linkBuilder.toString();
    }
}

