/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.geotools.featuresources;

import java.io.IOException;
import java.util.HashMap;
import nl.b3p.tailormap.api.geotools.featuresources.FeatureSourceHelper;
import nl.tailormap.viewer.config.services.FeatureSource;
import nl.tailormap.viewer.config.services.JDBCFeatureSource;
import nl.tailormap.viewer.config.services.SimpleFeatureType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.sqlserver.SQLServerDataStoreFactory;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class JDBCFeatureSourceHelper
implements FeatureSourceHelper {
    private static final Log log = LogFactory.getLog(JDBCFeatureSourceHelper.class);

    public static SimpleFeatureSource openGeoToolsFSFeatureSource(JDBCFeatureSource fs, SimpleFeatureType sft) throws IOException {
        DataStore ds = JDBCFeatureSourceHelper.createDataStore((JDBCFeatureSource)fs);
        return ds.getFeatureSource(sft.getTypeName());
    }

    public static DataStore createDataStore(JDBCFeatureSource fs) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        JSONObject urlObj = new JSONObject(fs.getUrl());
        params.put("dbtype", urlObj.get("dbtype"));
        params.put("host", urlObj.get("host"));
        params.put("port", urlObj.get("port"));
        params.put("database", urlObj.get("database"));
        params.put("schema", fs.schema);
        params.put("user", fs.getUsername());
        params.put(JDBCDataStoreFactory.FETCHSIZE.key, 50);
        params.put("passwd", fs.getPassword());
        params.put(JDBCDataStoreFactory.EXPOSE_PK.key, true);
        params.put(JDBCDataStoreFactory.PK_METADATA_TABLE.key, "gt_pk_metadata");
        if (!urlObj.get("dbtype").equals("oracle")) {
            params.put(SQLServerDataStoreFactory.GEOMETRY_METADATA_TABLE.key, "geometry_columns");
        }
        HashMap<String, String> logParams = new HashMap<String, String>(params);
        if (fs.getPassword() != null) {
            logParams.put("passwd", String.valueOf(new char[fs.getPassword().length()]).replace("\u0000", "*"));
        }
        log.debug((Object)("Opening datastore using parameters: " + logParams));
        DataStore ds = DataStoreFinder.getDataStore(params);
        if (ds == null) {
            throw new IOException("Cannot open datastore using parameters " + logParams);
        }
        return ds;
    }

    public SimpleFeatureSource openGeoToolsFeatureSource(FeatureSource fs, SimpleFeatureType sft) throws IOException {
        return JDBCFeatureSourceHelper.openGeoToolsFSFeatureSource((JDBCFeatureSource)((JDBCFeatureSource)fs), (SimpleFeatureType)sft);
    }

    public SimpleFeatureSource openGeoToolsFeatureSource(FeatureSource fs, SimpleFeatureType sft, int timeout) throws IOException {
        return JDBCFeatureSourceHelper.openGeoToolsFSFeatureSource((JDBCFeatureSource)((JDBCFeatureSource)fs), (SimpleFeatureType)sft);
    }
}

