/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.geotools.processing;

import java.nio.charset.StandardCharsets;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.geojson.GeoJSONWriter;
import org.geotools.geometry.jts.JTS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.precision.GeometryPrecisionReducer;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

/*
 * Exception performing whole class analysis ignored.
 */
public final class GeometryProcessor {
    private static final Log LOG = LogFactory.getLog(GeometryProcessor.class);
    private static final Log logger = LogFactory.getLog(GeometryProcessor.class);

    private GeometryProcessor() {
    }

    @NotNull
    public static String processGeometry(Object geometry, @NotNull Boolean simplifyGeometry, MathTransform transform) {
        if (null == geometry) {
            return null;
        }
        if (Geometry.class.isAssignableFrom(geometry.getClass())) {
            if (null != transform) {
                try {
                    geometry = JTS.transform((Geometry)((Geometry)geometry), (MathTransform)transform);
                }
                catch (TransformException e) {
                    logger.error((Object)"Failed to transform geometry", (Throwable)e);
                }
            }
            if (simplifyGeometry.booleanValue()) {
                return GeometryProcessor.simplify((Geometry)((Geometry)geometry));
            }
            return GeometryProcessor.linearizeGeomToWKT((Geometry)((Geometry)geometry));
        }
        return geometry.toString();
    }

    private static String linearizeGeomToWKT(Geometry geometry) {
        WKTWriter writer = new WKTWriter(2);
        Object wkt = writer.write(geometry);
        if (((String)wkt).startsWith("LINEARRING")) {
            wkt = "LINESTRING" + ((String)wkt).substring("LINEARRING".length());
        }
        return wkt;
    }

    @NotNull
    private static String simplify(@NotNull Geometry geom) {
        double distanceTolerance;
        int megabytes = 1994752;
        LOG.debug((Object)("PrecisionModel scale: " + geom.getPrecisionModel().getScale()));
        PrecisionModel pm = new PrecisionModel(geom.getPrecisionModel());
        GeometryPrecisionReducer gpr = new GeometryPrecisionReducer(pm);
        geom = gpr.reduce(geom);
        Geometry bbox = geom.getEnvelope();
        String geomTxt = geom.toText();
        for (distanceTolerance = 1.0; (geomTxt.getBytes(StandardCharsets.UTF_8).length > 1994752 || geom.getCoordinates().length > 600) && distanceTolerance < 9999.0; distanceTolerance = 10.0 * distanceTolerance) {
            LOG.debug((Object)("Simplify selected feature geometry with distance of: " + distanceTolerance));
            geom = TopologyPreservingSimplifier.simplify((Geometry)geom, (double)distanceTolerance);
            geom = gpr.reduce(geom);
            geomTxt = geom.toText();
        }
        if (distanceTolerance > 9999.0) {
            LOG.debug((Object)"Maximum number of simplify cycles reached, returning bounding box instead.");
            return bbox.toText();
        }
        return GeometryProcessor.linearizeGeomToWKT((Geometry)geom);
    }

    public static String geometryToJson(Geometry geom) {
        return GeoJSONWriter.toGeoJSON((Geometry)geom);
    }
}

