/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import nl.b3p.tailormap.api.model.Bounds;

@Schema(name="CoordinateReferenceSystem", description=" Well-known and client-supported EPSG code. Currently Rijksdriehoek/WGS84, new/TODO Web Mercator. ")
public class CoordinateReferenceSystem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="code")
    private String code = "EPSG:28992";
    @JsonProperty(value="definition")
    private String definition = "+proj=sterea +lat_0=52.15616055555555 +lon_0=5.38763888888889 +k=0.9999079 +x_0=155000 +y_0=463000 +ellps=bessel +towgs84=565.417,50.3319,465.552,-0.398957,0.343988,-1.8774,4.0725 +units=m +no_defs";
    @JsonProperty(value="bounds")
    private Bounds bounds;

    public CoordinateReferenceSystem code(String code) {
        this.code = code;
        return this;
    }

    @NotNull
    @Schema(name="code", description="the EPSG code", required=true)
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public CoordinateReferenceSystem definition(String definition) {
        this.definition = definition;
        return this;
    }

    @NotNull
    @Schema(name="definition", description="PROJ4 string", required=true)
    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public CoordinateReferenceSystem bounds(Bounds bounds) {
        this.bounds = bounds;
        return this;
    }

    @Valid
    @Schema(name="bounds", required=false)
    public Bounds getBounds() {
        return this.bounds;
    }

    public void setBounds(Bounds bounds) {
        this.bounds = bounds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateReferenceSystem coordinateReferenceSystem = (CoordinateReferenceSystem)o;
        return Objects.equals(this.code, coordinateReferenceSystem.code) && Objects.equals(this.definition, coordinateReferenceSystem.definition) && Objects.equals(this.bounds, coordinateReferenceSystem.bounds);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.definition, this.bounds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CoordinateReferenceSystem {\n");
        sb.append("    code: ").append(this.toIndentedString((Object)this.code)).append("\n");
        sb.append("    definition: ").append(this.toIndentedString((Object)this.definition)).append("\n");
        sb.append("    bounds: ").append(this.toIndentedString((Object)this.bounds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

