/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.security;

import java.util.HashSet;
import java.util.Set;
import nl.b3p.tailormap.api.repository.LayerRepository;
import nl.b3p.tailormap.api.repository.LevelRepository;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.app.Level;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.config.services.Layer;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class AuthorizationService {
    private final LevelRepository levelRepository;
    private final LayerRepository layerRepository;

    public AuthorizationService(LevelRepository levelRepository, LayerRepository layerRepository) {
        this.levelRepository = levelRepository;
        this.layerRepository = layerRepository;
    }

    private boolean isAuthorizedBySet(Set<String> readers) {
        if (readers == null || readers.isEmpty()) {
            return true;
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null) {
            return false;
        }
        for (String reader : readers) {
            if (!auth.getAuthorities().stream().anyMatch(x -> x.getAuthority().equals(reader))) continue;
            return true;
        }
        return false;
    }

    public boolean mayUserRead(Application application) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if ((authentication == null || authentication instanceof AnonymousAuthenticationToken) && application.isAuthenticatedRequired()) {
            return false;
        }
        return this.isAuthorizedBySet(application.getReaders());
    }

    public boolean mayUserRead(ApplicationLayer applicationLayer, Application context) {
        if (!this.isAuthorizedBySet(applicationLayer.getReaders())) {
            return false;
        }
        if (!this.mayUserRead(context)) {
            return false;
        }
        HashSet<Long> levelIds = new HashSet<Long>();
        for (Object level : this.levelRepository.findByLevelTree(context.getRoot().getId())) {
            levelIds.add(level.getId());
        }
        Level closestLevel = null;
        for (Level level : this.levelRepository.findWithAuthorizationDataByIdIn(levelIds)) {
            if (!level.getLayers().contains(applicationLayer)) continue;
            closestLevel = level;
            break;
        }
        if (closestLevel == null) {
            return false;
        }
        if (!this.mayUserRead(closestLevel)) {
            return false;
        }
        GeoService geoService = applicationLayer.getService();
        if (geoService == null) {
            return true;
        }
        if (this.isProxiedSecuredServiceLayerInPublicApplication(context, applicationLayer)) {
            return false;
        }
        return this.mayUserRead(this.layerRepository.getByServiceAndName(geoService, applicationLayer.getLayerName()));
    }

    public boolean isProxiedSecuredServiceLayerInPublicApplication(Application application, ApplicationLayer applicationLayer) {
        GeoService geoService = applicationLayer.getService();
        if (geoService == null) {
            return false;
        }
        if (Boolean.parseBoolean(String.valueOf(geoService.getDetails().get("useProxy")))) {
            boolean isSecuredService = geoService.getUsername() != null && geoService.getPassword() != null;
            return isSecuredService && !application.isAuthenticatedRequired();
        }
        return false;
    }

    public boolean mayUserRead(Layer layer) {
        if (!this.isAuthorizedBySet(layer.getReaders())) {
            return false;
        }
        if (!this.mayUserRead(layer.getService())) {
            return false;
        }
        if (layer.getParent() != null) {
            return this.mayUserRead(layer.getParent());
        }
        return true;
    }

    public boolean mayUserRead(Level level) {
        if (!this.isAuthorizedBySet(level.getReaders())) {
            return false;
        }
        if (level.getParent() != null) {
            return this.mayUserRead(level.getParent());
        }
        return true;
    }

    public boolean mayUserRead(GeoService geoService) {
        return this.isAuthorizedBySet(geoService.getReaders());
    }
}

