/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.security;

import java.util.Arrays;
import java.util.UUID;
import nl.b3p.tailormap.api.repository.UserRepository;
import nl.tailormap.viewer.config.security.Group;
import nl.tailormap.viewer.config.security.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!test"})
public class StartupAdminAccountCreator {
    private final Log logger = LogFactory.getLog(this.getClass());
    final UserRepository userRepository;
    private final PasswordEncoder passwordEncoder = PasswordEncoderFactories.createDelegatingPasswordEncoder();

    public StartupAdminAccountCreator(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @EventListener
    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.logger.trace((Object)"Checking whether an Admin or UserAdmin account exists...");
        if (!this.userRepository.existsByGroupsNameIn(Arrays.asList("UserAdmin", "Admin"))) {
            String password = UUID.randomUUID().toString();
            User u = new User();
            u.setUsername("admin");
            u.setPassword(this.passwordEncoder.encode((CharSequence)password));
            Group g = new Group();
            g.setName("UserAdmin");
            u.getGroups().add(g);
            this.userRepository.saveAndFlush((Object)u);
            this.logger.info((Object)String.format("\n***\n*** Use this account for administrating users:\n***\n*** Username: \u001b[0;1madmin\u001b[0m\n*** Password: \u001b[0;1m%s\u001b[0m\n***", password));
        }
    }
}

