/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.security;

import nl.b3p.tailormap.api.repository.UserRepository;
import nl.b3p.tailormap.api.security.TailormapUserDetails;
import nl.tailormap.viewer.config.security.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class TailormapUserDetailsService
implements UserDetailsService {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final UserRepository userRepository;

    public TailormapUserDetailsService(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        User user = this.userRepository.findByUsername(username);
        if (user == null) {
            throw new UsernameNotFoundException("User " + username + " not found");
        }
        this.logger.trace((Object)("Found user: " + user.getUsername() + ", password " + user.getPassword()));
        return new TailormapUserDetails(user);
    }
}

