/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import nl.b3p.tailormap.api.viewer.model.AppLayer;

@Schema(name="AppLayer", description=" A map layer, but only enough information to draw the layer. For advanced functionality that required access to attributes the LayerDetails should be requested. ")
public class AppLayer
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="layerName")
    private String layerName;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="serviceId")
    private Long serviceId;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="visible")
    private Boolean visible;
    @JsonProperty(value="opacity")
    private Integer opacity;
    @JsonProperty(value="minScale")
    private Double minScale;
    @JsonProperty(value="maxScale")
    private Double maxScale;
    @JsonProperty(value="legendImageUrl")
    private String legendImageUrl;
    @JsonProperty(value="hiDpiMode")
    private HiDpiModeEnum hiDpiMode;
    @JsonProperty(value="hiDpiSubstituteLayer")
    private String hiDpiSubstituteLayer;
    @JsonProperty(value="hasAttributes")
    private Boolean hasAttributes;

    public AppLayer id(Long id) {
        this.id = id;
        return this;
    }

    @NotNull
    @Schema(name="id", requiredMode=Schema.RequiredMode.REQUIRED)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public AppLayer layerName(String layerName) {
        this.layerName = layerName;
        return this;
    }

    @NotNull
    @Schema(name="layerName", description="Layer name as known by the service.", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public AppLayer title(String title) {
        this.title = title;
        return this;
    }

    @NotNull
    @Schema(name="title", description="Layer title or display name.", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public AppLayer serviceId(Long serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    @NotNull
    @Schema(name="serviceId", description="A reference to a Service id.", requiredMode=Schema.RequiredMode.REQUIRED)
    public Long getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(Long serviceId) {
        this.serviceId = serviceId;
    }

    public AppLayer url(String url) {
        this.url = url;
        return this;
    }

    @Schema(name="url", description="URL for this specific layer. If empty use URL from the service.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public AppLayer visible(Boolean visible) {
        this.visible = visible;
        return this;
    }

    @NotNull
    @Schema(name="visible", requiredMode=Schema.RequiredMode.REQUIRED)
    public Boolean getVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public AppLayer opacity(Integer opacity) {
        this.opacity = opacity;
        return this;
    }

    @Schema(name="opacity", description="The opacity of the layer (in percentage, from 0-100, where 0 is \"transparent\" and 100 is \"opaque\").", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Integer getOpacity() {
        return this.opacity;
    }

    public void setOpacity(Integer opacity) {
        this.opacity = opacity;
    }

    public AppLayer minScale(Double minScale) {
        this.minScale = minScale;
        return this;
    }

    @Schema(name="minScale", description="Minimum scale at which this layer should be shown or is not blank. When absent there is no minimum. As reported by the service (ScaleHint or MinScaleDenominator).", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Double getMinScale() {
        return this.minScale;
    }

    public void setMinScale(Double minScale) {
        this.minScale = minScale;
    }

    public AppLayer maxScale(Double maxScale) {
        this.maxScale = maxScale;
        return this;
    }

    @Schema(name="maxScale", description="Maximum scale denominator at which this layer should be shown or is not blank. When absent there is no maximum. As reported by the service (ScaleHint or MaxScaleDenominator).", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Double getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(Double maxScale) {
        this.maxScale = maxScale;
    }

    public AppLayer legendImageUrl(String legendImageUrl) {
        this.legendImageUrl = legendImageUrl;
        return this;
    }

    @Schema(name="legendImageUrl", description="URL to an image with the layer legend.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getLegendImageUrl() {
        return this.legendImageUrl;
    }

    public void setLegendImageUrl(String legendImageUrl) {
        this.legendImageUrl = legendImageUrl;
    }

    public AppLayer hiDpiMode(HiDpiModeEnum hiDpiMode) {
        this.hiDpiMode = hiDpiMode;
        return this;
    }

    @Schema(name="hiDpiMode", description="For tiled services only", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public HiDpiModeEnum getHiDpiMode() {
        return this.hiDpiMode;
    }

    public void setHiDpiMode(HiDpiModeEnum hiDpiMode) {
        this.hiDpiMode = hiDpiMode;
    }

    public AppLayer hiDpiSubstituteLayer(String hiDpiSubstituteLayer) {
        this.hiDpiSubstituteLayer = hiDpiSubstituteLayer;
        return this;
    }

    @Schema(name="hiDpiSubstituteLayer", description="The layer name of this service to substitute when the device pixel ratio is higher", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getHiDpiSubstituteLayer() {
        return this.hiDpiSubstituteLayer;
    }

    public void setHiDpiSubstituteLayer(String hiDpiSubstituteLayer) {
        this.hiDpiSubstituteLayer = hiDpiSubstituteLayer;
    }

    public AppLayer hasAttributes(Boolean hasAttributes) {
        this.hasAttributes = hasAttributes;
        return this;
    }

    @Schema(name="hasAttributes", description="Whether this layer has attributes that can be accessed eg. for feature info or attribute list", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Boolean getHasAttributes() {
        return this.hasAttributes;
    }

    public void setHasAttributes(Boolean hasAttributes) {
        this.hasAttributes = hasAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppLayer appLayer = (AppLayer)o;
        return Objects.equals(this.id, appLayer.id) && Objects.equals(this.layerName, appLayer.layerName) && Objects.equals(this.title, appLayer.title) && Objects.equals(this.serviceId, appLayer.serviceId) && Objects.equals(this.url, appLayer.url) && Objects.equals(this.visible, appLayer.visible) && Objects.equals(this.opacity, appLayer.opacity) && Objects.equals(this.minScale, appLayer.minScale) && Objects.equals(this.maxScale, appLayer.maxScale) && Objects.equals(this.legendImageUrl, appLayer.legendImageUrl) && Objects.equals(this.hiDpiMode, appLayer.hiDpiMode) && Objects.equals(this.hiDpiSubstituteLayer, appLayer.hiDpiSubstituteLayer) && Objects.equals(this.hasAttributes, appLayer.hasAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.layerName, this.title, this.serviceId, this.url, this.visible, this.opacity, this.minScale, this.maxScale, this.legendImageUrl, this.hiDpiMode, this.hiDpiSubstituteLayer, this.hasAttributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppLayer {\n");
        sb.append("    id: ").append(this.toIndentedString((Object)this.id)).append("\n");
        sb.append("    layerName: ").append(this.toIndentedString((Object)this.layerName)).append("\n");
        sb.append("    title: ").append(this.toIndentedString((Object)this.title)).append("\n");
        sb.append("    serviceId: ").append(this.toIndentedString((Object)this.serviceId)).append("\n");
        sb.append("    url: ").append(this.toIndentedString((Object)this.url)).append("\n");
        sb.append("    visible: ").append(this.toIndentedString((Object)this.visible)).append("\n");
        sb.append("    opacity: ").append(this.toIndentedString((Object)this.opacity)).append("\n");
        sb.append("    minScale: ").append(this.toIndentedString((Object)this.minScale)).append("\n");
        sb.append("    maxScale: ").append(this.toIndentedString((Object)this.maxScale)).append("\n");
        sb.append("    legendImageUrl: ").append(this.toIndentedString((Object)this.legendImageUrl)).append("\n");
        sb.append("    hiDpiMode: ").append(this.toIndentedString((Object)this.hiDpiMode)).append("\n");
        sb.append("    hiDpiSubstituteLayer: ").append(this.toIndentedString((Object)this.hiDpiSubstituteLayer)).append("\n");
        sb.append("    hasAttributes: ").append(this.toIndentedString((Object)this.hasAttributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

