/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import nl.b3p.tailormap.api.viewer.model.AppLayer;
import nl.b3p.tailormap.api.viewer.model.Bounds;
import nl.b3p.tailormap.api.viewer.model.CoordinateReferenceSystem;
import nl.b3p.tailormap.api.viewer.model.LayerTreeNode;
import nl.b3p.tailormap.api.viewer.model.Service;

@Schema(name="MapResponse", description="Any information needed to draw a basic map on a page. May include base layers.")
public class MapResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="initialExtent")
    private Bounds initialExtent;
    @JsonProperty(value="maxExtent")
    private Bounds maxExtent;
    @JsonProperty(value="services")
    @Valid
    private Set<Service> services = new LinkedHashSet();
    @JsonProperty(value="baseLayerTreeNodes")
    @Valid
    private List<LayerTreeNode> baseLayerTreeNodes = new ArrayList();
    @JsonProperty(value="layerTreeNodes")
    @Valid
    private List<LayerTreeNode> layerTreeNodes = new ArrayList();
    @JsonProperty(value="appLayers")
    @Valid
    private List<AppLayer> appLayers = new ArrayList();
    @JsonProperty(value="crs")
    private CoordinateReferenceSystem crs;

    public MapResponse initialExtent(Bounds initialExtent) {
        this.initialExtent = initialExtent;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="initialExtent", requiredMode=Schema.RequiredMode.REQUIRED)
    public Bounds getInitialExtent() {
        return this.initialExtent;
    }

    public void setInitialExtent(Bounds initialExtent) {
        this.initialExtent = initialExtent;
    }

    public MapResponse maxExtent(Bounds maxExtent) {
        this.maxExtent = maxExtent;
        return this;
    }

    @Valid
    @Schema(name="maxExtent", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Bounds getMaxExtent() {
        return this.maxExtent;
    }

    public void setMaxExtent(Bounds maxExtent) {
        this.maxExtent = maxExtent;
    }

    public MapResponse services(Set<Service> services) {
        this.services = services;
        return this;
    }

    public MapResponse addServicesItem(Service servicesItem) {
        if (this.services == null) {
            this.services = new LinkedHashSet();
        }
        this.services.add(servicesItem);
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="services", requiredMode=Schema.RequiredMode.REQUIRED)
    public Set<Service> getServices() {
        return this.services;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setServices(Set<Service> services) {
        this.services = services;
    }

    public MapResponse baseLayerTreeNodes(List<LayerTreeNode> baseLayerTreeNodes) {
        this.baseLayerTreeNodes = baseLayerTreeNodes;
        return this;
    }

    public MapResponse addBaseLayerTreeNodesItem(LayerTreeNode baseLayerTreeNodesItem) {
        if (this.baseLayerTreeNodes == null) {
            this.baseLayerTreeNodes = new ArrayList();
        }
        this.baseLayerTreeNodes.add(baseLayerTreeNodesItem);
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="baseLayerTreeNodes", description="Unordered list of all tree nodes of base layers. Start with the node with root set to true and use the ordered children array property to order the tree. For base layers, only one child node (with all its' child layers) of the root should be displayed at one time.", requiredMode=Schema.RequiredMode.REQUIRED)
    public List<LayerTreeNode> getBaseLayerTreeNodes() {
        return this.baseLayerTreeNodes;
    }

    public void setBaseLayerTreeNodes(List<LayerTreeNode> baseLayerTreeNodes) {
        this.baseLayerTreeNodes = baseLayerTreeNodes;
    }

    public MapResponse layerTreeNodes(List<LayerTreeNode> layerTreeNodes) {
        this.layerTreeNodes = layerTreeNodes;
        return this;
    }

    public MapResponse addLayerTreeNodesItem(LayerTreeNode layerTreeNodesItem) {
        if (this.layerTreeNodes == null) {
            this.layerTreeNodes = new ArrayList();
        }
        this.layerTreeNodes.add(layerTreeNodesItem);
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="layerTreeNodes", description="Unordered list of all tree nodes of overlay/thematic/transparent layers. Start with the node with root set to true and use the ordered children array property to order the tree.", requiredMode=Schema.RequiredMode.REQUIRED)
    public List<LayerTreeNode> getLayerTreeNodes() {
        return this.layerTreeNodes;
    }

    public void setLayerTreeNodes(List<LayerTreeNode> layerTreeNodes) {
        this.layerTreeNodes = layerTreeNodes;
    }

    public MapResponse appLayers(List<AppLayer> appLayers) {
        this.appLayers = appLayers;
        return this;
    }

    public MapResponse addAppLayersItem(AppLayer appLayersItem) {
        if (this.appLayers == null) {
            this.appLayers = new ArrayList();
        }
        this.appLayers.add(appLayersItem);
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="appLayers", description="Unordered list of all AppLayers referenced from baseLayerTreeNodes and layerTreeNodes. Note that you need to lookup these by id, but OpenAPI only supports a map by using strings as keys, so an array is used instead.", requiredMode=Schema.RequiredMode.REQUIRED)
    public List<AppLayer> getAppLayers() {
        return this.appLayers;
    }

    public void setAppLayers(List<AppLayer> appLayers) {
        this.appLayers = appLayers;
    }

    public MapResponse crs(CoordinateReferenceSystem crs) {
        this.crs = crs;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="crs", requiredMode=Schema.RequiredMode.REQUIRED)
    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    public void setCrs(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapResponse mapResponse = (MapResponse)o;
        return Objects.equals(this.initialExtent, mapResponse.initialExtent) && Objects.equals(this.maxExtent, mapResponse.maxExtent) && Objects.equals(this.services, mapResponse.services) && Objects.equals(this.baseLayerTreeNodes, mapResponse.baseLayerTreeNodes) && Objects.equals(this.layerTreeNodes, mapResponse.layerTreeNodes) && Objects.equals(this.appLayers, mapResponse.appLayers) && Objects.equals(this.crs, mapResponse.crs);
    }

    public int hashCode() {
        return Objects.hash(this.initialExtent, this.maxExtent, this.services, this.baseLayerTreeNodes, this.layerTreeNodes, this.appLayers, this.crs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MapResponse {\n");
        sb.append("    initialExtent: ").append(this.toIndentedString((Object)this.initialExtent)).append("\n");
        sb.append("    maxExtent: ").append(this.toIndentedString((Object)this.maxExtent)).append("\n");
        sb.append("    services: ").append(this.toIndentedString((Object)this.services)).append("\n");
        sb.append("    baseLayerTreeNodes: ").append(this.toIndentedString((Object)this.baseLayerTreeNodes)).append("\n");
        sb.append("    layerTreeNodes: ").append(this.toIndentedString((Object)this.layerTreeNodes)).append("\n");
        sb.append("    appLayers: ").append(this.toIndentedString((Object)this.appLayers)).append("\n");
        sb.append("    crs: ").append(this.toIndentedString((Object)this.crs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

