/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api;

import java.util.Objects;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.dao.annotation.PersistenceExceptionTranslationPostProcessor;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableJpaRepositories(basePackages={"nl.b3p.tailormap.api.repository"})
@EntityScan(basePackages={"nl.tailormap.viewer.config", "nl.tailormap.viewer.config.app", "nl.tailormap.viewer.config.metadata", "nl.tailormap.viewer.config.security", "nl.tailormap.viewer.config.services"})
@EnableTransactionManagement
public class JPAConfiguration {
    private final Environment env;
    private final Log logger = LogFactory.getLog(this.getClass());

    public JPAConfiguration(Environment env) {
        this.env = env;
    }

    @Bean
    public LocalContainerEntityManagerFactoryBean entityManagerFactory() {
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setJpaVendorAdapter((JpaVendorAdapter)new HibernateJpaVendorAdapter());
        em.setJpaProperties(this.additionalProperties());
        em.setPersistenceUnitName("viewer-config-postgresql");
        em.setDataSource(this.dataSource());
        return em;
    }

    @Bean
    public DataSource dataSource() {
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setUrl(this.env.getProperty("spring.datasource.url"));
        dataSource.setDriverClassName(Objects.requireNonNull(this.env.getProperty("spring.datasource.driver-class-name")));
        dataSource.setUsername(this.env.getProperty("spring.datasource.username"));
        dataSource.setPassword(this.env.getProperty("spring.datasource.password"));
        this.logger.debug((Object)("using database: " + this.env.getProperty("spring.datasource.url") + " with driver: " + this.env.getProperty("spring.datasource.driver-class-name")));
        return dataSource;
    }

    @Bean
    JpaTransactionManager transactionManager(EntityManagerFactory entityManagerFactory) {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory(entityManagerFactory);
        return transactionManager;
    }

    @Bean
    public PersistenceExceptionTranslationPostProcessor exceptionTranslation() {
        return new PersistenceExceptionTranslationPostProcessor();
    }

    private Properties additionalProperties() {
        Properties hibernateProperties = new Properties();
        hibernateProperties.setProperty("hibernate.show_sql", this.env.getProperty("spring.jpa.show-sql", "false"));
        hibernateProperties.setProperty("hibernate.generate_statistics", this.env.getProperty("spring.jpa.properties.hibernate.enable_metrics", "true"));
        return hibernateProperties;
    }
}

