/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.controller;

import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import nl.b3p.tailormap.api.annotation.AppRestController;
import nl.b3p.tailormap.api.util.HttpProxyUtil;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.config.services.TileService;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

@AppRestController
@Validated
@RequestMapping(path={"/app/{appId}/layer/{appLayerId}/proxy/{protocol}"})
public class GeoServiceProxyController {
    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    public ResponseEntity<?> proxy(@ModelAttribute Application application, @ModelAttribute ApplicationLayer applicationLayer, @PathVariable(value="protocol") String protocol, HttpServletRequest request) {
        Predicate<GeoService> serviceValidator;
        if ("wmts".equals(protocol)) {
            serviceValidator = gs -> "tiled".equals(gs.getProtocol()) && "WMTS".equals(((TileService)gs).getTilingProtocol());
        } else if ("wms".equals(protocol)) {
            serviceValidator = gs -> "wms".equals(gs.getProtocol());
        } else {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)("Unknown proxy protocol: " + protocol));
        }
        GeoService service = applicationLayer.getService();
        if (!serviceValidator.test(service)) {
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)"Invalid proxy protocol for service");
        }
        if (!Boolean.parseBoolean(String.valueOf(service.getDetails().get("useProxy")))) {
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)"Proxy not enabled for requested service");
        }
        UriComponentsBuilder originalServiceUrl = UriComponentsBuilder.fromHttpUrl((String)service.getUrl());
        MultiValueMap requestParams = (MultiValueMap)request.getParameterMap().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry((String)entry.getKey(), Arrays.stream((String[])entry.getValue()).map(value -> UriUtils.encode((String)value, (Charset)StandardCharsets.UTF_8)).collect(Collectors.toList()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (x, y) -> y, LinkedMultiValueMap::new));
        MultiValueMap<String, String> params = GeoServiceProxyController.buildOgcProxyRequestParams((MultiValueMap<String, String>)originalServiceUrl.build(true).getQueryParams(), (MultiValueMap<String, String>)requestParams);
        originalServiceUrl.replaceQueryParams(params);
        return GeoServiceProxyController.doProxy(originalServiceUrl.build(true).toUri(), service, request);
    }

    public static MultiValueMap<String, String> buildOgcProxyRequestParams(MultiValueMap<String, String> originalServiceParams, MultiValueMap<String, String> requestParams) {
        LinkedMultiValueMap params = new LinkedMultiValueMap(requestParams);
        List<String> ogcParams = List.of(new String[]{"SERVICE", "REQUEST", "VERSION"});
        for (Map.Entry serviceParam : originalServiceParams.entrySet()) {
            if (params.containsKey(serviceParam.getKey()) || ogcParams.contains(((String)serviceParam.getKey()).toUpperCase())) continue;
            params.put((Object)((String)serviceParam.getKey()), (Object)((List)serviceParam.getValue()));
        }
        return params;
    }

    private static ResponseEntity<?> doProxy(URI uri, GeoService service, HttpServletRequest request) {
        HttpClient.Builder builder = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL);
        HttpClient httpClient = builder.build();
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(uri);
        HttpProxyUtil.addForwardedForRequestHeaders(requestBuilder, request);
        HttpProxyUtil.passthroughRequestHeaders(requestBuilder, request, Set.of("Accept", "If-Modified-Since", "If-Unmodified-Since", "If-Match", "If-None-Match", "If-Range", "Range", "Referer", "User-Agent"));
        HttpProxyUtil.setHttpBasicAuthenticationHeader(requestBuilder, service.getUsername(), service.getPassword());
        try {
            HttpResponse<InputStream> response = httpClient.send(requestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            InputStreamResource body = new InputStreamResource(response.body());
            HttpHeaders headers = HttpProxyUtil.passthroughResponseHeaders(response.headers(), Set.of("Content-Type", "Content-Length", "Content-Range", "Content-Disposition", "Cache-Control", "Expires", "Last-Modified", "ETag", "Pragma"));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)response.statusCode()).headers(headers)).body((Object)body);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_GATEWAY).body((Object)"Bad Gateway");
        }
    }
}

