/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.controller;

import io.micrometer.core.annotation.Timed;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import java.util.TreeSet;
import nl.b3p.tailormap.api.annotation.AppRestController;
import nl.b3p.tailormap.api.geotools.featuresources.FeatureSourceFactoryHelper;
import nl.b3p.tailormap.api.model.UniqueValuesResponse;
import nl.b3p.tailormap.api.repository.LayerRepository;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.config.services.SimpleFeatureType;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Not;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ResponseStatusException;

@AppRestController
@Validated
@RequestMapping(path={"/app/{appId}/layer/{appLayerId}/unique/{attributeName}"}, produces={"application/json"})
public class UniqueValuesController {
    @Value(value="${tailormap-api.unique.use_geotools_unique_function:true}")
    private boolean useGeotoolsUniqueFunction;
    private final FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
    private final Log logger = LogFactory.getLog(this.getClass());
    private final LayerRepository layerRepository;

    @Autowired
    public UniqueValuesController(LayerRepository layerRepository) {
        this.layerRepository = layerRepository;
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    @Timed(value="get_unique_attributes", description="time spent to process get unique attributes call")
    public ResponseEntity<Serializable> getUniqueAttributes(@ModelAttribute Application application, @ModelAttribute ApplicationLayer applicationLayer, @PathVariable(value="attributeName") String attributeName, @RequestParam(required=false) String filter) {
        if (StringUtils.isBlank((CharSequence)attributeName)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Attribute name is required");
        }
        UniqueValuesResponse uniqueValuesResponse = this.getUniqueValues(applicationLayer, attributeName, filter);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)uniqueValuesResponse);
    }

    private UniqueValuesResponse getUniqueValues(ApplicationLayer appLayer, String attributeName, String filter) {
        UniqueValuesResponse uniqueValuesResponse = new UniqueValuesResponse().filterApplied(false);
        Layer layer = this.layerRepository.getByServiceAndName(appLayer.getService(), appLayer.getLayerName());
        SimpleFeatureType sft = layer.getFeatureType();
        if (null == sft) {
            return uniqueValuesResponse;
        }
        try {
            Not notNull;
            Filter existingFilter = null;
            if (null != filter) {
                existingFilter = ECQL.toFilter((String)filter);
            }
            this.logger.trace((Object)("existingFilter: " + existingFilter));
            Not f = notNull = this.ff.not((Filter)this.ff.isNull((Expression)this.ff.property(attributeName)));
            if (null != existingFilter) {
                f = this.ff.and((Filter)notNull, existingFilter);
                uniqueValuesResponse.filterApplied(true);
            }
            Query q = new Query(sft.getTypeName(), (Filter)f);
            q.setPropertyNames(new String[]{attributeName});
            q.setSortBy(new SortBy[]{this.ff.sort(attributeName, SortOrder.ASCENDING)});
            this.logger.trace((Object)("Unique values query: " + q));
            SimpleFeatureSource fs = FeatureSourceFactoryHelper.openGeoToolsFeatureSource(sft);
            if (!this.useGeotoolsUniqueFunction) {
                this.logger.trace((Object)"Using feature visitor to get unique values");
                fs.getFeatures(q).accepts(feature -> uniqueValuesResponse.addValuesItem(feature.getProperty(attributeName).getValue()), null);
            } else {
                this.logger.trace((Object)"Using geotools unique collection function to get unique values");
                Function unique = this.ff.function("Collection_Unique", new Expression[]{this.ff.property(attributeName)});
                Object o = unique.evaluate((Object)fs.getFeatures(q));
                if (o instanceof Set) {
                    Set uniqueValues = (Set)o;
                    uniqueValuesResponse.setValues(new TreeSet<Object>(uniqueValues));
                }
            }
            fs.getDataStore().dispose();
        }
        catch (CQLException e) {
            this.logger.error((Object)"Could not parse requested filter.", (Throwable)e);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Could not parse requested filter.");
        }
        catch (IOException e) {
            this.logger.error((Object)"Could not retrieve attribute data.", (Throwable)e);
        }
        return uniqueValuesResponse;
    }
}

