/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.controller;

import java.util.Map;
import nl.b3p.tailormap.api.repository.MetadataRepository;
import nl.tailormap.viewer.config.metadata.Metadata;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
public class VersionController {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final MetadataRepository metadataRepository;
    @Value(value="${tailormap-api.version}")
    private String version;
    @Value(value="${tailormap-api.apiVersion}")
    private String apiVersion;
    @Value(value="${tailormap-api.commitSha}")
    private String commitSha;
    @Value(value="${tailormap-api.builddate}")
    private String buildDate;

    public VersionController(MetadataRepository metadataRepository) {
        this.metadataRepository = metadataRepository;
    }

    @GetMapping(path={"/version"}, produces={"application/json"})
    public Map<String, String> getVersion() {
        Metadata m = this.metadataRepository.findByConfigKey("database_version");
        String dbVersion = null != m ? (null == m.getConfigValue() ? "unknown" : m.getConfigValue()) : "unknown";
        this.logger.debug((Object)String.format("Version information:\n\tproduct version: %s\n\tdatabase version: %s\n\tAPI version: %s\n\tgit commit: %s\n\tbuild date: %s", this.version, dbVersion, this.apiVersion, this.commitSha, this.buildDate));
        return Map.of("version", this.version, "databaseversion", dbVersion, "apiVersion", this.apiVersion, "commitSha", this.commitSha, "buildDate", this.buildDate);
    }
}

