/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.geotools.referencing;

import nl.b3p.tailormap.api.model.Bounds;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.referencing.CRS;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class ReferencingHelper {
    private static final Log logger = LogFactory.getLog(ReferencingHelper.class);

    public static Bounds crsBoundsExtractor(String authorityCode) {
        try {
            CoordinateReferenceSystem crs = CRS.decode((String)authorityCode);
            Envelope envelope = CRS.getEnvelope((CoordinateReferenceSystem)crs);
            if (null != envelope) {
                return new Bounds().crs(authorityCode).maxx(envelope.getUpperCorner().getOrdinate(0)).maxy(envelope.getUpperCorner().getOrdinate(1)).minx(envelope.getLowerCorner().getOrdinate(0)).miny(envelope.getLowerCorner().getOrdinate(1));
            }
        }
        catch (FactoryException e) {
            logger.warn((Object)("Failed to decode CRS. " + e.getMessage()), (Throwable)e);
        }
        return new Bounds().crs(authorityCode);
    }
}

