/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.health;

import nl.b3p.tailormap.api.controller.VersionController;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnEnabledHealthIndicator(value="tailormap")
public class TailormapHealthIndicator
implements HealthIndicator {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final VersionController versionController;
    @Value(value="${management.health.tailormap.enabled}")
    private boolean healthEnabled = false;

    public TailormapHealthIndicator(VersionController versionController) {
        this.versionController = versionController;
    }

    public Health health() {
        Health.Builder health = Health.unknown();
        this.logger.info((Object)("tailormap health indicator " + (this.healthEnabled ? "enabled" : "disabled")));
        if (this.healthEnabled) {
            try {
                health.up().withDetails(this.versionController.getVersion());
            }
            catch (Exception e) {
                this.logger.fatal((Object)("Error checking Tailormap health. " + e.getMessage()));
                this.logger.debug((Object)"Error checking Tailormap health", (Throwable)e);
                health.outOfService().withDetail("message", (Object)"Error checking database");
            }
        }
        return health.build();
    }
}

