/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;
import javax.validation.constraints.NotNull;

@Schema(name="Bounds", description="Describes an extent within a Coordinate Reference System")
public class Bounds
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="miny")
    private Double miny;
    @JsonProperty(value="minx")
    private Double minx;
    @JsonProperty(value="maxy")
    private Double maxy;
    @JsonProperty(value="maxx")
    private Double maxx;
    @JsonProperty(value="crs")
    private String crs = null;

    public Bounds miny(Double miny) {
        this.miny = miny;
        return this;
    }

    @NotNull
    @Schema(name="miny", description="lower bottom", required=true)
    public Double getMiny() {
        return this.miny;
    }

    public void setMiny(Double miny) {
        this.miny = miny;
    }

    public Bounds minx(Double minx) {
        this.minx = minx;
        return this;
    }

    @NotNull
    @Schema(name="minx", description="lower left", required=true)
    public Double getMinx() {
        return this.minx;
    }

    public void setMinx(Double minx) {
        this.minx = minx;
    }

    public Bounds maxy(Double maxy) {
        this.maxy = maxy;
        return this;
    }

    @NotNull
    @Schema(name="maxy", description="upper top", required=true)
    public Double getMaxy() {
        return this.maxy;
    }

    public void setMaxy(Double maxy) {
        this.maxy = maxy;
    }

    public Bounds maxx(Double maxx) {
        this.maxx = maxx;
        return this;
    }

    @NotNull
    @Schema(name="maxx", description="upper right", required=true)
    public Double getMaxx() {
        return this.maxx;
    }

    public void setMaxx(Double maxx) {
        this.maxx = maxx;
    }

    public Bounds crs(String crs) {
        this.crs = crs;
        return this;
    }

    @Schema(name="crs", description="(EPSG) code of the projection", required=false)
    public String getCrs() {
        return this.crs;
    }

    public void setCrs(String crs) {
        this.crs = crs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bounds bounds = (Bounds)o;
        return Objects.equals(this.miny, bounds.miny) && Objects.equals(this.minx, bounds.minx) && Objects.equals(this.maxy, bounds.maxy) && Objects.equals(this.maxx, bounds.maxx) && Objects.equals(this.crs, bounds.crs);
    }

    public int hashCode() {
        return Objects.hash(this.miny, this.minx, this.maxy, this.maxx, this.crs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Bounds {\n");
        sb.append("    miny: ").append(this.toIndentedString(this.miny)).append("\n");
        sb.append("    minx: ").append(this.toIndentedString(this.minx)).append("\n");
        sb.append("    maxy: ").append(this.toIndentedString(this.maxy)).append("\n");
        sb.append("    maxx: ").append(this.toIndentedString(this.maxx)).append("\n");
        sb.append("    crs: ").append(this.toIndentedString(this.crs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

