/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import nl.b3p.tailormap.api.model.Attribute;
import nl.b3p.tailormap.api.model.LayerDetailsRelationsInner;

@Schema(name="LayerDetails", description="All details of an app layer.")
public class LayerDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="featureTypeName")
    private String featureTypeName;
    @JsonProperty(value="serviceId")
    private Long serviceId;
    @JsonProperty(value="geometryAttribute")
    private String geometryAttribute;
    @JsonProperty(value="geometryAttributeIndex")
    private Integer geometryAttributeIndex;
    @JsonProperty(value="geometryType")
    private GeometryTypeEnum geometryType;
    @JsonProperty(value="editable")
    private Boolean editable = false;
    @JsonProperty(value="metadata")
    private String metadata = null;
    @JsonProperty(value="relations")
    @Valid
    private List<LayerDetailsRelationsInner> relations = null;
    @JsonProperty(value="attributes")
    @Valid
    private List<Attribute> attributes = null;

    public LayerDetails id(Long id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", accessMode=Schema.AccessMode.READ_ONLY, required=true)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LayerDetails featureTypeName(String featureTypeName) {
        this.featureTypeName = featureTypeName;
        return this;
    }

    @Schema(name="featureTypeName", required=false)
    public String getFeatureTypeName() {
        return this.featureTypeName;
    }

    public void setFeatureTypeName(String featureTypeName) {
        this.featureTypeName = featureTypeName;
    }

    public LayerDetails serviceId(Long serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    @Schema(name="serviceId", accessMode=Schema.AccessMode.READ_ONLY, required=true)
    public Long getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(Long serviceId) {
        this.serviceId = serviceId;
    }

    public LayerDetails geometryAttribute(String geometryAttribute) {
        this.geometryAttribute = geometryAttribute;
        return this;
    }

    @Schema(name="geometryAttribute", required=false)
    public String getGeometryAttribute() {
        return this.geometryAttribute;
    }

    public void setGeometryAttribute(String geometryAttribute) {
        this.geometryAttribute = geometryAttribute;
    }

    public LayerDetails geometryAttributeIndex(Integer geometryAttributeIndex) {
        this.geometryAttributeIndex = geometryAttributeIndex;
        return this;
    }

    @Schema(name="geometryAttributeIndex", description="index of the geometryAttribute in the array of attributes.", required=false)
    public Integer getGeometryAttributeIndex() {
        return this.geometryAttributeIndex;
    }

    public void setGeometryAttributeIndex(Integer geometryAttributeIndex) {
        this.geometryAttributeIndex = geometryAttributeIndex;
    }

    public LayerDetails geometryType(GeometryTypeEnum geometryType) {
        this.geometryType = geometryType;
        return this;
    }

    @Schema(name="geometryType", description="(editable) geometry type of this layer. We can have multiple geometry attributes in a layer, but only one is rendered and optionally editable) see also see also: nl.tailormap.viewer.config.services.AttributeDescriptor", required=false)
    public GeometryTypeEnum getGeometryType() {
        return this.geometryType;
    }

    public void setGeometryType(GeometryTypeEnum geometryType) {
        this.geometryType = geometryType;
    }

    public LayerDetails editable(Boolean editable) {
        this.editable = editable;
        return this;
    }

    @Schema(name="editable", required=false)
    public Boolean getEditable() {
        return this.editable;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public LayerDetails metadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    @Schema(name="metadata", required=false)
    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public LayerDetails relations(List<LayerDetailsRelationsInner> relations) {
        this.relations = relations;
        return this;
    }

    public LayerDetails addRelationsItem(LayerDetailsRelationsInner relationsItem) {
        if (this.relations == null) {
            this.relations = new ArrayList<LayerDetailsRelationsInner>();
        }
        this.relations.add(relationsItem);
        return this;
    }

    @Valid
    @Schema(name="relations", required=false)
    public List<LayerDetailsRelationsInner> getRelations() {
        return this.relations;
    }

    public void setRelations(List<LayerDetailsRelationsInner> relations) {
        this.relations = relations;
    }

    public LayerDetails attributes(List<Attribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    public LayerDetails addAttributesItem(Attribute attributesItem) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<Attribute>();
        }
        this.attributes.add(attributesItem);
        return this;
    }

    @Valid
    @Schema(name="attributes", description=" Array with attributes. **note** that the ordering of this array is determined in the backend and does not need to coincide with the actual data in the data source. ", required=false)
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LayerDetails layerDetails = (LayerDetails)o;
        return Objects.equals(this.id, layerDetails.id) && Objects.equals(this.featureTypeName, layerDetails.featureTypeName) && Objects.equals(this.serviceId, layerDetails.serviceId) && Objects.equals(this.geometryAttribute, layerDetails.geometryAttribute) && Objects.equals(this.geometryAttributeIndex, layerDetails.geometryAttributeIndex) && Objects.equals((Object)this.geometryType, (Object)layerDetails.geometryType) && Objects.equals(this.editable, layerDetails.editable) && Objects.equals(this.metadata, layerDetails.metadata) && Objects.equals(this.relations, layerDetails.relations) && Objects.equals(this.attributes, layerDetails.attributes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.featureTypeName, this.serviceId, this.geometryAttribute, this.geometryAttributeIndex, this.geometryType, this.editable, this.metadata, this.relations, this.attributes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LayerDetails {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    featureTypeName: ").append(this.toIndentedString(this.featureTypeName)).append("\n");
        sb.append("    serviceId: ").append(this.toIndentedString(this.serviceId)).append("\n");
        sb.append("    geometryAttribute: ").append(this.toIndentedString(this.geometryAttribute)).append("\n");
        sb.append("    geometryAttributeIndex: ").append(this.toIndentedString(this.geometryAttributeIndex)).append("\n");
        sb.append("    geometryType: ").append(this.toIndentedString((Object)this.geometryType)).append("\n");
        sb.append("    editable: ").append(this.toIndentedString(this.editable)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    relations: ").append(this.toIndentedString(this.relations)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum GeometryTypeEnum {
        LINESTRING("linestring"),
        MULTILINESTRING("multilinestring"),
        POINT("point"),
        MULTIPOINT("multipoint"),
        POLYGON("polygon"),
        MULTIPOLYGON("multipolygon"),
        GEOMETRY("geometry");

        private String value;

        private GeometryTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GeometryTypeEnum fromValue(String value) {
            for (GeometryTypeEnum b : GeometryTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

