/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import nl.b3p.tailormap.api.persistence.json.AppLayerRef;
import nl.b3p.tailormap.api.persistence.json.BaseLayerInner;

@Schema(name="AppContent", description="Configuration for including content (layers) in an application.")
public class AppContent
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="baseLayers")
    @Valid
    private List<BaseLayerInner> baseLayers = null;
    @JsonProperty(value="layers")
    @Valid
    private List<AppLayerRef> layers = null;
    @JsonProperty(value="children")
    @Valid
    private List<AppContent> children = null;

    public AppContent baseLayers(List<BaseLayerInner> baseLayers) {
        this.baseLayers = baseLayers;
        return this;
    }

    public AppContent addBaseLayersItem(BaseLayerInner baseLayersItem) {
        if (this.baseLayers == null) {
            this.baseLayers = new ArrayList<BaseLayerInner>();
        }
        this.baseLayers.add(baseLayersItem);
        return this;
    }

    @Valid
    @Schema(name="baseLayers", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<BaseLayerInner> getBaseLayers() {
        return this.baseLayers;
    }

    public void setBaseLayers(List<BaseLayerInner> baseLayers) {
        this.baseLayers = baseLayers;
    }

    public AppContent layers(List<AppLayerRef> layers) {
        this.layers = layers;
        return this;
    }

    public AppContent addLayersItem(AppLayerRef layersItem) {
        if (this.layers == null) {
            this.layers = new ArrayList<AppLayerRef>();
        }
        this.layers.add(layersItem);
        return this;
    }

    @Valid
    @Schema(name="layers", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<AppLayerRef> getLayers() {
        return this.layers;
    }

    public void setLayers(List<AppLayerRef> layers) {
        this.layers = layers;
    }

    public AppContent children(List<AppContent> children) {
        this.children = children;
        return this;
    }

    public AppContent addChildrenItem(AppContent childrenItem) {
        if (this.children == null) {
            this.children = new ArrayList<AppContent>();
        }
        this.children.add(childrenItem);
        return this;
    }

    @Valid
    @Schema(name="children", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<AppContent> getChildren() {
        return this.children;
    }

    public void setChildren(List<AppContent> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppContent appContent = (AppContent)o;
        return Objects.equals(this.baseLayers, appContent.baseLayers) && Objects.equals(this.layers, appContent.layers) && Objects.equals(this.children, appContent.children);
    }

    public int hashCode() {
        return Objects.hash(this.baseLayers, this.layers, this.children);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppContent {\n");
        sb.append("    baseLayers: ").append(this.toIndentedString(this.baseLayers)).append("\n");
        sb.append("    layers: ").append(this.toIndentedString(this.layers)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

