/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;

public class ServiceInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="keywords")
    @Valid
    private Set<String> keywords = null;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="publisher")
    private URI publisher;
    @JsonProperty(value="schema")
    private URI schema;
    @JsonProperty(value="source")
    private URI source;

    public ServiceInfo title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ServiceInfo keywords(Set<String> keywords) {
        this.keywords = keywords;
        return this;
    }

    public ServiceInfo addKeywordsItem(String keywordsItem) {
        if (this.keywords == null) {
            this.keywords = new LinkedHashSet<String>();
        }
        this.keywords.add(keywordsItem);
        return this;
    }

    @Schema(name="keywords", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Set<String> getKeywords() {
        return this.keywords;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setKeywords(Set<String> keywords) {
        this.keywords = keywords;
    }

    public ServiceInfo description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ServiceInfo publisher(URI publisher) {
        this.publisher = publisher;
        return this;
    }

    @Valid
    @Schema(name="publisher", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public URI getPublisher() {
        return this.publisher;
    }

    public void setPublisher(URI publisher) {
        this.publisher = publisher;
    }

    public ServiceInfo schema(URI schema) {
        this.schema = schema;
        return this;
    }

    @Valid
    @Schema(name="schema", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public URI getSchema() {
        return this.schema;
    }

    public void setSchema(URI schema) {
        this.schema = schema;
    }

    public ServiceInfo source(URI source) {
        this.source = source;
        return this;
    }

    @Valid
    @Schema(name="source", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public URI getSource() {
        return this.source;
    }

    public void setSource(URI source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceInfo serviceInfo = (ServiceInfo)o;
        return Objects.equals(this.title, serviceInfo.title) && Objects.equals(this.keywords, serviceInfo.keywords) && Objects.equals(this.description, serviceInfo.description) && Objects.equals(this.publisher, serviceInfo.publisher) && Objects.equals(this.schema, serviceInfo.schema) && Objects.equals(this.source, serviceInfo.source);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.keywords, this.description, this.publisher, this.schema, this.source);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceInfo {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    keywords: ").append(this.toIndentedString(this.keywords)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    publisher: ").append(this.toIndentedString(this.publisher)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

