/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import nl.b3p.tailormap.api.viewer.model.AppStyling;
import nl.b3p.tailormap.api.viewer.model.Component;

@Schema(name="AppResponse", description="Answers API version and (default|requested) application id.")
public class AppResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="apiVersion")
    private String apiVersion = "v1";
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="version")
    private String version = null;
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="lang")
    private LangEnum lang = LangEnum.NL_NL;
    @JsonProperty(value="styling")
    private AppStyling styling;
    @JsonProperty(value="components")
    @Valid
    private List<Component> components = null;

    public AppResponse id(Long id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", example="7", description="application id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public AppResponse apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Schema(name="apiVersion", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public AppResponse name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AppResponse version(String version) {
        this.version = version;
        return this;
    }

    @Schema(name="version", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public AppResponse title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public AppResponse lang(LangEnum lang) {
        this.lang = lang;
        return this;
    }

    @Schema(name="lang", description="language code", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public LangEnum getLang() {
        return this.lang;
    }

    public void setLang(LangEnum lang) {
        this.lang = lang;
    }

    public AppResponse styling(AppStyling styling) {
        this.styling = styling;
        return this;
    }

    @Valid
    @Schema(name="styling", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public AppStyling getStyling() {
        return this.styling;
    }

    public void setStyling(AppStyling styling) {
        this.styling = styling;
    }

    public AppResponse components(List<Component> components) {
        this.components = components;
        return this;
    }

    public AppResponse addComponentsItem(Component componentsItem) {
        if (this.components == null) {
            this.components = new ArrayList<Component>();
        }
        this.components.add(componentsItem);
        return this;
    }

    @Valid
    @Schema(name="components", description=" Provides the collection of configured components (controls) for the application. Note that default/built-in components do not have to be retrieved. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<Component> getComponents() {
        return this.components;
    }

    public void setComponents(List<Component> components) {
        this.components = components;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppResponse appResponse = (AppResponse)o;
        return Objects.equals(this.id, appResponse.id) && Objects.equals(this.apiVersion, appResponse.apiVersion) && Objects.equals(this.name, appResponse.name) && Objects.equals(this.version, appResponse.version) && Objects.equals(this.title, appResponse.title) && Objects.equals((Object)this.lang, (Object)appResponse.lang) && Objects.equals(this.styling, appResponse.styling) && Objects.equals(this.components, appResponse.components);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.apiVersion, this.name, this.version, this.title, this.lang, this.styling, this.components});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    lang: ").append(this.toIndentedString((Object)this.lang)).append("\n");
        sb.append("    styling: ").append(this.toIndentedString(this.styling)).append("\n");
        sb.append("    components: ").append(this.toIndentedString(this.components)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum LangEnum {
        NL_NL("nl_NL"),
        EN_US("en_US");

        private String value;

        private LangEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LangEnum fromValue(String value) {
            for (LangEnum b : LangEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

