/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class Attribute
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="featureType")
    private Long featureType;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="alias")
    private String alias;
    @JsonProperty(value="longname")
    private String longname;
    @JsonProperty(value="editAlias")
    private String editAlias;
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonProperty(value="visible")
    private Boolean visible;
    @JsonProperty(value="selectable")
    private Boolean selectable;
    @JsonProperty(value="filterable")
    private Boolean filterable;
    @JsonProperty(value="folder_label")
    private String folderLabel;
    @JsonProperty(value="editable")
    private Boolean editable;
    @JsonProperty(value="defaultValue")
    private String defaultValue;
    @JsonProperty(value="disallowNullValue")
    private Boolean disallowNullValue;
    @JsonProperty(value="disableUserEdit")
    private Boolean disableUserEdit;
    @JsonProperty(value="allowValueListOnly")
    private Boolean allowValueListOnly;
    @JsonProperty(value="automaticValue")
    private Boolean automaticValue;
    @JsonProperty(value="valueList")
    private String valueList;
    @JsonProperty(value="editValues")
    @Valid
    private List<String> editValues = null;

    public Attribute id(Long id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", accessMode=Schema.AccessMode.READ_ONLY, requiredMode=Schema.RequiredMode.REQUIRED)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Attribute featureType(Long featureType) {
        this.featureType = featureType;
        return this;
    }

    @Schema(name="featureType", accessMode=Schema.AccessMode.READ_ONLY, requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Long getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(Long featureType) {
        this.featureType = featureType;
    }

    public Attribute name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(name="name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Attribute alias(String alias) {
        this.alias = alias;
        return this;
    }

    @Schema(name="alias", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Attribute longname(String longname) {
        this.longname = longname;
        return this;
    }

    @Schema(name="longname", example="v_factsheet_terrein_info.b_minhuur", description="has featuretype name and name combined with a dot.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getLongname() {
        return this.longname;
    }

    public void setLongname(String longname) {
        this.longname = longname;
    }

    public Attribute editAlias(String editAlias) {
        this.editAlias = editAlias;
        return this;
    }

    @Schema(name="editAlias", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getEditAlias() {
        return this.editAlias;
    }

    public void setEditAlias(String editAlias) {
        this.editAlias = editAlias;
    }

    public Attribute type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(name="type", description="data type. eg \"date\" or \"string\". see also: nl.tailormap.viewer.config.services.AttributeDescriptor", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Attribute visible(Boolean visible) {
        this.visible = visible;
        return this;
    }

    @Schema(name="visible", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Boolean getVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public Attribute selectable(Boolean selectable) {
        this.selectable = selectable;
        return this;
    }

    @Schema(name="selectable", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Boolean getSelectable() {
        return this.selectable;
    }

    public void setSelectable(Boolean selectable) {
        this.selectable = selectable;
    }

    public Attribute filterable(Boolean filterable) {
        this.filterable = filterable;
        return this;
    }

    @Schema(name="filterable", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Boolean getFilterable() {
        return this.filterable;
    }

    public void setFilterable(Boolean filterable) {
        this.filterable = filterable;
    }

    public Attribute folderLabel(String folderLabel) {
        this.folderLabel = folderLabel;
        return this;
    }

    @Schema(name="folder_label", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getFolderLabel() {
        return this.folderLabel;
    }

    public void setFolderLabel(String folderLabel) {
        this.folderLabel = folderLabel;
    }

    public Attribute editable(Boolean editable) {
        this.editable = editable;
        return this;
    }

    @Schema(name="editable", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Boolean getEditable() {
        return this.editable;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public Attribute defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Schema(name="defaultValue", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Attribute disallowNullValue(Boolean disallowNullValue) {
        this.disallowNullValue = disallowNullValue;
        return this;
    }

    @Schema(name="disallowNullValue", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Boolean getDisallowNullValue() {
        return this.disallowNullValue;
    }

    public void setDisallowNullValue(Boolean disallowNullValue) {
        this.disallowNullValue = disallowNullValue;
    }

    public Attribute disableUserEdit(Boolean disableUserEdit) {
        this.disableUserEdit = disableUserEdit;
        return this;
    }

    @Schema(name="disableUserEdit", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Boolean getDisableUserEdit() {
        return this.disableUserEdit;
    }

    public void setDisableUserEdit(Boolean disableUserEdit) {
        this.disableUserEdit = disableUserEdit;
    }

    public Attribute allowValueListOnly(Boolean allowValueListOnly) {
        this.allowValueListOnly = allowValueListOnly;
        return this;
    }

    @Schema(name="allowValueListOnly", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Boolean getAllowValueListOnly() {
        return this.allowValueListOnly;
    }

    public void setAllowValueListOnly(Boolean allowValueListOnly) {
        this.allowValueListOnly = allowValueListOnly;
    }

    public Attribute automaticValue(Boolean automaticValue) {
        this.automaticValue = automaticValue;
        return this;
    }

    @Schema(name="automaticValue", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Boolean getAutomaticValue() {
        return this.automaticValue;
    }

    public void setAutomaticValue(Boolean automaticValue) {
        this.automaticValue = automaticValue;
    }

    public Attribute valueList(String valueList) {
        this.valueList = valueList;
        return this;
    }

    @Schema(name="valueList", example="static", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getValueList() {
        return this.valueList;
    }

    public void setValueList(String valueList) {
        this.valueList = valueList;
    }

    public Attribute editValues(List<String> editValues) {
        this.editValues = editValues;
        return this;
    }

    public Attribute addEditValuesItem(String editValuesItem) {
        if (this.editValues == null) {
            this.editValues = new ArrayList<String>();
        }
        this.editValues.add(editValuesItem);
        return this;
    }

    @Schema(name="editValues", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<String> getEditValues() {
        return this.editValues;
    }

    public void setEditValues(List<String> editValues) {
        this.editValues = editValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return Objects.equals(this.id, attribute.id) && Objects.equals(this.featureType, attribute.featureType) && Objects.equals(this.name, attribute.name) && Objects.equals(this.alias, attribute.alias) && Objects.equals(this.longname, attribute.longname) && Objects.equals(this.editAlias, attribute.editAlias) && Objects.equals((Object)this.type, (Object)attribute.type) && Objects.equals(this.visible, attribute.visible) && Objects.equals(this.selectable, attribute.selectable) && Objects.equals(this.filterable, attribute.filterable) && Objects.equals(this.folderLabel, attribute.folderLabel) && Objects.equals(this.editable, attribute.editable) && Objects.equals(this.defaultValue, attribute.defaultValue) && Objects.equals(this.disallowNullValue, attribute.disallowNullValue) && Objects.equals(this.disableUserEdit, attribute.disableUserEdit) && Objects.equals(this.allowValueListOnly, attribute.allowValueListOnly) && Objects.equals(this.automaticValue, attribute.automaticValue) && Objects.equals(this.valueList, attribute.valueList) && Objects.equals(this.editValues, attribute.editValues);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.featureType, this.name, this.alias, this.longname, this.editAlias, this.type, this.visible, this.selectable, this.filterable, this.folderLabel, this.editable, this.defaultValue, this.disallowNullValue, this.disableUserEdit, this.allowValueListOnly, this.automaticValue, this.valueList, this.editValues});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Attribute {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    featureType: ").append(this.toIndentedString(this.featureType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("    longname: ").append(this.toIndentedString(this.longname)).append("\n");
        sb.append("    editAlias: ").append(this.toIndentedString(this.editAlias)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    visible: ").append(this.toIndentedString(this.visible)).append("\n");
        sb.append("    selectable: ").append(this.toIndentedString(this.selectable)).append("\n");
        sb.append("    filterable: ").append(this.toIndentedString(this.filterable)).append("\n");
        sb.append("    folderLabel: ").append(this.toIndentedString(this.folderLabel)).append("\n");
        sb.append("    editable: ").append(this.toIndentedString(this.editable)).append("\n");
        sb.append("    defaultValue: ").append(this.toIndentedString(this.defaultValue)).append("\n");
        sb.append("    disallowNullValue: ").append(this.toIndentedString(this.disallowNullValue)).append("\n");
        sb.append("    disableUserEdit: ").append(this.toIndentedString(this.disableUserEdit)).append("\n");
        sb.append("    allowValueListOnly: ").append(this.toIndentedString(this.allowValueListOnly)).append("\n");
        sb.append("    automaticValue: ").append(this.toIndentedString(this.automaticValue)).append("\n");
        sb.append("    valueList: ").append(this.toIndentedString(this.valueList)).append("\n");
        sb.append("    editValues: ").append(this.toIndentedString(this.editValues)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        DATE("date"),
        TIMESTAMP("timestamp"),
        STRING("string"),
        DOUBLE("double"),
        INTEGER("integer"),
        BOOLEAN("boolean"),
        LINESTRING("linestring"),
        MULTILINESTRING("multilinestring"),
        POINT("point"),
        MULTIPOINT("multipoint"),
        POLYGON("polygon"),
        MULTIPOLYGON("multipolygon"),
        GEOMETRY("geometry");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

