/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@Schema(name="ColumnMetadata", description="presentation metadata for a feature")
public class ColumnMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="alias")
    private String alias = null;
    @JsonProperty(value="type")
    private TypeEnum type;

    public ColumnMetadata key(String key) {
        this.key = key;
        return this;
    }

    @Schema(name="key", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ColumnMetadata alias(String alias) {
        this.alias = alias;
        return this;
    }

    @Schema(name="alias", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public ColumnMetadata type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(name="type", description="data type. eg \"date\" or \"string\". see also: nl.tailormap.viewer.config.services.AttributeDescriptor", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnMetadata columnMetadata = (ColumnMetadata)o;
        return Objects.equals(this.key, columnMetadata.key) && Objects.equals(this.alias, columnMetadata.alias) && Objects.equals((Object)this.type, (Object)columnMetadata.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.alias, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ColumnMetadata {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        DATE("date"),
        TIMESTAMP("timestamp"),
        STRING("string"),
        DOUBLE("double"),
        INTEGER("integer"),
        BOOLEAN("boolean"),
        GEOMETRY("geometry");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

