/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.controller;

import io.micrometer.core.annotation.Timed;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.http.HttpResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import nl.b3p.tailormap.api.annotation.AppRestController;
import nl.b3p.tailormap.api.controller.LayerExportController;
import nl.b3p.tailormap.api.geotools.wfs.SimpleWFSHelper;
import nl.b3p.tailormap.api.geotools.wfs.SimpleWFSLayerDescription;
import nl.b3p.tailormap.api.geotools.wfs.WFSProxy;
import nl.b3p.tailormap.api.persistence.GeoService;
import nl.b3p.tailormap.api.persistence.TMFeatureSource;
import nl.b3p.tailormap.api.persistence.TMFeatureType;
import nl.b3p.tailormap.api.persistence.json.GeoServiceLayer;
import nl.b3p.tailormap.api.persistence.json.GeoServiceProtocol;
import nl.b3p.tailormap.api.persistence.json.ServiceAuthentication;
import nl.b3p.tailormap.api.repository.FeatureSourceRepository;
import nl.b3p.tailormap.api.util.HttpProxyUtil;
import nl.b3p.tailormap.api.viewer.model.LayerExportCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ResponseStatusException;

@AppRestController
@RequestMapping(path={"${tailormap-api.base-path}/{viewerKind}/{viewerName}/layer/{appLayerId}/export/"})
public class LayerExportController {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final FeatureSourceRepository featureSourceRepository;

    public LayerExportController(FeatureSourceRepository featureSourceRepository) {
        this.featureSourceRepository = featureSourceRepository;
    }

    @Transactional
    @GetMapping(path={"capabilities"})
    @Timed(value="export_get_capabilities")
    public ResponseEntity<Serializable> capabilities(@ModelAttribute GeoService service, @ModelAttribute GeoServiceLayer layer) throws Exception {
        LayerExportCapabilities capabilities = new LayerExportCapabilities();
        TMFeatureType tmft = service.findFeatureTypeForLayer(layer, this.featureSourceRepository);
        WFSSearchResult wfsSearchResult = this.findWFSFeatureType(service, layer, tmft);
        if (!wfsSearchResult.found()) {
            capabilities.setOutputFormats(null);
        } else {
            try {
                List outputFormats = SimpleWFSHelper.getOutputFormats((String)wfsSearchResult.getWfsUrl(), (String)wfsSearchResult.getTypeName(), (String)wfsSearchResult.getUsername(), (String)wfsSearchResult.getPassword());
                capabilities.setOutputFormats(outputFormats);
            }
            catch (Exception e) {
                String msg = String.format("Error getting capabilities for WFS \"%s\"", wfsSearchResult.getWfsUrl());
                if (logger.isTraceEnabled()) {
                    logger.trace(msg, (Throwable)e);
                } else {
                    logger.warn("{}: {}: {}", new Object[]{msg, e.getClass(), e.getMessage()});
                }
                capabilities.setOutputFormats(null);
            }
        }
        capabilities.setExportable(Boolean.valueOf(capabilities.getOutputFormats() != null && !capabilities.getOutputFormats().isEmpty()));
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)capabilities);
    }

    @Transactional
    @RequestMapping(path={"download"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseEntity<?> download(@ModelAttribute GeoService service, @ModelAttribute GeoServiceLayer layer, @RequestParam String outputFormat, @RequestParam(required=false) List<String> attributes, @RequestParam(required=false) String filter, @RequestParam(required=false) String sortBy, @RequestParam(required=false) String sortOrder, @RequestParam(required=false) String crs, HttpServletRequest request) throws Exception {
        TMFeatureType tmft = service.findFeatureTypeForLayer(layer, this.featureSourceRepository);
        WFSSearchResult wfsSearchResult = this.findWFSFeatureType(service, layer, tmft);
        if (!wfsSearchResult.found()) {
            throw new ResponseStatusException(HttpStatus.SERVICE_UNAVAILABLE, "No suitable WFS available for layer export");
        }
        return this.downloadFromWFS(wfsSearchResult, outputFormat, attributes, filter, sortBy, sortOrder, crs, request);
    }

    private ResponseEntity<?> downloadFromWFS(WFSSearchResult wfsSearchResult, String outputFormat, List<String> attributes, String filter, String sortBy, String sortOrder, String crs, HttpServletRequest request) {
        LinkedMultiValueMap getFeatureParameters = new LinkedMultiValueMap();
        getFeatureParameters.add((Object)"typeNames", (Object)wfsSearchResult.getTypeName());
        getFeatureParameters.add((Object)"outputFormat", (Object)outputFormat);
        if (filter != null) {
            getFeatureParameters.add((Object)"cql_filter", (Object)filter);
        }
        if (crs != null) {
            getFeatureParameters.add((Object)"srsName", (Object)crs);
        }
        if (attributes != null && !attributes.isEmpty() && wfsSearchResult.getGeometryAttribute() != null) {
            attributes.add(wfsSearchResult.getGeometryAttribute());
            getFeatureParameters.add((Object)"propertyName", (Object)String.join((CharSequence)",", attributes));
        }
        if (sortBy != null) {
            getFeatureParameters.add((Object)"sortBy", (Object)(sortBy + ("asc".equals(sortOrder) ? " A" : " D")));
        }
        URI wfsGetFeature = SimpleWFSHelper.getWFSRequestURL((String)wfsSearchResult.getWfsUrl(), (String)"GetFeature", (MultiValueMap)getFeatureParameters);
        logger.info("Layer download {}, proxying WFS GetFeature request {}", null, (Object)wfsGetFeature);
        try {
            HttpResponse response = WFSProxy.proxyWfsRequest((URI)wfsGetFeature, (String)wfsSearchResult.getUsername(), (String)wfsSearchResult.getPassword(), (HttpServletRequest)request);
            logger.info("Layer download response code: {}, content type: {}, disposition: {}", new Object[]{response.statusCode(), response.headers().firstValue("Content-Type").map(Object::toString).orElse("<none>"), response.headers().firstValue("Content-Disposition").map(Object::toString).orElse("<none>")});
            InputStreamResource body = new InputStreamResource((InputStream)response.body());
            HttpHeaders headers = HttpProxyUtil.passthroughResponseHeaders((java.net.http.HttpHeaders)response.headers(), Set.of("Content-Type", "Content-Disposition"));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)response.statusCode()).headers(headers)).body((Object)body);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_GATEWAY).body((Object)"Bad Gateway");
        }
    }

    private WFSSearchResult findWFSFeatureType(GeoService service, GeoServiceLayer layer, TMFeatureType tmft) throws Exception {
        TMFeatureSource featureSource;
        String wfsUrl = null;
        String typeName = null;
        String username = null;
        String password = null;
        String geometryAttribute = null;
        ServiceAuthentication auth = null;
        if (tmft != null && (featureSource = tmft.getFeatureSource()).getProtocol() == TMFeatureSource.Protocol.WFS) {
            wfsUrl = featureSource.getUrl();
            typeName = tmft.getName();
            auth = featureSource.getAuthentication();
            geometryAttribute = tmft.getDefaultGeometryAttribute();
        }
        if ((wfsUrl == null || typeName == null) && service.getProtocol() == GeoServiceProtocol.WMS) {
            auth = service.getAuthentication();
            SimpleWFSLayerDescription wfsLayerDescription = this.getWFSLayerDescriptionForWMS(service, layer.getName());
            if (wfsLayerDescription != null) {
                wfsUrl = wfsLayerDescription.getWfsUrl();
                typeName = wfsLayerDescription.getFirstTypeName();
                auth = service.getAuthentication();
            }
        }
        if (auth != null && auth.getMethod() == ServiceAuthentication.MethodEnum.PASSWORD) {
            username = auth.getUsername();
            password = auth.getPassword();
        }
        return new WFSSearchResult(wfsUrl, typeName, geometryAttribute, username, password);
    }

    private SimpleWFSLayerDescription getWFSLayerDescriptionForWMS(GeoService wmsService, String layerName) throws Exception {
        SimpleWFSLayerDescription wfsLayerDescription;
        String username = null;
        String password = null;
        if (wmsService.getAuthentication() != null && wmsService.getAuthentication().getMethod() == ServiceAuthentication.MethodEnum.PASSWORD) {
            username = wmsService.getAuthentication().getUsername();
            password = wmsService.getAuthentication().getPassword();
        }
        if ((wfsLayerDescription = SimpleWFSHelper.describeWMSLayer((String)wmsService.getUrl(), username, password, (String)layerName)) != null && wfsLayerDescription.getTypeNames().length > 0) {
            logger.info("WMS described layer \"{}\" with typeNames \"{}\" of WFS \"{}\" for WMS \"{}\"", new Object[]{layerName, Arrays.toString(wfsLayerDescription.getTypeNames()), wfsLayerDescription.getWfsUrl(), wmsService.getUrl()});
            return wfsLayerDescription;
        }
        return null;
    }
}

