/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.geotools;

import javax.validation.constraints.NotNull;
import nl.b3p.tailormap.api.persistence.Application;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class TransformationUtil {
    private TransformationUtil() {
    }

    public static MathTransform getTransformationToApplication(@NotNull Application application, @NotNull SimpleFeatureSource simpleFeatureSource) throws FactoryException {
        CoordinateReferenceSystem appCRS;
        MathTransform transform = null;
        CoordinateReferenceSystem dataSourceCRS = ((SimpleFeatureType)simpleFeatureSource.getSchema()).getCoordinateReferenceSystem();
        if (!CRS.equalsIgnoreMetadata((Object)dataSourceCRS, (Object)(appCRS = CRS.decode((String)application.getCrs())))) {
            transform = CRS.findMathTransform((CoordinateReferenceSystem)dataSourceCRS, (CoordinateReferenceSystem)appCRS);
        }
        return transform;
    }

    public static MathTransform getTransformationToDataSource(@NotNull Application application, @NotNull SimpleFeatureSource simpleFeatureSource) throws FactoryException {
        CoordinateReferenceSystem appCRS;
        MathTransform transform = null;
        CoordinateReferenceSystem dataSourceCRS = ((SimpleFeatureType)simpleFeatureSource.getSchema()).getCoordinateReferenceSystem();
        if (!CRS.equalsIgnoreMetadata((Object)dataSourceCRS, (Object)(appCRS = CRS.decode((String)application.getCrs())))) {
            transform = CRS.findMathTransform((CoordinateReferenceSystem)appCRS, (CoordinateReferenceSystem)dataSourceCRS);
        }
        return transform;
    }
}

