/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.helper;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.EntityManager;
import nl.b3p.tailormap.api.controller.GeoServiceProxyController;
import nl.b3p.tailormap.api.persistence.Application;
import nl.b3p.tailormap.api.persistence.GeoService;
import nl.b3p.tailormap.api.persistence.helper.ApplicationHelper;
import nl.b3p.tailormap.api.persistence.helper.GeoServiceHelper;
import nl.b3p.tailormap.api.persistence.helper.GeoToolsHelper;
import nl.b3p.tailormap.api.persistence.json.AppContent;
import nl.b3p.tailormap.api.persistence.json.AppTreeLayerNode;
import nl.b3p.tailormap.api.persistence.json.Bounds;
import nl.b3p.tailormap.api.persistence.json.ServicePublishingSettings;
import nl.b3p.tailormap.api.repository.ApplicationRepository;
import nl.b3p.tailormap.api.repository.ConfigurationRepository;
import nl.b3p.tailormap.api.repository.FeatureSourceRepository;
import nl.b3p.tailormap.api.repository.GeoServiceRepository;
import nl.b3p.tailormap.api.security.AuthorizationService;
import nl.b3p.tailormap.api.viewer.model.MapResponse;
import nl.b3p.tailormap.api.viewer.model.TMCoordinateReferenceSystem;
import org.geotools.referencing.util.CRSUtilities;
import org.geotools.referencing.wkt.Formattable;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApplicationHelper {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String DEFAULT_WEB_MERCATOR_CRS = "EPSG:3857";
    private final GeoServiceHelper geoServiceHelper;
    private final GeoServiceRepository geoServiceRepository;
    private final ConfigurationRepository configurationRepository;
    private final ApplicationRepository applicationRepository;
    private final FeatureSourceRepository featureSourceRepository;
    private final EntityManager entityManager;
    private final AuthorizationService authorizationService;

    public ApplicationHelper(GeoServiceHelper geoServiceHelper, GeoServiceRepository geoServiceRepository, ConfigurationRepository configurationRepository, ApplicationRepository applicationRepository, FeatureSourceRepository featureSourceRepository, EntityManager entityManager, AuthorizationService authorizationService) {
        this.geoServiceHelper = geoServiceHelper;
        this.geoServiceRepository = geoServiceRepository;
        this.configurationRepository = configurationRepository;
        this.applicationRepository = applicationRepository;
        this.featureSourceRepository = featureSourceRepository;
        this.entityManager = entityManager;
        this.authorizationService = authorizationService;
    }

    public Application getServiceApplication(String baseAppName, String projection, GeoService service) {
        Application app;
        if (baseAppName == null) {
            baseAppName = Optional.ofNullable(service.getSettings().getPublishing()).map(ServicePublishingSettings::getBaseApp).orElseGet(() -> this.configurationRepository.get("default-base-app"));
        }
        Application baseApp = null;
        if (baseAppName != null && (baseApp = this.applicationRepository.findByName(baseAppName)) != null) {
            this.entityManager.detach((Object)baseApp);
        }
        Application application = app = baseApp != null ? baseApp : new Application().setContentRoot(new AppContent());
        if (projection != null) {
            throw new UnsupportedOperationException("Projection filtering not yet supported");
        }
        projection = baseApp != null ? baseApp.getCrs() : DEFAULT_WEB_MERCATOR_CRS;
        app.setName(service.getId()).setTitle(service.getTitle()).setCrs(projection);
        return app;
    }

    @Transactional
    public MapResponse toMapResponse(Application app) {
        MapResponse mapResponse = new MapResponse();
        this.setCrsAndBounds(app, mapResponse);
        this.setLayers(app, mapResponse);
        return mapResponse;
    }

    public void setCrsAndBounds(Application a, MapResponse mapResponse) {
        CoordinateReferenceSystem gtCrs = a.getGeoToolsCoordinateReferenceSystem();
        if (gtCrs == null) {
            throw new IllegalArgumentException("Invalid CRS: " + a.getCrs());
        }
        TMCoordinateReferenceSystem crs = new TMCoordinateReferenceSystem().code(a.getCrs()).definition(((Formattable)gtCrs).toWKT(0)).bounds(GeoToolsHelper.fromCRS((CoordinateReferenceSystem)gtCrs)).unit((String)Optional.ofNullable(CRSUtilities.getUnit((CoordinateSystem)gtCrs.getCoordinateSystem())).map(Objects::toString).orElse(null));
        Bounds maxExtent = a.getMaxExtent() != null ? a.getMaxExtent() : crs.getBounds();
        Bounds initialExtent = a.getInitialExtent() != null ? a.getInitialExtent() : maxExtent;
        mapResponse.crs(crs).maxExtent(maxExtent).initialExtent(initialExtent);
    }

    public void setLayers(Application app, MapResponse mr) {
        new MapResponseLayerBuilder(this, app, mr).buildLayers();
    }

    private String getProxyUrl(GeoService geoService, Application application, AppTreeLayerNode appTreeLayerNode) {
        return WebMvcLinkBuilder.linkTo(GeoServiceProxyController.class, Map.of("viewerKind", "app", "viewerName", application.getName(), "appLayerId", appTreeLayerNode.getId(), "protocol", geoService.getProtocol().getValue())).toString();
    }
}

