/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.security;

import java.lang.invoke.MethodHandles;
import nl.b3p.tailormap.api.persistence.Group;
import nl.b3p.tailormap.api.persistence.User;
import nl.b3p.tailormap.api.repository.GroupRepository;
import nl.b3p.tailormap.api.repository.UserRepository;
import nl.b3p.tailormap.api.security.InternalAdminAuthentication;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.transaction.annotation.Transactional;

@Configuration
@Order(value=1)
public class ActuatorSecurityConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Value(value="${management.endpoints.web.base-path}")
    private String basePath;
    @Value(value="${tailormap-api.management.hashed-password}")
    private String hashedPassword;
    private final UserRepository userRepository;
    private final GroupRepository groupRepository;

    public ActuatorSecurityConfiguration(UserRepository userRepository, GroupRepository groupRepository) {
        this.userRepository = userRepository;
        this.groupRepository = groupRepository;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    @Transactional
    @DependsOn(value={"tailormap-database-initialization"})
    public void createActuatorAccount() {
        if (StringUtils.isBlank((CharSequence)this.hashedPassword)) {
            return;
        }
        InternalAdminAuthentication.setInSecurityContext();
        try {
            User account = this.userRepository.findById("actuator").orElse(null);
            if (account != null) {
                String msg = this.hashedPassword.equals(account.getPassword()) ? "with the hashed password in" : "with a different password from";
                logger.info("Actuator account already exists {} the MANAGEMENT_HASHED_ACCOUNT environment variable", (Object)msg);
            } else if (!this.hashedPassword.startsWith("{bcrypt}")) {
                logger.error("Invalid password hash, must start with {bcrypt}");
            } else {
                account = new User().setUsername("actuator").setPassword(this.hashedPassword);
                account.getGroups().add((Group)this.groupRepository.findById((Object)"actuator").orElseThrow());
                this.userRepository.save((Object)account);
                logger.info("Created {} account with hashed password for management", (Object)"actuator");
            }
        }
        finally {
            InternalAdminAuthentication.clearSecurityContextAuthentication();
        }
    }

    @Bean
    public SecurityFilterChain actuatorFilterChain(HttpSecurity http, CookieCsrfTokenRepository csrfTokenRepository) throws Exception {
        ((HttpSecurity)http.csrf().csrfTokenRepository((CsrfTokenRepository)csrfTokenRepository).and()).securityMatcher(new String[]{this.basePath + "/**"}).authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new String[]{this.basePath + "/health/**"})).permitAll().requestMatchers(new String[]{this.basePath + "/info"})).permitAll().requestMatchers(new String[]{this.basePath + "/**"})).hasAnyAuthority(new String[]{"admin", "actuator"})).httpBasic();
        return (SecurityFilterChain)http.build();
    }
}

