/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.repository.validation;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import nl.b3p.tailormap.api.geotools.featuresources.JDBCFeatureSourceHelper;
import nl.b3p.tailormap.api.geotools.featuresources.WFSFeatureSourceHelper;
import nl.b3p.tailormap.api.persistence.TMFeatureSource;
import nl.b3p.tailormap.api.util.TMExceptionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

@Component
public class FeatureSourceValidator
implements Validator {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public boolean supports(@NonNull Class<?> clazz) {
        return TMFeatureSource.class.isAssignableFrom(clazz);
    }

    public void validate(@NonNull Object target, @NonNull Errors errors) {
        TMFeatureSource featureSource = (TMFeatureSource)target;
        logger.debug("Validate {} feature source {}", (Object)featureSource.getProtocol(), (Object)featureSource);
        if (featureSource.getProtocol().equals((Object)TMFeatureSource.Protocol.WFS)) {
            this.validateWFS(featureSource, errors);
        } else if (featureSource.getProtocol().equals((Object)TMFeatureSource.Protocol.JDBC)) {
            this.validateJDBC(featureSource, errors);
        }
    }

    private void validateWFS(TMFeatureSource featureSource, Errors errors) {
        URI uri;
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"url", (String)"errors.required", (String)"URL is required");
        if (errors.hasErrors()) {
            return;
        }
        try {
            uri = new URL(featureSource.getUrl()).toURI();
        }
        catch (Exception e) {
            errors.rejectValue("url", "errors.url.invalid", "Invalid URI");
            return;
        }
        if (!"https".equals(uri.getScheme()) && !"http".equals(uri.getScheme())) {
            errors.rejectValue("url", "errors.url.invalid-scheme", "Invalid URI scheme");
            return;
        }
        if (featureSource.isRefreshCapabilities()) {
            try {
                new WFSFeatureSourceHelper().loadCapabilities(featureSource);
            }
            catch (UnknownHostException e) {
                errors.rejectValue("url", "errors.unknown-host", "Unknown host: \"" + uri.getHost() + "\"");
            }
            catch (Exception e) {
                String msg = String.format("Error loading WFS capabilities from URL \"%s\": %s", featureSource.getUrl(), TMExceptionUtils.joinAllThrowableMessages(e));
                String loggerMsg = "The following exception may not be an application error but could be a problem with an external service or user-entered data: ";
                logger.info(loggerMsg + msg, (Throwable)e);
                errors.rejectValue("url", "errors.loading-capabilities-failed", msg);
            }
        }
    }

    private void validateJDBC(TMFeatureSource featureSource, Errors errors) {
        if (featureSource.getJdbcConnection() == null) {
            errors.rejectValue("jdbcConnection", "errors.required", "JDBC connection properties are required");
            return;
        }
        if (featureSource.getAuthentication() == null) {
            errors.rejectValue("authentication", "errors.required", "Database username and password are required");
            return;
        }
        if (errors.hasErrors()) {
            return;
        }
        if (featureSource.isRefreshCapabilities()) {
            try {
                new JDBCFeatureSourceHelper().loadCapabilities(featureSource);
            }
            catch (Exception e) {
                String msg = String.format("Error loading capabilities from JDBC datastore: %s", ExceptionUtils.getRootCauseMessage((Throwable)e));
                String loggerMsg = "The following exception may not be an application error but could be a problem with an external service or user-entered data: ";
                logger.info(loggerMsg + msg, (Throwable)e);
                errors.rejectValue("url", "errors.loading-capabilities-failed", msg);
            }
        }
    }
}

