/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@Schema(name="UniqueValuesResponse", description="A -possibly empty- list of unique values of the requested attributes.")
public class UniqueValuesResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Boolean filterApplied = false;
    @Valid
    private Set<Object> values = new LinkedHashSet<Object>();

    public UniqueValuesResponse filterApplied(Boolean filterApplied) {
        this.filterApplied = filterApplied;
        return this;
    }

    @Schema(name="filterApplied", description="true if the filter was applied, false otherwise", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="filterApplied")
    public Boolean getFilterApplied() {
        return this.filterApplied;
    }

    public void setFilterApplied(Boolean filterApplied) {
        this.filterApplied = filterApplied;
    }

    public UniqueValuesResponse values(Set<Object> values) {
        this.values = values;
        return this;
    }

    public UniqueValuesResponse addValuesItem(Object valuesItem) {
        if (this.values == null) {
            this.values = new LinkedHashSet<Object>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @NotNull
    @Schema(name="values", description="list of unique values", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="values")
    public Set<Object> getValues() {
        return this.values;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setValues(Set<Object> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniqueValuesResponse uniqueValuesResponse = (UniqueValuesResponse)o;
        return Objects.equals(this.filterApplied, uniqueValuesResponse.filterApplied) && Objects.equals(this.values, uniqueValuesResponse.values);
    }

    public int hashCode() {
        return Objects.hash(this.filterApplied, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UniqueValuesResponse {\n");
        sb.append("    filterApplied: ").append(this.toIndentedString(this.filterApplied)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

