/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import nl.b3p.tailormap.api.viewer.model.AppStyling;
import nl.b3p.tailormap.api.viewer.model.Component;

@Schema(name="ViewerResponse", description="Basic viewer information")
public class ViewerResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private KindEnum kind;
    private String name;
    private String title;
    @Valid
    private List<String> baseApps;
    @Valid
    private List<String> languages = new ArrayList<String>();
    @Valid
    private List<String> projections = new ArrayList<String>();
    private AppStyling styling;
    @Valid
    private @Valid List<@Valid Component> components = new ArrayList<Component>();

    public ViewerResponse kind(KindEnum kind) {
        this.kind = kind;
        return this;
    }

    @NotNull
    @Schema(name="kind", description="Kind of viewer; a 'service' viewer has layers from a single service combined with a base viewer. A 'viewer' has content configured from various services.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="kind")
    public KindEnum getKind() {
        return this.kind;
    }

    public void setKind(KindEnum kind) {
        this.kind = kind;
    }

    public ViewerResponse name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(name="name", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ViewerResponse title(String title) {
        this.title = title;
        return this;
    }

    @NotNull
    @Schema(name="title", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ViewerResponse baseApps(List<String> baseApps) {
        this.baseApps = baseApps;
        return this;
    }

    public ViewerResponse addBaseAppsItem(String baseAppsItem) {
        if (this.baseApps == null) {
            this.baseApps = new ArrayList<String>();
        }
        this.baseApps.add(baseAppsItem);
        return this;
    }

    @Schema(name="baseApps", description="Available base apps. The first item is the default. May have one entry if only one is available. An empty list means there are no base apps available.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="baseApps")
    public List<String> getBaseApps() {
        return this.baseApps;
    }

    public void setBaseApps(List<String> baseApps) {
        this.baseApps = baseApps;
    }

    public ViewerResponse languages(List<String> languages) {
        this.languages = languages;
        return this;
    }

    public ViewerResponse addLanguagesItem(String languagesItem) {
        if (this.languages == null) {
            this.languages = new ArrayList<String>();
        }
        this.languages.add(languagesItem);
        return this;
    }

    @NotNull
    @Schema(name="languages", description="Available languages for this application. The first item is the default.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="languages")
    public List<String> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<String> languages) {
        this.languages = languages;
    }

    public ViewerResponse projections(List<String> projections) {
        this.projections = projections;
        return this;
    }

    public ViewerResponse addProjectionsItem(String projectionsItem) {
        if (this.projections == null) {
            this.projections = new ArrayList<String>();
        }
        this.projections.add(projectionsItem);
        return this;
    }

    @NotNull
    @Schema(name="projections", description="Available projections for this application. The first item is the default. Not all layers may be available in all projections.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="projections")
    public List<String> getProjections() {
        return this.projections;
    }

    public void setProjections(List<String> projections) {
        this.projections = projections;
    }

    public ViewerResponse styling(AppStyling styling) {
        this.styling = styling;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="styling", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="styling")
    public AppStyling getStyling() {
        return this.styling;
    }

    public void setStyling(AppStyling styling) {
        this.styling = styling;
    }

    public ViewerResponse components(List<@Valid Component> components) {
        this.components = components;
        return this;
    }

    public ViewerResponse addComponentsItem(Component componentsItem) {
        if (this.components == null) {
            this.components = new ArrayList<Component>();
        }
        this.components.add(componentsItem);
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="components", description="Configured components (controls) for the viewer", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="components")
    public @NotNull @Valid List<@Valid Component> getComponents() {
        return this.components;
    }

    public void setComponents(List<@Valid Component> components) {
        this.components = components;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewerResponse viewerResponse = (ViewerResponse)o;
        return Objects.equals((Object)this.kind, (Object)viewerResponse.kind) && Objects.equals(this.name, viewerResponse.name) && Objects.equals(this.title, viewerResponse.title) && Objects.equals(this.baseApps, viewerResponse.baseApps) && Objects.equals(this.languages, viewerResponse.languages) && Objects.equals(this.projections, viewerResponse.projections) && Objects.equals(this.styling, viewerResponse.styling) && Objects.equals(this.components, viewerResponse.components);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.name, this.title, this.baseApps, this.languages, this.projections, this.styling, this.components});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ViewerResponse {\n");
        sb.append("    kind: ").append(this.toIndentedString((Object)this.kind)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    baseApps: ").append(this.toIndentedString(this.baseApps)).append("\n");
        sb.append("    languages: ").append(this.toIndentedString(this.languages)).append("\n");
        sb.append("    projections: ").append(this.toIndentedString(this.projections)).append("\n");
        sb.append("    styling: ").append(this.toIndentedString(this.styling)).append("\n");
        sb.append("    components: ").append(this.toIndentedString(this.components)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum KindEnum {
        SERVICE("service"),
        APP("app");

        private String value;

        private KindEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static KindEnum fromValue(String value) {
            for (KindEnum b : KindEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

