/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.controller;

import io.micrometer.core.annotation.Timed;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.TreeSet;
import nl.b3p.tailormap.api.annotation.AppRestController;
import nl.b3p.tailormap.api.geotools.featuresources.FeatureSourceFactoryHelper;
import nl.b3p.tailormap.api.persistence.GeoService;
import nl.b3p.tailormap.api.persistence.TMFeatureType;
import nl.b3p.tailormap.api.persistence.helper.TMFeatureTypeHelper;
import nl.b3p.tailormap.api.persistence.json.GeoServiceLayer;
import nl.b3p.tailormap.api.repository.FeatureSourceRepository;
import nl.b3p.tailormap.api.viewer.model.UniqueValuesResponse;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Not;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ResponseStatusException;

@AppRestController
@Validated
@RequestMapping(path={"${tailormap-api.base-path}/{viewerKind}/{viewerName}/layer/{appLayerId}/unique/{attributeName}"}, produces={"application/json"})
public class UniqueValuesController {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final FeatureSourceFactoryHelper featureSourceFactoryHelper;
    private final FeatureSourceRepository featureSourceRepository;
    @Value(value="${tailormap-api.unique.use_geotools_unique_function:true}")
    private boolean useGeotoolsUniqueFunction;
    private final FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());

    public UniqueValuesController(FeatureSourceFactoryHelper featureSourceFactoryHelper, FeatureSourceRepository featureSourceRepository) {
        this.featureSourceFactoryHelper = featureSourceFactoryHelper;
        this.featureSourceRepository = featureSourceRepository;
    }

    @Transactional
    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    @Timed(value="get_unique_attributes", description="time spent to process get unique attributes call")
    public ResponseEntity<Serializable> getUniqueAttributes(@ModelAttribute GeoService service, @ModelAttribute GeoServiceLayer layer, @PathVariable(value="attributeName") String attributeName, @RequestParam(required=false) String filter) {
        if (StringUtils.isBlank((CharSequence)attributeName)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Attribute name is required");
        }
        TMFeatureType tmft = service.findFeatureTypeForLayer(layer, this.featureSourceRepository);
        if (tmft == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Layer does not have feature type");
        }
        if (!TMFeatureTypeHelper.getNonHiddenAttributeNames((TMFeatureType)tmft).contains(attributeName)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Attribute does not exist");
        }
        UniqueValuesResponse uniqueValuesResponse = this.getUniqueValues(tmft, attributeName, filter);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)uniqueValuesResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UniqueValuesResponse getUniqueValues(TMFeatureType tmft, String attributeName, String filter) {
        UniqueValuesResponse uniqueValuesResponse = new UniqueValuesResponse().filterApplied(Boolean.valueOf(false));
        SimpleFeatureSource fs = null;
        try {
            Not notNull;
            Filter existingFilter = null;
            if (null != filter) {
                existingFilter = ECQL.toFilter((String)filter);
            }
            logger.trace("existingFilter: {}", (Object)existingFilter);
            Not f = notNull = this.ff.not((Filter)this.ff.isNull((Expression)this.ff.property(attributeName)));
            if (null != existingFilter) {
                f = this.ff.and((Filter)notNull, existingFilter);
                uniqueValuesResponse.filterApplied(Boolean.valueOf(true));
            }
            Query q = new Query(tmft.getName(), (Filter)f);
            q.setPropertyNames(new String[]{attributeName});
            q.setSortBy(new SortBy[]{this.ff.sort(attributeName, SortOrder.ASCENDING)});
            logger.trace("Unique values query: {}", (Object)q);
            fs = this.featureSourceFactoryHelper.openGeoToolsFeatureSource(tmft);
            if (!this.useGeotoolsUniqueFunction) {
                logger.trace("Using feature visitor to get unique values");
                fs.getFeatures(q).accepts(feature -> uniqueValuesResponse.addValuesItem(feature.getProperty(attributeName).getValue()), null);
            } else {
                logger.trace("Using geotools unique collection function to get unique values");
                Function unique = this.ff.function("Collection_Unique", new Expression[]{this.ff.property(attributeName)});
                Object o = unique.evaluate((Object)fs.getFeatures(q));
                if (o instanceof Set) {
                    Set uniqueValues = (Set)o;
                    uniqueValuesResponse.setValues(new TreeSet(uniqueValues));
                }
            }
        }
        catch (CQLException e) {
            logger.error("Could not parse requested filter", (Throwable)e);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Could not parse requested filter");
        }
        catch (IOException e) {
            logger.error("Could not retrieve attribute data", (Throwable)e);
        }
        finally {
            if (fs != null) {
                fs.getDataStore().dispose();
            }
        }
        return uniqueValuesResponse;
    }
}

