/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.helper;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import nl.b3p.tailormap.api.configuration.TailormapConfig;
import nl.b3p.tailormap.api.geotools.ResponseTeeingHTTPClient;
import nl.b3p.tailormap.api.geotools.WMSServiceExceptionUtil;
import nl.b3p.tailormap.api.geotools.featuresources.WFSFeatureSourceHelper;
import nl.b3p.tailormap.api.geotools.wfs.SimpleWFSHelper;
import nl.b3p.tailormap.api.geotools.wfs.SimpleWFSLayerDescription;
import nl.b3p.tailormap.api.persistence.GeoService;
import nl.b3p.tailormap.api.persistence.TMFeatureSource;
import nl.b3p.tailormap.api.persistence.helper.GeoServiceHelper;
import nl.b3p.tailormap.api.persistence.helper.GeoToolsHelper;
import nl.b3p.tailormap.api.persistence.json.GeoServiceLayer;
import nl.b3p.tailormap.api.persistence.json.GeoServiceProtocol;
import nl.b3p.tailormap.api.persistence.json.ServiceAuthentication;
import nl.b3p.tailormap.api.persistence.json.TMServiceCapabilitiesRequest;
import nl.b3p.tailormap.api.persistence.json.TMServiceCapabilitiesRequestGetFeatureInfo;
import nl.b3p.tailormap.api.persistence.json.TMServiceCapabilitiesRequestGetMap;
import nl.b3p.tailormap.api.persistence.json.TMServiceCaps;
import nl.b3p.tailormap.api.persistence.json.TMServiceCapsCapabilities;
import nl.b3p.tailormap.api.persistence.json.TMServiceInfo;
import nl.b3p.tailormap.api.persistence.json.WMSStyle;
import nl.b3p.tailormap.api.repository.FeatureSourceRepository;
import nl.b3p.tailormap.api.viewer.model.Service;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.ServiceInfo;
import org.geotools.data.ows.AbstractOpenWebService;
import org.geotools.data.ows.Capabilities;
import org.geotools.data.ows.OperationType;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPClientFinder;
import org.geotools.ows.wms.CRSEnvelope;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.WMSCapabilities;
import org.geotools.ows.wms.WebMapServer;
import org.geotools.ows.wmts.WebMapTileServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class GeoServiceHelper {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final TailormapConfig tailormapConfig;
    private final FeatureSourceRepository featureSourceRepository;

    @Autowired
    public GeoServiceHelper(TailormapConfig tailormapConfig, FeatureSourceRepository featureSourceRepository) {
        this.tailormapConfig = tailormapConfig;
        this.featureSourceRepository = featureSourceRepository;
    }

    public Service.ServerTypeEnum guessServerTypeFromUrl(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return Service.ServerTypeEnum.GENERIC;
        }
        if (url.contains("/arcgis/")) {
            return Service.ServerTypeEnum.GENERIC;
        }
        if (url.contains("/geoserver/")) {
            return Service.ServerTypeEnum.GEOSERVER;
        }
        if (url.contains("/mapserv")) {
            return Service.ServerTypeEnum.MAPSERVER;
        }
        return Service.ServerTypeEnum.GENERIC;
    }

    public void loadServiceCapabilities(GeoService geoService) throws Exception {
        if (geoService.getProtocol() == GeoServiceProtocol.XYZ) {
            GeoServiceHelper.setXyzCapabilities((GeoService)geoService);
            return;
        }
        ResponseTeeingHTTPClient client = new ResponseTeeingHTTPClient(HTTPClientFinder.createClient(), null, Set.of("Access-Control-Allow-Origin"));
        ServiceAuthentication auth = geoService.getAuthentication();
        if (auth != null && auth.getMethod() == ServiceAuthentication.MethodEnum.PASSWORD) {
            client.setUser(auth.getUsername());
            client.setPassword(auth.getPassword());
        }
        client.setReadTimeout(this.tailormapConfig.getTimeout());
        client.setConnectTimeout(this.tailormapConfig.getTimeout());
        client.setTryGzip(true);
        logger.info("Get capabilities for {} {} from URL {}", new Object[]{geoService.getProtocol(), geoService.getId() == null ? "(new)" : "id " + geoService.getId(), geoService.getUrl()});
        switch (1.$SwitchMap$nl$b3p$tailormap$api$persistence$json$GeoServiceProtocol[geoService.getProtocol().ordinal()]) {
            case 1: {
                this.loadWMSCapabilities(geoService, client);
                break;
            }
            case 2: {
                this.loadWMTSCapabilities(geoService, client);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported geo service protocol: " + geoService.getProtocol());
            }
        }
        if (geoService.getTitle() == null) {
            geoService.setTitle((String)Optional.ofNullable(geoService.getServiceCapabilities()).map(TMServiceCaps::getServiceInfo).map(TMServiceInfo::getTitle).orElse(null));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Loaded service layers: {}", (Object)geoService.getLayers());
        } else {
            logger.info("Loaded service layers: {}", geoService.getLayers().stream().filter(Predicate.not(GeoServiceLayer::getVirtual)).map(GeoServiceLayer::getName).collect(Collectors.toList()));
        }
    }

    private static void setXyzCapabilities(GeoService geoService) {
        geoService.setLayers(List.of(new GeoServiceLayer().id("0").root(Boolean.valueOf(true)).name("xyz").title(geoService.getTitle()).virtual(Boolean.valueOf(false)).queryable(Boolean.valueOf(false))));
    }

    private void setServiceInfo(GeoService geoService, ResponseTeeingHTTPClient client, AbstractOpenWebService<? extends Capabilities, Layer> ows) {
        geoService.setCapabilities(client.getLatestResponseCopy());
        geoService.setCapabilitiesContentType("application/xml");
        geoService.setCapabilitiesFetched(Instant.now());
        ServiceInfo info = ows.getInfo();
        TMServiceCaps caps = new TMServiceCaps();
        geoService.setServiceCapabilities(caps);
        caps.setCorsAllowOrigin(client.getLatestResponse().getResponseHeader("Access-Control-Allow-Origin"));
        if (info != null) {
            if (StringUtils.isBlank((CharSequence)geoService.getTitle())) {
                geoService.setTitle(info.getTitle());
            }
            caps.serviceInfo(new TMServiceInfo().keywords(info.getKeywords()).description(info.getDescription()).title(info.getTitle()).publisher(info.getPublisher()).schema(info.getSchema()).source(info.getSource()));
            geoService.setAdvertisedUrl(info.getSource().toString());
        } else if (ows.getCapabilities() != null && ows.getCapabilities().getService() != null) {
            org.geotools.data.ows.Service service = ows.getCapabilities().getService();
            if (StringUtils.isBlank((CharSequence)geoService.getTitle())) {
                geoService.setTitle(service.getTitle());
            }
            caps.setServiceInfo(new TMServiceInfo().keywords(Set.copyOf(List.of(service.getKeywordList()))));
        }
    }

    private void setLayerList(GeoService geoService, List<? extends Layer> layers) {
        this.setLayerList(geoService, layers, (l, gsl) -> {});
    }

    private void setLayerList(GeoService geoService, List<? extends Layer> layers, BiConsumer<Layer, GeoServiceLayer> consumer) {
        geoService.setLayers(new ArrayList());
        for (Layer layer : layers) {
            GeoServiceLayer geoServiceLayer = new GeoServiceLayer().id(String.valueOf(layers.indexOf(layer))).name(layer.getName()).root(Boolean.valueOf(layer.getParent() == null)).title(layer.getTitle()).maxScale(Double.isNaN(layer.getScaleDenominatorMax()) ? null : Double.valueOf(layer.getScaleDenominatorMax())).minScale(Double.isNaN(layer.getScaleDenominatorMin()) ? null : Double.valueOf(layer.getScaleDenominatorMin())).virtual(Boolean.valueOf(layer.getName() == null)).crs(layer.getSrs()).latLonBoundingBox(GeoToolsHelper.boundsFromCRSEnvelope((CRSEnvelope)layer.getLatLonBoundingBox())).styles(layer.getStyles().stream().map(gtStyle -> {
                WMSStyle style = new WMSStyle().name(gtStyle.getName()).title((String)Optional.ofNullable(gtStyle.getTitle()).map(Objects::toString).orElse(null)).abstractText((String)Optional.ofNullable(gtStyle.getAbstract()).map(Objects::toString).orElse(null));
                try {
                    List legendURLs = gtStyle.getLegendURLs();
                    if (legendURLs != null && !legendURLs.isEmpty() && legendURLs.get(0) != null) {
                        style.legendURL(new URI((String)legendURLs.get(0)));
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                return style;
            }).collect(Collectors.toList())).queryable(Boolean.valueOf(layer.isQueryable())).abstractText(layer.get_abstract()).children(layer.getLayerChildren().stream().map(layers::indexOf).map(String::valueOf).collect(Collectors.toList()));
            if (consumer != null) {
                consumer.accept(layer, geoServiceLayer);
            }
            geoService.getLayers().add(geoServiceLayer);
        }
    }

    void loadWMSCapabilities(GeoService geoService, ResponseTeeingHTTPClient client) throws Exception {
        WebMapServer wms;
        try {
            wms = new WebMapServer(new URL(geoService.getUrl()), (HTTPClient)client);
        }
        catch (ClassCastException | IllegalStateException e) {
            String contentType = client.getLatestResponse().getContentType();
            if (contentType != null && contentType.contains("text/xml")) {
                String wmsException = WMSServiceExceptionUtil.tryGetServiceExceptionMessage((byte[])client.getLatestResponseCopy());
                throw new Exception("Error loading WMS capabilities: " + wmsException != null ? wmsException : new String(client.getLatestResponseCopy(), StandardCharsets.UTF_8));
            }
            throw e;
        }
        catch (IOException e) {
            if (e.getMessage().contains("Server returned HTTP response code: 401 for URL:")) {
                throw new Exception("Error loading WMS, got 401 unauthorized response (credentials may be required or invalid)");
            }
            throw e;
        }
        OperationType getMap = wms.getCapabilities().getRequest().getGetMap();
        OperationType getFeatureInfo = wms.getCapabilities().getRequest().getGetFeatureInfo();
        if (getMap == null) {
            throw new Exception("Service does not support GetMap");
        }
        this.setServiceInfo(geoService, client, (AbstractOpenWebService)wms);
        WMSCapabilities wmsCapabilities = wms.getCapabilities();
        geoService.getServiceCapabilities().capabilities(new TMServiceCapsCapabilities().version(wmsCapabilities.getVersion()).updateSequence(wmsCapabilities.getUpdateSequence()).abstractText(wmsCapabilities.getService().get_abstract()).request(new TMServiceCapabilitiesRequest().getMap(new TMServiceCapabilitiesRequestGetMap().formats(Set.copyOf(getMap.getFormats()))).getFeatureInfo(getFeatureInfo == null ? null : new TMServiceCapabilitiesRequestGetFeatureInfo().formats(Set.copyOf(getFeatureInfo.getFormats()))).describeLayer(Boolean.valueOf(wms.getCapabilities().getRequest().getDescribeLayer() != null))));
        if (logger.isDebugEnabled()) {
            logger.debug("Loaded capabilities, service capabilities: {}", (Object)geoService.getServiceCapabilities());
        } else {
            logger.info("Loaded capabilities from \"{}\", title: \"{}\"", (Object)geoService.getUrl(), (Object)(geoService.getServiceCapabilities() != null && geoService.getServiceCapabilities().getServiceInfo() != null ? geoService.getServiceCapabilities().getServiceInfo().getTitle() : "(none)"));
        }
        this.setLayerList(geoService, wms.getCapabilities().getLayerList());
    }

    void loadWMTSCapabilities(GeoService geoService, ResponseTeeingHTTPClient client) throws Exception {
        WebMapTileServer wmts = new WebMapTileServer(new URL(geoService.getUrl()), (HTTPClient)client);
        this.setServiceInfo(geoService, client, (AbstractOpenWebService)wmts);
        this.setLayerList(geoService, wmts.getCapabilities().getLayerList());
    }

    public Map<String, SimpleWFSLayerDescription> findRelatedWFS(GeoService geoService) {
        if (CollectionUtils.isEmpty((Collection)geoService.getLayers())) {
            return Collections.emptyMap();
        }
        List layers = geoService.getLayers().stream().filter(l -> l.getVirtual() == false).map(GeoServiceLayer::getName).filter(n -> {
            boolean noWhitespace;
            boolean bl = noWhitespace = !n.contains("(.*?)\\s(.*?)");
            if (!noWhitespace) {
                logger.warn(String.format("Not doing WFS DescribeLayer request for layer name with space: \"%s\" of WMS %s", n, geoService.getUrl()));
            }
            return noWhitespace;
        }).collect(Collectors.toList());
        Map descriptions = SimpleWFSHelper.describeWMSLayers((String)geoService.getUrl(), null, null, layers);
        for (Map.Entry entry : descriptions.entrySet()) {
            String layerName = (String)entry.getKey();
            SimpleWFSLayerDescription description = (SimpleWFSLayerDescription)entry.getValue();
            if (description.getTypeNames().length == 1 && layerName.equals(description.getFirstTypeName())) {
                logger.info(String.format("layer \"%s\" linked to feature type with same name of WFS %s", layerName, description.getWfsUrl()));
                continue;
            }
            logger.info(String.format("layer \"%s\" -> feature type(s) %s of WFS %s", layerName, Arrays.toString(description.getTypeNames()), description.getWfsUrl()));
        }
        return descriptions;
    }

    public void findAndSaveRelatedWFS(GeoService geoService) {
        if (geoService.getProtocol() != GeoServiceProtocol.WMS) {
            throw new IllegalArgumentException();
        }
        Map wfsByLayer = this.findRelatedWFS(geoService);
        wfsByLayer.values().stream().map(SimpleWFSLayerDescription::getWfsUrl).distinct().forEach(url -> {
            TMFeatureSource fs = this.featureSourceRepository.findByUrl(url);
            if (fs == null) {
                fs = new TMFeatureSource().setProtocol(TMFeatureSource.Protocol.WFS).setUrl(url).setTitle("WFS for " + geoService.getTitle()).setLinkedService(geoService);
                try {
                    new WFSFeatureSourceHelper().loadCapabilities(fs, Integer.valueOf(this.tailormapConfig.getTimeout()));
                }
                catch (IOException e) {
                    String msg = String.format("Error loading WFS from URL %s: %s: %s", url, e.getClass(), e.getMessage());
                    if (logger.isTraceEnabled()) {
                        logger.error(msg, (Throwable)e);
                    }
                    logger.error(msg);
                }
                this.featureSourceRepository.save((Object)fs);
            }
        });
    }
}

