/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.helper;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import nl.b3p.tailormap.api.persistence.json.Bounds;
import nl.b3p.tailormap.api.persistence.json.TMAttributeType;
import org.geotools.ows.wms.CRSEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.type.AttributeType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoToolsHelper {
    public static Bounds boundsFromCRSEnvelope(CRSEnvelope crsEnvelope) {
        return crsEnvelope == null ? null : new Bounds().maxx(Double.valueOf(crsEnvelope.getMaxX())).maxy(Double.valueOf(crsEnvelope.getMaxY())).minx(Double.valueOf(crsEnvelope.getMinX())).miny(Double.valueOf(crsEnvelope.getMinY()));
    }

    public static Bounds fromCRS(CoordinateReferenceSystem crs) {
        org.opengis.geometry.Envelope envelope = CRS.getEnvelope((CoordinateReferenceSystem)crs);
        return envelope == null ? null : new Bounds().maxx(Double.valueOf(envelope.getUpperCorner().getOrdinate(0))).maxy(Double.valueOf(envelope.getUpperCorner().getOrdinate(1))).minx(Double.valueOf(envelope.getLowerCorner().getOrdinate(0))).miny(Double.valueOf(envelope.getLowerCorner().getOrdinate(1)));
    }

    public static Bounds fromEnvelope(Envelope envelope) {
        return envelope == null ? null : new Bounds().maxx(Double.valueOf(envelope.getMaxX())).maxy(Double.valueOf(envelope.getMaxY())).minx(Double.valueOf(envelope.getMinX())).miny(Double.valueOf(envelope.getMinY()));
    }

    public static String crsToString(CoordinateReferenceSystem crs) {
        return crs == null ? null : CRS.toSRS((CoordinateReferenceSystem)crs);
    }

    public static TMAttributeType toAttributeType(AttributeType gtType) {
        Class binding = gtType.getBinding();
        if (binding.equals(MultiPolygon.class)) {
            return TMAttributeType.MULTIPOLYGON;
        }
        if (binding.equals(Polygon.class)) {
            return TMAttributeType.POLYGON;
        }
        if (binding.equals(MultiLineString.class)) {
            return TMAttributeType.MULTILINESTRING;
        }
        if (binding.equals(LineString.class)) {
            return TMAttributeType.LINESTRING;
        }
        if (binding.equals(MultiPoint.class)) {
            return TMAttributeType.MULTIPOINT;
        }
        if (binding.equals(Point.class)) {
            return TMAttributeType.POINT;
        }
        if (binding.equals(Geometry.class)) {
            return TMAttributeType.GEOMETRY;
        }
        if (binding.equals(GeometryCollection.class)) {
            return TMAttributeType.GEOMETRY_COLLECTION;
        }
        if (binding.equals(Boolean.class)) {
            return TMAttributeType.BOOLEAN;
        }
        if (binding.equals(Long.class) || binding.equals(Integer.class) || binding.equals(Short.class)) {
            return TMAttributeType.INTEGER;
        }
        if (binding.equals(Double.class) || binding.equals(Float.class) || binding.equals(BigDecimal.class)) {
            return TMAttributeType.DOUBLE;
        }
        if (binding.equals(String.class)) {
            return TMAttributeType.STRING;
        }
        if (binding.equals(Timestamp.class)) {
            return TMAttributeType.TIMESTAMP;
        }
        if (binding.equals(Date.class)) {
            return TMAttributeType.DATE;
        }
        return TMAttributeType.OBJECT;
    }
}

