/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.helper;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import nl.b3p.tailormap.api.persistence.Application;
import nl.b3p.tailormap.api.persistence.TMFeatureType;
import nl.b3p.tailormap.api.persistence.json.AppLayerSettings;
import nl.b3p.tailormap.api.persistence.json.AppTreeLayerNode;
import nl.b3p.tailormap.api.persistence.json.AttributeSettings;
import nl.b3p.tailormap.api.persistence.json.TMAttributeDescriptor;
import org.apache.commons.lang3.tuple.Pair;

/*
 * Exception performing whole class analysis ignored.
 */
public class TMFeatureTypeHelper {
    public static boolean isEditable(Application application, AppTreeLayerNode appTreeLayerNode, TMFeatureType featureType) {
        if (featureType == null) {
            return false;
        }
        boolean editable = false;
        if (featureType.isWriteable()) {
            AppLayerSettings appLayerSettings = application.getAppLayerSettings(appTreeLayerNode);
            editable = Optional.ofNullable(appLayerSettings).map(AppLayerSettings::getEditable).orElse(false);
        }
        return editable;
    }

    public static Map<String, Pair<TMAttributeDescriptor, AttributeSettings>> getConfiguredAttributes(TMFeatureType featureType) {
        LinkedHashSet<Object> finalAttributeOrder;
        LinkedHashMap<String, TMAttributeDescriptor> originalAttributesOrder = new LinkedHashMap<String, TMAttributeDescriptor>();
        for (TMAttributeDescriptor attributeDescriptor : featureType.getAttributes()) {
            originalAttributesOrder.put(attributeDescriptor.getName(), attributeDescriptor);
        }
        if (featureType.getSettings().getAttributeOrder().isEmpty()) {
            finalAttributeOrder = new LinkedHashSet(originalAttributesOrder.keySet());
        } else {
            finalAttributeOrder = new LinkedHashSet(featureType.getSettings().getAttributeOrder());
            finalAttributeOrder.retainAll(originalAttributesOrder.keySet());
            if (finalAttributeOrder.size() != originalAttributesOrder.size()) {
                finalAttributeOrder.addAll(originalAttributesOrder.keySet());
            }
        }
        featureType.getSettings().getHideAttributes().forEach(finalAttributeOrder::remove);
        Map attributeSettings = featureType.getSettings().getAttributeSettings();
        LinkedHashMap<String, Pair<TMAttributeDescriptor, AttributeSettings>> result = new LinkedHashMap<String, Pair<TMAttributeDescriptor, AttributeSettings>>();
        for (String string : finalAttributeOrder) {
            AttributeSettings settings = Optional.ofNullable((AttributeSettings)attributeSettings.get(string)).orElseGet(AttributeSettings::new);
            TMAttributeDescriptor attributeDescriptor = (TMAttributeDescriptor)originalAttributesOrder.get(string);
            result.put(string, (Pair<TMAttributeDescriptor, AttributeSettings>)Pair.of((Object)attributeDescriptor, (Object)settings));
        }
        return result;
    }

    public static Set<TMAttributeDescriptor> getNonHiddenAttributes(TMFeatureType featureType) {
        HashSet hiddenAttributes = new HashSet(featureType.getSettings().getHideAttributes());
        return featureType.getAttributes().stream().filter(attributeDescriptor -> !hiddenAttributes.contains(attributeDescriptor.getName())).collect(Collectors.toSet());
    }

    public static Set<String> getNonHiddenAttributeNames(TMFeatureType featureType) {
        return TMFeatureTypeHelper.getNonHiddenAttributes((TMFeatureType)featureType).stream().map(TMAttributeDescriptor::getName).collect(Collectors.toSet());
    }
}

