/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import nl.b3p.tailormap.api.persistence.json.AppLayerSettings;

@Schema(name="AppSettings", description="Settings applying to a viewer application.")
public class AppSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Valid
    private Map<String, AppLayerSettings> layerSettings = new HashMap();

    public AppSettings layerSettings(Map<String, AppLayerSettings> layerSettings) {
        this.layerSettings = layerSettings;
        return this;
    }

    public AppSettings putLayerSettingsItem(String key, AppLayerSettings layerSettingsItem) {
        if (this.layerSettings == null) {
            this.layerSettings = new HashMap();
        }
        this.layerSettings.put(key, layerSettingsItem);
        return this;
    }

    @Valid
    @Schema(name="layerSettings", description="Map of id of an AppTreeLayerNode to its' settings.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="layerSettings")
    public Map<String, AppLayerSettings> getLayerSettings() {
        return this.layerSettings;
    }

    public void setLayerSettings(Map<String, AppLayerSettings> layerSettings) {
        this.layerSettings = layerSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppSettings appSettings = (AppSettings)o;
        return Objects.equals(this.layerSettings, appSettings.layerSettings);
    }

    public int hashCode() {
        return Objects.hash(this.layerSettings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppSettings {\n");
        sb.append("    layerSettings: ").append(this.toIndentedString((Object)this.layerSettings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

