package nl.b3p.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.io.Serializable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * AppLayerSettings
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen")
public class AppLayerSettings implements Serializable {

  private static final long serialVersionUID = 1L;

  private String title = null;

  private Integer opacity = 100;

  private String attribution = null;

  private String description = null;

  private Boolean editable = null;

  public AppLayerSettings title(String title) {
    this.title = title;
    return this;
  }

  /**
   * Get title
   * @return title
  */
  
  @Schema(name = "title", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public AppLayerSettings opacity(Integer opacity) {
    this.opacity = opacity;
    return this;
  }

  /**
   * Get opacity
   * @return opacity
  */
  
  @Schema(name = "opacity", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("opacity")
  public Integer getOpacity() {
    return opacity;
  }

  public void setOpacity(Integer opacity) {
    this.opacity = opacity;
  }

  public AppLayerSettings attribution(String attribution) {
    this.attribution = attribution;
    return this;
  }

  /**
   * Attribution to show for this layer.
   * @return attribution
  */
  
  @Schema(name = "attribution", description = "Attribution to show for this layer.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("attribution")
  public String getAttribution() {
    return attribution;
  }

  public void setAttribution(String attribution) {
    this.attribution = attribution;
  }

  public AppLayerSettings description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Description to show for this layer.
   * @return description
  */
  
  @Schema(name = "description", description = "Description to show for this layer.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public AppLayerSettings editable(Boolean editable) {
    this.editable = editable;
    return this;
  }

  /**
   * Get editable
   * @return editable
  */
  
  @Schema(name = "editable", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("editable")
  public Boolean getEditable() {
    return editable;
  }

  public void setEditable(Boolean editable) {
    this.editable = editable;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AppLayerSettings appLayerSettings = (AppLayerSettings) o;
    return Objects.equals(this.title, appLayerSettings.title) &&
        Objects.equals(this.opacity, appLayerSettings.opacity) &&
        Objects.equals(this.attribution, appLayerSettings.attribution) &&
        Objects.equals(this.description, appLayerSettings.description) &&
        Objects.equals(this.editable, appLayerSettings.editable);
  }

  @Override
  public int hashCode() {
    return Objects.hash(title, opacity, attribution, description, editable);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AppLayerSettings {\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    opacity: ").append(toIndentedString(opacity)).append("\n");
    sb.append("    attribution: ").append(toIndentedString(attribution)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    editable: ").append(toIndentedString(editable)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

