package nl.b3p.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.b3p.tailormap.api.viewer.model.AppStyling;
import nl.b3p.tailormap.api.viewer.model.Component;
import java.io.Serializable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Basic viewer information
 */

@Schema(name = "ViewerResponse", description = "Basic viewer information")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen")
public class ViewerResponse implements Serializable {

  private static final long serialVersionUID = 1L;

  /**
   * Kind of viewer; a 'service' viewer has layers from a single service combined with a base viewer. A 'viewer' has content configured from various services.
   */
  public enum KindEnum {
    SERVICE("service"),
    
    APP("app");

    private String value;

    KindEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static KindEnum fromValue(String value) {
      for (KindEnum b : KindEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private KindEnum kind;

  private String name;

  private String title;

  @Valid
  private List<String> baseApps;

  @Valid
  private List<String> languages = new ArrayList<>();

  @Valid
  private List<String> projections = new ArrayList<>();

  private AppStyling styling;

  @Valid
  private List<@Valid Component> components = new ArrayList<>();

  public ViewerResponse kind(KindEnum kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Kind of viewer; a 'service' viewer has layers from a single service combined with a base viewer. A 'viewer' has content configured from various services.
   * @return kind
  */
  @NotNull 
  @Schema(name = "kind", description = "Kind of viewer; a 'service' viewer has layers from a single service combined with a base viewer. A 'viewer' has content configured from various services.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("kind")
  public KindEnum getKind() {
    return kind;
  }

  public void setKind(KindEnum kind) {
    this.kind = kind;
  }

  public ViewerResponse name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  @NotNull 
  @Schema(name = "name", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ViewerResponse title(String title) {
    this.title = title;
    return this;
  }

  /**
   * Get title
   * @return title
  */
  @NotNull 
  @Schema(name = "title", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public ViewerResponse baseApps(List<String> baseApps) {
    this.baseApps = baseApps;
    return this;
  }

  public ViewerResponse addBaseAppsItem(String baseAppsItem) {
    if (this.baseApps == null) {
      this.baseApps = new ArrayList<>();
    }
    this.baseApps.add(baseAppsItem);
    return this;
  }

  /**
   * Available base apps. The first item is the default. May have one entry if only one is available. An empty list means there are no base apps available.
   * @return baseApps
  */
  
  @Schema(name = "baseApps", description = "Available base apps. The first item is the default. May have one entry if only one is available. An empty list means there are no base apps available.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("baseApps")
  public List<String> getBaseApps() {
    return baseApps;
  }

  public void setBaseApps(List<String> baseApps) {
    this.baseApps = baseApps;
  }

  public ViewerResponse languages(List<String> languages) {
    this.languages = languages;
    return this;
  }

  public ViewerResponse addLanguagesItem(String languagesItem) {
    if (this.languages == null) {
      this.languages = new ArrayList<>();
    }
    this.languages.add(languagesItem);
    return this;
  }

  /**
   * Available languages for this application. The first item is the default.
   * @return languages
  */
  @NotNull 
  @Schema(name = "languages", description = "Available languages for this application. The first item is the default.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("languages")
  public List<String> getLanguages() {
    return languages;
  }

  public void setLanguages(List<String> languages) {
    this.languages = languages;
  }

  public ViewerResponse projections(List<String> projections) {
    this.projections = projections;
    return this;
  }

  public ViewerResponse addProjectionsItem(String projectionsItem) {
    if (this.projections == null) {
      this.projections = new ArrayList<>();
    }
    this.projections.add(projectionsItem);
    return this;
  }

  /**
   * Available projections for this application. The first item is the default. Not all layers may be available in all projections.
   * @return projections
  */
  @NotNull 
  @Schema(name = "projections", description = "Available projections for this application. The first item is the default. Not all layers may be available in all projections.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("projections")
  public List<String> getProjections() {
    return projections;
  }

  public void setProjections(List<String> projections) {
    this.projections = projections;
  }

  public ViewerResponse styling(AppStyling styling) {
    this.styling = styling;
    return this;
  }

  /**
   * Get styling
   * @return styling
  */
  @NotNull @Valid 
  @Schema(name = "styling", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("styling")
  public AppStyling getStyling() {
    return styling;
  }

  public void setStyling(AppStyling styling) {
    this.styling = styling;
  }

  public ViewerResponse components(List<@Valid Component> components) {
    this.components = components;
    return this;
  }

  public ViewerResponse addComponentsItem(Component componentsItem) {
    if (this.components == null) {
      this.components = new ArrayList<>();
    }
    this.components.add(componentsItem);
    return this;
  }

  /**
   * Configured components (controls) for the viewer
   * @return components
  */
  @NotNull @Valid 
  @Schema(name = "components", description = "Configured components (controls) for the viewer", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("components")
  public List<@Valid Component> getComponents() {
    return components;
  }

  public void setComponents(List<@Valid Component> components) {
    this.components = components;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ViewerResponse viewerResponse = (ViewerResponse) o;
    return Objects.equals(this.kind, viewerResponse.kind) &&
        Objects.equals(this.name, viewerResponse.name) &&
        Objects.equals(this.title, viewerResponse.title) &&
        Objects.equals(this.baseApps, viewerResponse.baseApps) &&
        Objects.equals(this.languages, viewerResponse.languages) &&
        Objects.equals(this.projections, viewerResponse.projections) &&
        Objects.equals(this.styling, viewerResponse.styling) &&
        Objects.equals(this.components, viewerResponse.components);
  }

  @Override
  public int hashCode() {
    return Objects.hash(kind, name, title, baseApps, languages, projections, styling, components);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ViewerResponse {\n");
    sb.append("    kind: ").append(toIndentedString(kind)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    baseApps: ").append(toIndentedString(baseApps)).append("\n");
    sb.append("    languages: ").append(toIndentedString(languages)).append("\n");
    sb.append("    projections: ").append(toIndentedString(projections)).append("\n");
    sb.append("    styling: ").append(toIndentedString(styling)).append("\n");
    sb.append("    components: ").append(toIndentedString(components)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

