/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.controller;

import io.micrometer.core.annotation.Counted;
import io.micrometer.core.annotation.Timed;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import nl.b3p.tailormap.api.annotation.AppRestController;
import nl.b3p.tailormap.api.geotools.TransformationUtil;
import nl.b3p.tailormap.api.geotools.featuresources.FeatureSourceFactoryHelper;
import nl.b3p.tailormap.api.geotools.processing.GeometryProcessor;
import nl.b3p.tailormap.api.persistence.Application;
import nl.b3p.tailormap.api.persistence.GeoService;
import nl.b3p.tailormap.api.persistence.TMFeatureType;
import nl.b3p.tailormap.api.persistence.helper.TMAttributeTypeHelper;
import nl.b3p.tailormap.api.persistence.helper.TMFeatureTypeHelper;
import nl.b3p.tailormap.api.persistence.json.AppLayerSettings;
import nl.b3p.tailormap.api.persistence.json.AppTreeLayerNode;
import nl.b3p.tailormap.api.persistence.json.GeoServiceLayer;
import nl.b3p.tailormap.api.repository.FeatureSourceRepository;
import nl.b3p.tailormap.api.util.Constants;
import nl.b3p.tailormap.api.viewer.model.Feature;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.server.ResponseStatusException;

@AppRestController
@Validated
@RequestMapping(path={"${tailormap-api.base-path}/{viewerKind}/{viewerName}/layer/{appLayerId}/edit/feature"})
public class EditFeatureController
implements Constants {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final FeatureSourceFactoryHelper featureSourceFactoryHelper;
    private final FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
    private final FeatureSourceRepository featureSourceRepository;

    public EditFeatureController(FeatureSourceFactoryHelper featureSourceFactoryHelper, FeatureSourceRepository featureSourceRepository) {
        this.featureSourceFactoryHelper = featureSourceFactoryHelper;
        this.featureSourceRepository = featureSourceRepository;
    }

    private static void checkFeatureHasOnlyValidAttributes(Feature feature, TMFeatureType tmFeatureType) {
        if (!TMFeatureTypeHelper.getNonHiddenAttributeNames(tmFeatureType).containsAll(feature.getAttributes().keySet())) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Feature cannot be edited, one or more requested attributes are not available on the feature type");
        }
    }

    @Transactional
    @PostMapping(consumes={"application/json"}, produces={"application/json"})
    @Timed(value="create_feature", description="time spent to process create feature call")
    @Counted(value="create_feature", description="number of create feature calls")
    public ResponseEntity<Serializable> createFeature(@ModelAttribute AppTreeLayerNode appTreeLayerNode, @ModelAttribute GeoService service, @ModelAttribute GeoServiceLayer layer, @ModelAttribute Application application, @RequestBody Feature completeFeature) {
        Feature newFeature;
        block16: {
            this.checkAuthentication();
            TMFeatureType tmFeatureType = this.getEditableFeatureType(application, appTreeLayerNode, service, layer);
            Map<String, Object> attributesMap = completeFeature.getAttributes();
            EditFeatureController.checkFeatureHasOnlyValidAttributes(completeFeature, tmFeatureType);
            SimpleFeatureSource fs = null;
            try (DefaultTransaction transaction = new DefaultTransaction("create");){
                SimpleFeature simpleFeature;
                fs = this.featureSourceFactoryHelper.openGeoToolsFeatureSource(tmFeatureType);
                SimpleFeatureBuilder simpleFeatureBuilder = new SimpleFeatureBuilder((SimpleFeatureType)fs.getSchema());
                if (null != completeFeature.getFid() && !completeFeature.getFid().isEmpty()) {
                    simpleFeature = simpleFeatureBuilder.buildFeature(completeFeature.getFid());
                    simpleFeature.getUserData().put(Hints.USE_PROVIDED_FID, Boolean.TRUE);
                } else {
                    simpleFeature = simpleFeatureBuilder.buildFeature(null);
                }
                EditFeatureController.handleGeometryAttributesInput(tmFeatureType, completeFeature, attributesMap, application, fs);
                for (Map.Entry<String, Object> entry : attributesMap.entrySet()) {
                    simpleFeature.setAttribute(entry.getKey(), entry.getValue());
                }
                if (fs instanceof SimpleFeatureStore) {
                    ((SimpleFeatureStore)fs).setTransaction((Transaction)transaction);
                    List newFids = ((SimpleFeatureStore)fs).addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)simpleFeature));
                    transaction.commit();
                    newFeature = EditFeatureController.getFeature(fs, (Filter)this.ff.id(new FeatureId[]{(FeatureId)newFids.get(0)}), application);
                    break block16;
                }
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Feature cannot be added, datasource is not editable");
            }
            catch (IOException | RuntimeException | FactoryException e) {
                logger.error("Error creating new feature {}", (Object)completeFeature, (Object)e);
                String message = e.getMessage();
                if (null != e.getCause() && null != e.getCause().getMessage()) {
                    message = e.getCause().getMessage();
                }
                throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, message, e);
            }
            finally {
                if (fs != null) {
                    fs.getDataStore().dispose();
                }
            }
        }
        return new ResponseEntity((Object)newFeature, HttpStatus.OK);
    }

    @Transactional
    @PatchMapping(consumes={"application/json"}, produces={"application/json"}, path={"/{fid}"})
    @Timed(value="update_feature", description="time spent to process patch feature call")
    @Counted(value="update_feature", description="number of patch feature calls")
    public ResponseEntity<Serializable> patchFeature(@ModelAttribute AppTreeLayerNode appTreeLayerNode, @ModelAttribute GeoService service, @ModelAttribute GeoServiceLayer layer, @ModelAttribute Application application, @PathVariable String fid, @RequestBody Feature partialFeature) {
        Feature patchedFeature;
        block13: {
            this.checkAuthentication();
            TMFeatureType tmFeatureType = this.getEditableFeatureType(application, appTreeLayerNode, service, layer);
            Map<String, Object> attributesMap = partialFeature.getAttributes();
            EditFeatureController.checkFeatureHasOnlyValidAttributes(partialFeature, tmFeatureType);
            SimpleFeatureSource fs = null;
            try (DefaultTransaction transaction = new DefaultTransaction("edit");){
                fs = this.featureSourceFactoryHelper.openGeoToolsFeatureSource(tmFeatureType);
                Id filter = this.ff.id(new FeatureId[]{this.ff.featureId(fid)});
                if (!fs.getFeatures((Filter)filter).isEmpty() && fs instanceof SimpleFeatureStore) {
                    EditFeatureController.handleGeometryAttributesInput(tmFeatureType, partialFeature, attributesMap, application, fs);
                    ((SimpleFeatureStore)fs).setTransaction((Transaction)transaction);
                    ((SimpleFeatureStore)fs).modifyFeatures(attributesMap.keySet().toArray(new String[0]), attributesMap.values().toArray(), (Filter)filter);
                    transaction.commit();
                    patchedFeature = EditFeatureController.getFeature(fs, (Filter)filter, application);
                    break block13;
                }
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Feature cannot be edited, it does not exist or is not editable");
            }
            catch (IOException | RuntimeException | FactoryException e) {
                logger.error("Error patching feature {}", (Object)partialFeature, (Object)e);
                String message = e.getMessage();
                if (null != e.getCause() && null != e.getCause().getMessage()) {
                    message = e.getCause().getMessage();
                }
                throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, message, e);
            }
            finally {
                if (fs != null) {
                    fs.getDataStore().dispose();
                }
            }
        }
        return new ResponseEntity((Object)patchedFeature, HttpStatus.OK);
    }

    @Transactional
    @DeleteMapping(path={"/{fid}"})
    @Timed(value="delete_feature", description="time spent to process delete feature call")
    @Counted(value="delete_feature", description="number of delete feature calls")
    public ResponseEntity<Void> deleteFeature(@ModelAttribute AppTreeLayerNode appTreeLayerNode, @ModelAttribute GeoService service, @ModelAttribute GeoServiceLayer layer, @ModelAttribute Application application, @PathVariable String fid) {
        block12: {
            this.checkAuthentication();
            TMFeatureType tmFeatureType = this.getEditableFeatureType(application, appTreeLayerNode, service, layer);
            SimpleFeatureSource fs = null;
            try (DefaultTransaction transaction = new DefaultTransaction("delete");){
                fs = this.featureSourceFactoryHelper.openGeoToolsFeatureSource(tmFeatureType);
                Id filter = this.ff.id(new FeatureId[]{this.ff.featureId(fid)});
                if (fs instanceof FeatureStore) {
                    ((FeatureStore)fs).setTransaction((Transaction)transaction);
                    ((FeatureStore)fs).removeFeatures((Filter)filter);
                    transaction.commit();
                    break block12;
                }
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Layer cannot be edited");
            }
            catch (IOException e) {
                logger.error("Error deleting feature {}", (Object)fid, (Object)e);
                throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
            }
            finally {
                if (fs != null) {
                    fs.getDataStore().dispose();
                }
            }
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private void checkAuthentication() {
        boolean isAuthenticated;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        boolean bl = isAuthenticated = authentication != null && !(authentication instanceof AnonymousAuthenticationToken);
        if (!isAuthenticated) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Not authenticated");
        }
    }

    private TMFeatureType getEditableFeatureType(Application application, AppTreeLayerNode appTreeLayerNode, GeoService service, GeoServiceLayer layer) {
        if (null == layer) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Cannot find layer " + appTreeLayerNode);
        }
        AppLayerSettings appLayerSettings = application.getAppLayerSettings(appTreeLayerNode);
        if (null == appLayerSettings || !Optional.ofNullable(appLayerSettings.getEditable()).orElse(false).booleanValue()) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Layer is not editable");
        }
        TMFeatureType tmft = service.findFeatureTypeForLayer(layer, this.featureSourceRepository);
        if (null == tmft) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Layer does not have feature type");
        }
        if (!tmft.isWriteable()) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Feature type is not writeable");
        }
        return tmft;
    }

    private static Feature getFeature(SimpleFeatureSource fs, Filter filter, Application application) throws IOException, FactoryException {
        Feature modelFeature = null;
        try (SimpleFeatureIterator feats = fs.getFeatures(filter).features();){
            if (feats.hasNext()) {
                SimpleFeature simpleFeature = (SimpleFeature)feats.next();
                modelFeature = new Feature().geometry(GeometryProcessor.processGeometry(simpleFeature.getDefaultGeometry(), false, true, TransformationUtil.getTransformationToApplication(application, fs))).fid(simpleFeature.getID());
                for (AttributeDescriptor att : simpleFeature.getFeatureType().getAttributeDescriptors()) {
                    Object value = simpleFeature.getAttribute(att.getName());
                    if (value instanceof Geometry) {
                        value = GeometryProcessor.transformGeometry((Geometry)value, TransformationUtil.getTransformationToApplication(application, fs));
                        value = GeometryProcessor.geometryToWKT((Geometry)value);
                    }
                    modelFeature.putAttributesItem(att.getLocalName(), value);
                }
            }
        }
        return modelFeature;
    }

    private static void handleGeometryAttributesInput(TMFeatureType tmFeatureType, Feature modelFeature, Map<String, Object> attributesMap, Application application, SimpleFeatureSource fs) throws FactoryException {
        MathTransform transform = TransformationUtil.getTransformationToDataSource(application, fs);
        TMFeatureTypeHelper.getNonHiddenAttributes(tmFeatureType).stream().filter(attr -> TMAttributeTypeHelper.isGeometry(attr.getType())).filter(attr -> modelFeature.getAttributes().containsKey(attr.getName())).forEach(attr -> {
            Geometry geometry = GeometryProcessor.wktToGeometry((String)modelFeature.getAttributes().get(attr.getName()));
            if (transform != null && geometry != null) {
                geometry.setSRID(Integer.parseInt(application.getCrs().substring("EPSG:".length())));
                if (logger.isTraceEnabled()) {
                    logger.trace("Transforming geometry {} from {} to {}", new Object[]{geometry.toText(), geometry.getSRID(), ((SimpleFeatureType)fs.getSchema()).getCoordinateReferenceSystem().getIdentifiers()});
                }
                geometry = GeometryProcessor.transformGeometry(geometry, transform);
            }
            attributesMap.put(attr.getName(), geometry);
        });
    }
}

