/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.controller;

import java.io.Serializable;
import java.util.Optional;
import nl.b3p.tailormap.api.annotation.AppRestController;
import nl.b3p.tailormap.api.persistence.Application;
import nl.b3p.tailormap.api.persistence.GeoService;
import nl.b3p.tailormap.api.persistence.TMFeatureType;
import nl.b3p.tailormap.api.persistence.helper.TMAttributeTypeHelper;
import nl.b3p.tailormap.api.persistence.helper.TMFeatureTypeHelper;
import nl.b3p.tailormap.api.persistence.json.AppTreeLayerNode;
import nl.b3p.tailormap.api.persistence.json.AttributeSettings;
import nl.b3p.tailormap.api.persistence.json.GeoServiceLayer;
import nl.b3p.tailormap.api.persistence.json.TMAttributeDescriptor;
import nl.b3p.tailormap.api.persistence.json.TMAttributeType;
import nl.b3p.tailormap.api.persistence.json.TMGeometryType;
import nl.b3p.tailormap.api.repository.FeatureSourceRepository;
import nl.b3p.tailormap.api.viewer.model.Attribute;
import nl.b3p.tailormap.api.viewer.model.LayerDetails;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.server.ResponseStatusException;

@AppRestController
@Validated
@RequestMapping(path={"${tailormap-api.base-path}/{viewerKind}/{viewerName}/layer/{appLayerId}/describe"}, produces={"application/json"})
public class LayerDescriptionController {
    private final FeatureSourceRepository featureSourceRepository;

    public LayerDescriptionController(FeatureSourceRepository featureSourceRepository) {
        this.featureSourceRepository = featureSourceRepository;
    }

    @Transactional
    @GetMapping
    public ResponseEntity<Serializable> getAppLayerDescription(@ModelAttribute Application application, @ModelAttribute AppTreeLayerNode appTreeLayerNode, @ModelAttribute GeoService service, @ModelAttribute GeoServiceLayer layer) {
        if (layer == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Can't find layer " + appTreeLayerNode);
        }
        TMFeatureType tmft = service.findFeatureTypeForLayer(layer, this.featureSourceRepository);
        if (tmft == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Layer does not have feature type");
        }
        LayerDetails r = new LayerDetails().id(appTreeLayerNode.getId()).serviceId(appTreeLayerNode.getServiceId()).featureTypeName(tmft.getName()).geometryAttribute(tmft.getDefaultGeometryAttribute()).geometryAttributeIndex(null).geometryType(tmft.getDefaultGeometryDescriptor().map(TMAttributeDescriptor::getType).map(TMAttributeType::getValue).map(TMGeometryType::fromValue).orElse(null)).editable(TMFeatureTypeHelper.isEditable(application, appTreeLayerNode, tmft));
        TMFeatureTypeHelper.getConfiguredAttributes(tmft).values().stream().map(pair -> {
            TMAttributeDescriptor a = (TMAttributeDescriptor)pair.getLeft();
            AttributeSettings settings = (AttributeSettings)pair.getRight();
            return new Attribute().featureType(tmft.getId()).key(a.getName()).type(TMAttributeTypeHelper.isGeometry(a.getType()) ? TMAttributeType.GEOMETRY : a.getType()).editable(!a.getName().equals(tmft.getPrimaryKeyAttribute())).editAlias(Optional.ofNullable(settings.getTitle()).orElse(a.getName())).defaultValue(a.getDefaultValue()).nullable(a.getNullable()).valueList(null).allowValueListOnly(false);
        }).forEach(r::addAttributesItem);
        return ResponseEntity.ok((Object)r);
    }
}

