/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.geotools.featuresources;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import nl.b3p.tailormap.api.geotools.featuresources.FeatureSourceHelper;
import nl.b3p.tailormap.api.persistence.TMFeatureSource;
import nl.b3p.tailormap.api.persistence.json.JDBCConnectionProperties;
import nl.b3p.tailormap.api.persistence.json.ServiceAuthentication;
import org.geotools.data.DataStore;
import org.geotools.data.sqlserver.SQLServerDataStoreFactory;
import org.geotools.jdbc.JDBCDataStoreFactory;

public class JDBCFeatureSourceHelper
extends FeatureSourceHelper {
    private static final Map<JDBCConnectionProperties.DbtypeEnum, Integer> defaultPorts = Map.of(JDBCConnectionProperties.DbtypeEnum.POSTGIS, 5432, JDBCConnectionProperties.DbtypeEnum.ORACLE, 1521, JDBCConnectionProperties.DbtypeEnum.SQLSERVER, 1433);

    @Override
    public DataStore createDataStore(TMFeatureSource tmfs, Integer timeout) throws IOException {
        if (tmfs.getProtocol() != TMFeatureSource.Protocol.JDBC) {
            throw new IllegalArgumentException(tmfs.getProtocol().getValue());
        }
        Objects.requireNonNull(tmfs.getJdbcConnection());
        Objects.requireNonNull(tmfs.getAuthentication());
        if (tmfs.getAuthentication().getMethod() != ServiceAuthentication.MethodEnum.PASSWORD) {
            throw new IllegalArgumentException(tmfs.getAuthentication().getMethod().getValue());
        }
        JDBCConnectionProperties c = tmfs.getJdbcConnection();
        Objects.requireNonNull(c.getDbtype());
        String connectionOpts = Optional.ofNullable(c.getAdditionalProperties().get("connectionOptions")).orElse("");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(JDBCDataStoreFactory.DBTYPE.key, c.getDbtype().getValue());
        params.put(JDBCDataStoreFactory.HOST.key, c.getHost());
        params.put(JDBCDataStoreFactory.PORT.key, c.getPort() != null ? c.getPort() : defaultPorts.get((Object)c.getDbtype()));
        params.put(JDBCDataStoreFactory.DATABASE.key, c.getDatabase() + connectionOpts);
        params.put(JDBCDataStoreFactory.SCHEMA.key, c.getSchema());
        params.put(JDBCDataStoreFactory.USER.key, tmfs.getAuthentication().getUsername());
        params.put(JDBCDataStoreFactory.PASSWD.key, tmfs.getAuthentication().getPassword());
        params.put(JDBCDataStoreFactory.FETCHSIZE.key, c.getFetchSize());
        params.put(JDBCDataStoreFactory.EXPOSE_PK.key, true);
        params.put(JDBCDataStoreFactory.PK_METADATA_TABLE.key, c.getPrimaryKeyMetadataTable());
        if (c.getDbtype() != JDBCConnectionProperties.DbtypeEnum.ORACLE) {
            params.put(SQLServerDataStoreFactory.GEOMETRY_METADATA_TABLE.key, "geometry_columns");
        }
        return this.openDatastore(params, JDBCDataStoreFactory.PASSWD.key);
    }
}

