/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import nl.b3p.tailormap.api.persistence.json.TMAttributeType;

public class Attribute
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long featureType;
    private String key;
    private TMAttributeType type;
    private Boolean editable;
    private String editAlias;
    private String defaultValue = null;
    private Boolean nullable;
    @Valid
    private List<String> valueList;
    private Boolean allowValueListOnly = true;

    public Attribute featureType(Long featureType) {
        this.featureType = featureType;
        return this;
    }

    @Schema(name="featureType", accessMode=Schema.AccessMode.READ_ONLY, requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="featureType")
    public Long getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(Long featureType) {
        this.featureType = featureType;
    }

    public Attribute key(String key) {
        this.key = key;
        return this;
    }

    @Schema(name="key", description="Name of the attribute.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Attribute type(TMAttributeType type) {
        this.type = type;
        return this;
    }

    @Valid
    @Schema(name="type", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="type")
    public TMAttributeType getType() {
        return this.type;
    }

    public void setType(TMAttributeType type) {
        this.type = type;
    }

    public Attribute editable(Boolean editable) {
        this.editable = editable;
        return this;
    }

    @Schema(name="editable", description="Whether the attribute can be edited.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="editable")
    public Boolean getEditable() {
        return this.editable;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public Attribute editAlias(String editAlias) {
        this.editAlias = editAlias;
        return this;
    }

    @Schema(name="editAlias", description="Alias to use in edit mode.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="editAlias")
    public String getEditAlias() {
        return this.editAlias;
    }

    public void setEditAlias(String editAlias) {
        this.editAlias = editAlias;
    }

    public Attribute defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Schema(name="defaultValue", description="Default value for this attribute. The value may need to be coerced to the correct type.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="defaultValue")
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Attribute nullable(Boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    @Schema(name="nullable", description="Whether the attribute can be null.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="nullable")
    public Boolean getNullable() {
        return this.nullable;
    }

    public void setNullable(Boolean nullable) {
        this.nullable = nullable;
    }

    public Attribute valueList(List<String> valueList) {
        this.valueList = valueList;
        return this;
    }

    public Attribute addValueListItem(String valueListItem) {
        if (this.valueList == null) {
            this.valueList = new ArrayList<String>();
        }
        this.valueList.add(valueListItem);
        return this;
    }

    @Schema(name="valueList", description="List of possible values for this attribute. The value may need to be coerced to the correct type.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="valueList")
    public List<String> getValueList() {
        return this.valueList;
    }

    public void setValueList(List<String> valueList) {
        this.valueList = valueList;
    }

    public Attribute allowValueListOnly(Boolean allowValueListOnly) {
        this.allowValueListOnly = allowValueListOnly;
        return this;
    }

    @Schema(name="allowValueListOnly", description="Whether the attribute can only have values from the valueList.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="allowValueListOnly")
    public Boolean getAllowValueListOnly() {
        return this.allowValueListOnly;
    }

    public void setAllowValueListOnly(Boolean allowValueListOnly) {
        this.allowValueListOnly = allowValueListOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return Objects.equals(this.featureType, attribute.featureType) && Objects.equals(this.key, attribute.key) && Objects.equals((Object)this.type, (Object)attribute.type) && Objects.equals(this.editable, attribute.editable) && Objects.equals(this.editAlias, attribute.editAlias) && Objects.equals(this.defaultValue, attribute.defaultValue) && Objects.equals(this.nullable, attribute.nullable) && Objects.equals(this.valueList, attribute.valueList) && Objects.equals(this.allowValueListOnly, attribute.allowValueListOnly);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.featureType, this.key, this.type, this.editable, this.editAlias, this.defaultValue, this.nullable, this.valueList, this.allowValueListOnly});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Attribute {\n");
        sb.append("    featureType: ").append(this.toIndentedString(this.featureType)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    editable: ").append(this.toIndentedString(this.editable)).append("\n");
        sb.append("    editAlias: ").append(this.toIndentedString(this.editAlias)).append("\n");
        sb.append("    defaultValue: ").append(this.toIndentedString(this.defaultValue)).append("\n");
        sb.append("    nullable: ").append(this.toIndentedString(this.nullable)).append("\n");
        sb.append("    valueList: ").append(this.toIndentedString(this.valueList)).append("\n");
        sb.append("    allowValueListOnly: ").append(this.toIndentedString(this.allowValueListOnly)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

