/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.configuration.base;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;

@Controller
public class FrontController {
    private static final AcceptHeaderLocaleResolver localeResolver = new AcceptHeaderLocaleResolver();
    private static final String DEFAULT_LOCALE;

    @GetMapping(value={"/", "/login", "/app/**", "/service/**", "/admin/**"})
    public String appIndex(HttpServletRequest request) {
        Locale locale = localeResolver.resolveLocale(request);
        return "forward:/" + locale.toLanguageTag() + "/index.html";
    }

    @GetMapping(value={"/{locale}/", "/{locale}/login", "/{locale:^(?!api)[a-zA-Z-]+}/app/**", "/{locale:^(?!api)[a-zA-Z-]+}/service/**", "/{locale:^(?!api)[a-zA-Z-]+}/admin/**"})
    public String localePrefixedAppIndex(@PathVariable(value="locale") String locale, HttpServletRequest request) {
        if (localeResolver.getSupportedLocales().stream().anyMatch(l -> l.toLanguageTag().equals(locale))) {
            return "forward:/" + locale + "/index.html";
        }
        return this.appIndex(request);
    }

    @GetMapping(value={"/swagger-ui", "/swagger-ui/"})
    public String swaggerUiWelcomePage() {
        return "redirect:/swagger-ui/index.html";
    }

    static {
        localeResolver.setSupportedLocales(List.of(new Locale("en"), new Locale("nl")));
        localeResolver.setDefaultLocale((Locale)localeResolver.getSupportedLocales().get(0));
        DEFAULT_LOCALE = Objects.requireNonNull(localeResolver.getDefaultLocale()).toLanguageTag();
    }
}

