/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.controller;

import nl.b3p.tailormap.api.annotation.AppRestController;
import nl.b3p.tailormap.api.persistence.Application;
import nl.b3p.tailormap.api.persistence.helper.ApplicationHelper;
import nl.b3p.tailormap.api.repository.ApplicationRepository;
import nl.b3p.tailormap.api.repository.ConfigurationRepository;
import nl.b3p.tailormap.api.security.AuthorizationService;
import nl.b3p.tailormap.api.viewer.model.MapResponse;
import nl.b3p.tailormap.api.viewer.model.ViewerResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.server.ResponseStatusException;

@AppRestController
public class ViewerController {
    private final ConfigurationRepository configurationRepository;
    private final ApplicationRepository applicationRepository;
    private final ApplicationHelper applicationHelper;
    private final AuthorizationService authorizationService;

    public ViewerController(ConfigurationRepository configurationRepository, ApplicationRepository applicationRepository, ApplicationHelper applicationHelper, AuthorizationService authorizationService) {
        this.configurationRepository = configurationRepository;
        this.applicationRepository = applicationRepository;
        this.applicationHelper = applicationHelper;
        this.authorizationService = authorizationService;
    }

    @GetMapping(path={"${tailormap-api.base-path}/app"})
    public ViewerResponse defaultApp() {
        String defaultAppName = this.configurationRepository.get("default-app");
        Application app = this.applicationRepository.findByName(defaultAppName);
        if (app == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND);
        }
        if (!this.authorizationService.mayUserRead(app)) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        return this.viewer(app, ViewerResponse.KindEnum.APP);
    }

    @GetMapping(path={"${tailormap-api.base-path}/app/{viewerName}", "${tailormap-api.base-path}/service/{viewerName}"})
    public ViewerResponse viewer(@ModelAttribute Application app, @ModelAttribute ViewerResponse.KindEnum viewerKind) {
        return app.getViewerResponse().kind(viewerKind);
    }

    @GetMapping(path={"${tailormap-api.base-path}/app/{viewerName}/map", "${tailormap-api.base-path}/service/{viewerName}/map"})
    public MapResponse map(@ModelAttribute Application app) {
        return this.applicationHelper.toMapResponse(app);
    }
}

