/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.geotools.featuresources;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.b3p.tailormap.api.persistence.TMFeatureSource;
import nl.b3p.tailormap.api.persistence.TMFeatureType;
import nl.b3p.tailormap.api.persistence.helper.GeoToolsHelper;
import nl.b3p.tailormap.api.persistence.json.TMAttributeDescriptor;
import nl.b3p.tailormap.api.persistence.json.TMAttributeType;
import nl.b3p.tailormap.api.persistence.json.TMFeatureTypeInfo;
import nl.b3p.tailormap.api.persistence.json.TMServiceCaps;
import nl.b3p.tailormap.api.persistence.json.TMServiceInfo;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.data.ServiceInfo;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.locationtech.jts.geom.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FeatureSourceHelper {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public DataStore createDataStore(TMFeatureSource tmfs) throws IOException {
        return this.createDataStore(tmfs, null);
    }

    public abstract DataStore createDataStore(TMFeatureSource var1, Integer var2) throws IOException;

    public SimpleFeatureSource openGeoToolsFeatureSource(TMFeatureType tmft, Integer timeout) throws IOException {
        DataStore ds = this.createDataStore(tmft.getFeatureSource(), timeout);
        return ds.getFeatureSource(tmft.getName());
    }

    public void loadCapabilities(TMFeatureSource tmfs) throws IOException {
        this.loadCapabilities(tmfs, null);
    }

    public DataStore openDatastore(Map<String, Object> params, String passwordKey) throws IOException {
        DataStore ds;
        HashMap<String, Object> logParams = new HashMap<String, Object>(params);
        String passwd = (String)params.get(passwordKey);
        if (passwd != null) {
            logParams.put(passwordKey, String.valueOf(new char[passwd.length()]).replace("\u0000", "*"));
        }
        logger.debug("Opening datastore using parameters: {}", logParams);
        try {
            ds = DataStoreFinder.getDataStore(params);
        }
        catch (Exception e) {
            throw new IOException("Cannot open datastore using parameters: " + logParams, e);
        }
        if (ds == null) {
            throw new IOException("No datastore found using parameters " + logParams);
        }
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCapabilities(TMFeatureSource tmfs, Integer timeout) throws IOException {
        DataStore ds = this.createDataStore(tmfs, timeout);
        try {
            if (ds.getInfo().getTitle() != null) {
                tmfs.setTitle(ds.getInfo().getTitle());
            }
            ServiceInfo si = ds.getInfo();
            tmfs.setServiceCapabilities(new TMServiceCaps().serviceInfo(new TMServiceInfo().title(si.getTitle()).keywords(si.getKeywords()).description(si.getDescription()).publisher(si.getPublisher()).schema(si.getSchema()).source(si.getSource())));
            List<String> typeNames = Arrays.asList(ds.getTypeNames());
            logger.info("Type names for {} {}: {}", new Object[]{tmfs.getProtocol().getValue(), tmfs.getProtocol() == TMFeatureSource.Protocol.WFS ? tmfs.getUrl() : tmfs.getJdbcConnection(), typeNames});
            tmfs.getFeatureTypes().removeIf(tmft -> {
                if (!typeNames.contains(tmft.getName())) {
                    logger.info("Feature type removed: {}", (Object)tmft.getName());
                    return true;
                }
                return false;
            });
            for (String typeName : typeNames) {
                TMFeatureType pft = tmfs.getFeatureTypes().stream().filter(ft -> ft.getName().equals(typeName)).findFirst().orElseGet(() -> new TMFeatureType().setName(typeName).setFeatureSource(tmfs).setWriteable(tmfs.getProtocol() == TMFeatureSource.Protocol.JDBC));
                if (!tmfs.getFeatureTypes().contains(pft)) {
                    tmfs.getFeatureTypes().add(pft);
                }
                try {
                    logger.debug("Get feature source from GeoTools datastore for type \"{}\"", (Object)typeName);
                    SimpleFeatureSource gtFs = ds.getFeatureSource(typeName);
                    ResourceInfo info = gtFs.getInfo();
                    if (info == null) continue;
                    pft.setTitle(info.getTitle());
                    pft.setInfo(this.getFeatureTypeInfo(pft, info, gtFs));
                    pft.getAttributes().clear();
                    SimpleFeatureType gtFt = (SimpleFeatureType)gtFs.getSchema();
                    String primaryKeyName = null;
                    for (AttributeDescriptor gtAttr : gtFt.getAttributeDescriptors()) {
                        TMAttributeDescriptor tmAttr;
                        AttributeType type = gtAttr.getType();
                        Boolean isPk = (Boolean)gtAttr.getUserData().get("org.geotools.jdbc.pk.column");
                        if (null != isPk && isPk.booleanValue()) {
                            logger.debug("Found primary key attribute \"{}\" for type \"{}\"", (Object)gtAttr.getLocalName(), (Object)typeName);
                            primaryKeyName = gtAttr.getLocalName();
                        }
                        if ((tmAttr = new TMAttributeDescriptor().name(gtAttr.getLocalName()).type(GeoToolsHelper.toAttributeType((AttributeType)type)).nullable(Boolean.valueOf(gtAttr.isNillable())).defaultValue(gtAttr.getDefaultValue() == null ? null : gtAttr.getDefaultValue().toString()).description(type.getDescription() == null ? null : type.getDescription().toString())).getType() == TMAttributeType.OBJECT) {
                            tmAttr.setUnknownTypeClassName(type.getBinding().getName());
                        }
                        pft.getAttributes().add(tmAttr);
                    }
                    pft.setPrimaryKeyAttribute(primaryKeyName);
                }
                catch (Exception e) {
                    logger.error("Exception reading feature type \"{}\"", (Object)typeName, (Object)e);
                }
            }
        }
        finally {
            ds.dispose();
        }
    }

    protected TMFeatureTypeInfo getFeatureTypeInfo(TMFeatureType pft, ResourceInfo info, SimpleFeatureSource gtFs) {
        return new TMFeatureTypeInfo().keywords(info.getKeywords()).description(info.getDescription()).bounds(GeoToolsHelper.fromEnvelope((Envelope)info.getBounds())).crs(GeoToolsHelper.crsToString((CoordinateReferenceSystem)info.getCRS()));
    }
}

